/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.event;

import dev.tazer.clutternomore.common.datamap.ListMerger;
import dev.tazer.clutternomore.common.datamap.ListRemover;
import dev.tazer.clutternomore.common.datamap.Shapes;
import dev.tazer.clutternomore.common.registry.BlockSetRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.datamaps.AdvancedDataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapValueMerger;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;

@EventBusSubscriber(modid="clutternomore")
public class DatamapHandler {
    public static final AdvancedDataMapType<Item, Shapes, ListRemover> ADD_SHAPE_DATA = AdvancedDataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"clutternomore", (String)"add_shapes"), (ResourceKey)Registries.ITEM, Shapes.CODEC).synced(Shapes.SHAPES_CODEC, true).merger((DataMapValueMerger)new ListMerger()).remover(ListRemover.CODEC).build();
    public static final AdvancedDataMapType<Item, Shapes, ListRemover> REMOVE_SHAPE_DATA = AdvancedDataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"clutternomore", (String)"remove_shapes"), (ResourceKey)Registries.ITEM, Shapes.CODEC).synced(Shapes.SHAPES_CODEC, true).merger((DataMapValueMerger)new ListMerger()).remover(ListRemover.CODEC).build();
    private static final Map<Item, List<Item>> SHAPES_DATAMAP_INTERNAL = new HashMap<Item, List<Item>>();
    private static final Map<Item, Item> INVERSE_SHAPES_DATAMAP_INTERNAL = new HashMap<Item, Item>();
    private static final Map<Item, List<Item>> REMOVE_SHAPES_DATAMAP_INTERNAL = new HashMap<Item, List<Item>>();
    public static final Map<Item, List<Item>> SHAPES_DATAMAP = Collections.unmodifiableMap(SHAPES_DATAMAP_INTERNAL);
    public static final Map<Item, Item> INVERSE_SHAPES_DATAMAP = Collections.unmodifiableMap(INVERSE_SHAPES_DATAMAP_INTERNAL);

    @SubscribeEvent
    public static void registerDataMapTypes(RegisterDataMapTypesEvent event) {
        event.register(ADD_SHAPE_DATA);
        event.register(REMOVE_SHAPE_DATA);
    }

    @SubscribeEvent
    public static void onDataMapsUpdated(DataMapsUpdatedEvent event) {
        event.ifRegistry(Registries.ITEM, registry -> {
            SHAPES_DATAMAP_INTERNAL.clear();
            INVERSE_SHAPES_DATAMAP_INTERNAL.clear();
            REMOVE_SHAPES_DATAMAP_INTERNAL.clear();
            for (Item item : registry.stream().toList()) {
                Item mainChild;
                ArrayList shapes2 = new ArrayList();
                BlockSetRegistry.ShapeSet shapeSet = (BlockSetRegistry.ShapeSet)BlockSetAPI.getBlockTypeOf((ItemLike)item, BlockSetRegistry.ShapeSet.class);
                if (shapeSet != null && item == (mainChild = shapeSet.mainChild().asItem())) {
                    shapeSet.getChildren().forEach(child -> {
                        Object patt0$temp;
                        if (child != mainChild && (patt0$temp = child.getValue()) instanceof Item) {
                            Item shape = (Item)patt0$temp;
                            shapes2.add(shape);
                        }
                    });
                }
                if (shapes2.isEmpty()) continue;
                SHAPES_DATAMAP_INTERNAL.put(item, shapes2);
            }
            registry.getDataMap(ADD_SHAPE_DATA).forEach((resourceKey, shapes) -> {
                Item item = (Item)BuiltInRegistries.ITEM.get(resourceKey);
                ArrayList items = new ArrayList();
                shapes.items().forEach(itemHolder -> items.add((Item)itemHolder.value()));
                SHAPES_DATAMAP_INTERNAL.put(item, items);
            });
            registry.getDataMap(REMOVE_SHAPE_DATA).forEach((resourceKey, shapes) -> {
                Item item = (Item)BuiltInRegistries.ITEM.get(resourceKey);
                ArrayList items = new ArrayList();
                shapes.items().forEach(itemHolder -> items.add((Item)itemHolder.value()));
                REMOVE_SHAPES_DATAMAP_INTERNAL.put(item, items);
            });
            for (Map.Entry entry : new HashSet<Map.Entry<Item, List<Item>>>(SHAPES_DATAMAP_INTERNAL.entrySet())) {
                Item item = (Item)entry.getKey();
                List shapes3 = (List)entry.getValue();
                INVERSE_SHAPES_DATAMAP_INTERNAL.remove(item);
                if (new HashSet(REMOVE_SHAPES_DATAMAP_INTERNAL.getOrDefault(item, List.of())).containsAll(shapes3)) {
                    SHAPES_DATAMAP_INTERNAL.remove(item);
                    continue;
                }
                for (Item shape : shapes3) {
                    INVERSE_SHAPES_DATAMAP_INTERNAL.put(shape, item);
                }
            }
            for (Map.Entry entry : new HashSet<Map.Entry<Item, Item>>(INVERSE_SHAPES_DATAMAP_INTERNAL.entrySet())) {
                if (SHAPES_DATAMAP_INTERNAL.containsKey(entry.getValue())) continue;
                INVERSE_SHAPES_DATAMAP_INTERNAL.remove(entry.getKey());
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        BuiltInRegistries.ITEM.stream().filter(INVERSE_SHAPES_DATAMAP::containsKey).forEach(item -> event.remove(item.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY));
    }
}

