/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.mixin;

import dev.tazer.clutternomore.common.event.DatamapHandler;
import dev.tazer.clutternomore.common.networking.ShapeTooltip;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(method={"getTooltipImage"}, at={@At(value="HEAD")}, cancellable=true)
    private void getTooltipImage(ItemStack stack, CallbackInfoReturnable<Optional<TooltipComponent>> cir) {
        Item item = stack.getItem();
        boolean hasShapes = DatamapHandler.SHAPES_DATAMAP.containsKey(item);
        boolean isShape = DatamapHandler.INVERSE_SHAPES_DATAMAP.containsKey(item);
        if (hasShapes || isShape) {
            Item originalItem = DatamapHandler.INVERSE_SHAPES_DATAMAP.getOrDefault(item, item);
            ArrayList<Item> shapes = new ArrayList<Item>((Collection)DatamapHandler.SHAPES_DATAMAP.get(originalItem));
            shapes.addFirst(originalItem);
            cir.setReturnValue(Optional.of(new ShapeTooltip(shapes, shapes.indexOf(item))));
        }
    }
}

