/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.mixin;

import dev.tazer.clutternomore.common.event.DatamapHandler;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"isSameItemSameComponents"}, at={@At(value="RETURN")}, cancellable=true)
    private static void isSameItemSameComponents(ItemStack stack, ItemStack other, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            Item item = stack.getItem();
            Item otherItem = other.getItem();
            if (DatamapHandler.SHAPES_DATAMAP.containsKey(otherItem)) {
                if (DatamapHandler.SHAPES_DATAMAP.get(otherItem).contains(item)) {
                    cir.setReturnValue((Object)true);
                }
                return;
            }
            if (DatamapHandler.SHAPES_DATAMAP.containsKey(item)) {
                if (DatamapHandler.SHAPES_DATAMAP.get(item).contains(otherItem)) {
                    cir.setReturnValue((Object)true);
                }
                return;
            }
            Item originalItem = DatamapHandler.INVERSE_SHAPES_DATAMAP.get(item);
            if (originalItem != null) {
                if (other.is(originalItem)) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                Item otherOriginalItem = DatamapHandler.INVERSE_SHAPES_DATAMAP.get(otherItem);
                if (otherOriginalItem == originalItem) {
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }
}

