/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.mixin;

import dev.tazer.clutternomore.common.event.DatamapHandler;
import dev.tazer.clutternomore.common.networking.ChangeStackPayload;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public abstract ClientPacketListener getConnection();

    @Redirect(method={"pickBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;findSlotMatchingItem(Lnet/minecraft/world/item/ItemStack;)I"))
    private int pickBlock(Inventory inventory, ItemStack targetStack) {
        int exactIndex = inventory.findSlotMatchingItem(targetStack);
        if (exactIndex != -1) {
            Item targetItem = targetStack.getItem();
            Item originalItem = DatamapHandler.INVERSE_SHAPES_DATAMAP.getOrDefault(targetItem, targetItem);
            List shapes = DatamapHandler.SHAPES_DATAMAP.getOrDefault(originalItem, List.of());
            ItemStack slotStack = (ItemStack)inventory.items.get(exactIndex);
            Item slotItem = slotStack.getItem();
            if (slotItem == originalItem || shapes.contains(slotItem)) {
                ItemStack replaced = targetStack.copyWithCount(slotStack.getCount());
                Objects.requireNonNull(this.getConnection()).send((CustomPacketPayload)new ChangeStackPayload(-1, exactIndex, replaced));
            }
        }
        return exactIndex;
    }
}

