/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.networking;

import dev.tazer.clutternomore.common.event.DatamapHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ChangeStackPayload(int containerId, int slot, ItemStack stack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChangeStackPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"clutternomore", (String)"player_change_stack"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeStackPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ChangeStackPayload::containerId, (StreamCodec)ByteBufCodecs.INT, ChangeStackPayload::slot, (StreamCodec)ItemStack.STREAM_CODEC, ChangeStackPayload::stack, ChangeStackPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleDataOnServer(ChangeStackPayload data, IPayloadContext context) {
        if (DatamapHandler.INVERSE_SHAPES_DATAMAP.containsKey(data.stack.getItem()) || DatamapHandler.SHAPES_DATAMAP.containsKey(data.stack.getItem())) {
            Item main = DatamapHandler.INVERSE_SHAPES_DATAMAP.getOrDefault(data.stack.getItem(), data.stack().getItem());
            if (data.slot == -1) {
                Item item = context.player().getItemInHand(InteractionHand.MAIN_HAND).getItem();
                if (main == item || DatamapHandler.SHAPES_DATAMAP.get(main).contains(item)) {
                    context.player().setItemInHand(InteractionHand.MAIN_HAND, data.stack);
                }
            } else {
                InventoryMenu inventory = context.player().inventoryMenu;
                Slot slot = inventory.getSlot(data.slot);
                Item item = slot.getItem().getItem();
                if (main == item || DatamapHandler.SHAPES_DATAMAP.get(main).contains(item)) {
                    slot.setByPlayer(data.stack);
                    inventory.sendAllDataToRemote();
                }
            }
        }
    }
}

