/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_7923;
import net.pixeldreamstudios.journal.client.JournalClientData;
import net.pixeldreamstudios.journal.data.MobStat;
import net.pixeldreamstudios.journal.util.MarkdownParser;

public class MobDescriptionLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<List<MarkdownParser.ParsedLine>> getDescription(class_2960 mobId, class_1309 mob) {
        class_2960 jsonPath = class_2960.method_43902((String)"journal", (String)("mobs_desc/" + mobId.method_12836() + "/" + mobId.method_12832() + ".json"));
        Optional resourceOpt = class_310.method_1551().method_1478().method_14486(jsonPath);
        if (resourceOpt.isEmpty()) {
            List<List<MarkdownParser.ParsedLine>> nsFallback = MobDescriptionLoader.getNamespaceDefaultDescription(mobId, mob);
            if (!nsFallback.isEmpty()) {
                return nsFallback;
            }
            List<List<MarkdownParser.ParsedLine>> fallback = MobDescriptionLoader.getDefaultDescription(mobId, mob);
            if (fallback.isEmpty()) return MobDescriptionLoader.getFallback(mobId, mob);
            return fallback;
        }
        try (InputStreamReader reader = new InputStreamReader(((class_3298)resourceOpt.get()).method_14482());){
            JsonElement root = JsonParser.parseReader((Reader)reader);
            if (root == null || !root.isJsonObject()) {
                List<List<MarkdownParser.ParsedLine>> nsDefault = MobDescriptionLoader.getNamespaceDefaultDescription(mobId, mob);
                if (!nsDefault.isEmpty()) {
                    List<List<MarkdownParser.ParsedLine>> list = nsDefault;
                    return list;
                }
                List<List<MarkdownParser.ParsedLine>> globalDefault = MobDescriptionLoader.getDefaultDescription(mobId, mob);
                if (!globalDefault.isEmpty()) {
                    List<List<MarkdownParser.ParsedLine>> list = globalDefault;
                    return list;
                }
                List<List<MarkdownParser.ParsedLine>> list = MobDescriptionLoader.getFallback(mobId, mob);
                return list;
            }
            JsonObject obj = root.getAsJsonObject();
            if (!obj.has("description") || !obj.get("description").isJsonArray()) {
                List<List<MarkdownParser.ParsedLine>> nsDefault = MobDescriptionLoader.getNamespaceDefaultDescription(mobId, mob);
                if (!nsDefault.isEmpty()) {
                    List<List<MarkdownParser.ParsedLine>> list = nsDefault;
                    return list;
                }
                List<List<MarkdownParser.ParsedLine>> globalDefault = MobDescriptionLoader.getDefaultDescription(mobId, mob);
                if (!globalDefault.isEmpty()) {
                    List<List<MarkdownParser.ParsedLine>> list = globalDefault;
                    return list;
                }
                List<List<MarkdownParser.ParsedLine>> list = MobDescriptionLoader.getFallback(mobId, mob);
                return list;
            }
            JsonArray desc = obj.getAsJsonArray("description");
            List<List<MarkdownParser.ParsedLine>> rows = new ArrayList<List<MarkdownParser.ParsedLine>>();
            for (JsonElement el : desc) {
                String raw = el.getAsString();
                List<MarkdownParser.ParsedLine> parsed = MarkdownParser.parse(MobDescriptionLoader.applyVariables(raw, mobId, mob));
                rows.add(parsed);
            }
            if (MarkdownParser.containsPlaceholder(rows, "{getLootDrops}")) {
                rows = MobDescriptionLoader.injectLootDrops(rows);
            }
            List<List<MarkdownParser.ParsedLine>> list = rows;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return MobDescriptionLoader.getFallback(mobId, mob);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<List<MarkdownParser.ParsedLine>> getNamespaceDefaultDescription(class_2960 mobId, class_1309 mob) {
        class_2960 fallbackJson = class_2960.method_43902((String)"journal", (String)("mobs_desc/" + mobId.method_12836() + "/default.json"));
        Optional nsRes = class_310.method_1551().method_1478().method_14486(fallbackJson);
        if (nsRes.isEmpty()) {
            return List.of();
        }
        try (InputStreamReader reader = new InputStreamReader(((class_3298)nsRes.get()).method_14482());){
            JsonElement root = JsonParser.parseReader((Reader)reader);
            if (root == null || !root.isJsonObject()) {
                List<List<MarkdownParser.ParsedLine>> list = List.of();
                return list;
            }
            JsonObject obj = root.getAsJsonObject();
            if (!obj.has("description") || !obj.get("description").isJsonArray()) {
                List<List<MarkdownParser.ParsedLine>> list = List.of();
                return list;
            }
            JsonArray desc = obj.getAsJsonArray("description");
            List<List<MarkdownParser.ParsedLine>> lines = new ArrayList<List<MarkdownParser.ParsedLine>>();
            for (JsonElement el : desc) {
                String raw = el.getAsString();
                List<MarkdownParser.ParsedLine> parsed = MarkdownParser.parse(MobDescriptionLoader.applyVariables(raw, mobId, mob));
                lines.add(parsed);
            }
            if (MarkdownParser.containsPlaceholder(lines, "{getLootDrops}")) {
                lines = MobDescriptionLoader.injectLootDrops(lines);
            }
            List<List<MarkdownParser.ParsedLine>> list = lines;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return List.of();
        }
    }

    private static List<List<MarkdownParser.ParsedLine>> getFallback(class_2960 mobId, class_1309 mob) {
        ArrayList<List<MarkdownParser.ParsedLine>> rows = new ArrayList<List<MarkdownParser.ParsedLine>>();
        rows.add(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)("\u00a76" + mob.method_5476().getString())))));
        rows.add(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)""))));
        rows.add(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)("\u00a7cHealth:\u00a7r " + mob.method_6063())))));
        rows.add(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)("\u00a77Armor:\u00a7r " + mob.method_6096())))));
        rows.add(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)"\u00a7dDrops"))));
        List<MarkdownParser.ParsedLine> drops = MobDescriptionLoader.getLootDropLines();
        if (drops.isEmpty()) {
            rows.add(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)"\u00a77(No known drops)"))));
        } else {
            rows.add(drops);
        }
        MobStat stat = JournalClientData.MOB_STATS.getOrDefault(mobId, new MobStat(0, 0));
        rows.add(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)("\u00a7aYou've killed this mob \u00a7l" + stat.kills() + "\u00a7r times.")))));
        rows.add(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)("\u00a7cThis mob has killed you \u00a7l" + stat.deaths() + "\u00a7r times.")))));
        rows.add(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)""))));
        rows.add(List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)"\u00a77Description data not available."))));
        return rows;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<List<MarkdownParser.ParsedLine>> getDefaultDescription(class_2960 mobId, class_1309 mob) {
        class_2960 fallbackJson = class_2960.method_43902((String)"journal", (String)"mobs_desc/journal/default.json");
        Optional defaultRes = class_310.method_1551().method_1478().method_14486(fallbackJson);
        if (defaultRes.isEmpty()) {
            return List.of();
        }
        try (InputStreamReader reader = new InputStreamReader(((class_3298)defaultRes.get()).method_14482());){
            JsonElement root = JsonParser.parseReader((Reader)reader);
            if (root == null || !root.isJsonObject()) {
                List<List<MarkdownParser.ParsedLine>> list = List.of();
                return list;
            }
            JsonObject obj = root.getAsJsonObject();
            if (!obj.has("description") || !obj.get("description").isJsonArray()) {
                List<List<MarkdownParser.ParsedLine>> list = List.of();
                return list;
            }
            JsonArray desc = obj.getAsJsonArray("description");
            List<List<MarkdownParser.ParsedLine>> lines = new ArrayList<List<MarkdownParser.ParsedLine>>();
            for (JsonElement el : desc) {
                String raw = el.getAsString();
                List<MarkdownParser.ParsedLine> parsed = MarkdownParser.parse(MobDescriptionLoader.applyVariables(raw, mobId, mob));
                lines.add(parsed);
            }
            if (MarkdownParser.containsPlaceholder(lines, "{getLootDrops}")) {
                lines = MobDescriptionLoader.injectLootDrops(lines);
            }
            List<List<MarkdownParser.ParsedLine>> list = lines;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return List.of();
        }
    }

    private static List<List<MarkdownParser.ParsedLine>> getEmptyJsonFallback(class_2960 mobId, class_1309 mob) {
        ArrayList<List<MarkdownParser.ParsedLine>> rows = new ArrayList<List<MarkdownParser.ParsedLine>>();
        rows.addAll(MobDescriptionLoader.getFallback(mobId, mob));
        return rows;
    }

    private static String applyVariables(String input, class_2960 mobId, class_1309 mob) {
        String result = input.replace("{mobName}", mob.method_5476().getString()).replace("{getHealth}", String.valueOf(mob.method_6063())).replace("{getArmor}", String.valueOf(mob.method_6096())).replace("{entityType}", class_7923.field_41177.method_10221((Object)mob.method_5864()).toString()).replace("{namespace}", mobId.method_12836()).replace("{path}", mobId.method_12832());
        MobStat stat = JournalClientData.MOB_STATS.getOrDefault(mobId, new MobStat(0, 0));
        boolean isTameable = mob instanceof class_1321;
        result = result.replace("{getTameable}", isTameable ? "Yes" : "No");
        String category = mob.method_5864().method_5891().method_15434();
        result = result.replace("{getCategory}", MobDescriptionLoader.capitalizeFirst(category));
        result = result.replace("{getTimesKilled}", String.valueOf(stat.kills())).replace("{getTimesDiedTo}", String.valueOf(stat.deaths()));
        return result;
    }

    private static String capitalizeFirst(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return Character.toUpperCase(text.charAt(0)) + text.substring(1);
    }

    private static List<List<MarkdownParser.ParsedLine>> injectLootDrops(List<List<MarkdownParser.ParsedLine>> lines) {
        List<MarkdownParser.ParsedLine> placeholder = List.of(new MarkdownParser.ParsedLine((class_2561)class_2561.method_43470((String)"\u00a7d{INJECT_LOOT_DROPS}")));
        MarkdownParser.replacePlaceholder(lines, "{getLootDrops}", placeholder);
        return lines;
    }

    private static List<MarkdownParser.ParsedLine> getLootDropLines() {
        ArrayList<MarkdownParser.ParsedLine> dropIcons = new ArrayList<MarkdownParser.ParsedLine>();
        for (class_1799 stack : JournalClientData.LAST_DROPS) {
            if (stack.method_7960()) continue;
            MarkdownParser.ParsedLine icon = new MarkdownParser.ParsedLine(stack);
            icon.scale = 1.0f;
            dropIcons.add(icon);
        }
        return dropIcons;
    }
}

