/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.network;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class SyncMobDropsPayload {
    public static final class_2960 ID = new class_2960("journal", "sync_mob_drops");
    private final Map<class_2960, class_1799> drops;

    public SyncMobDropsPayload(Map<class_2960, class_1799> drops) {
        this.drops = drops;
    }

    public Map<class_2960, class_1799> drops() {
        return this.drops;
    }

    public static SyncMobDropsPayload read(class_2540 buf) {
        int size = buf.method_10816();
        HashMap<class_2960, class_1799> drops = new HashMap<class_2960, class_1799>(Math.max(0, size));
        for (int i = 0; i < size; ++i) {
            class_2960 id = buf.method_10810();
            class_1799 stack = buf.method_10819();
            drops.put(id, stack);
        }
        return new SyncMobDropsPayload(drops);
    }

    public void write(class_2540 buf) {
        HashMap<class_2960, class_1799> valid = new HashMap<class_2960, class_1799>();
        for (Map.Entry<class_2960, class_1799> entry : this.drops.entrySet()) {
            class_1799 s = entry.getValue();
            if (s == null || s.method_7960() || s.method_7909() == class_1802.field_8162) continue;
            valid.put(entry.getKey(), s);
        }
        buf.method_10804(valid.size());
        for (Map.Entry<Object, Object> entry : valid.entrySet()) {
            buf.method_10812((class_2960)entry.getKey());
            buf.method_10793((class_1799)entry.getValue());
        }
    }

    public static void sendToClient(class_3222 player, Map<class_2960, class_1799> drops) {
        class_2540 buf = PacketByteBufs.create();
        new SyncMobDropsPayload(drops).write(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buf);
    }

    public static void sendToServer(Map<class_2960, class_1799> drops) {
        class_2540 buf = PacketByteBufs.create();
        new SyncMobDropsPayload(drops).write(buf);
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buf);
    }

    public static void registerS2C(S2CHandler handler) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ID, (client, netHandler, buf, responseSender) -> {
            SyncMobDropsPayload payload = SyncMobDropsPayload.read(buf);
            client.execute(() -> handler.handle(payload));
        });
    }

    public static void registerC2S(C2SHandler handler) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ID, (server, player, netHandler, buf, responseSender) -> {
            SyncMobDropsPayload payload = SyncMobDropsPayload.read(buf);
            server.execute(() -> handler.handle(player, payload));
        });
    }

    public static interface S2CHandler {
        public void handle(SyncMobDropsPayload var1);
    }

    public static interface C2SHandler {
        public void handle(class_3222 var1, SyncMobDropsPayload var2);
    }
}

