/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.network;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.pixeldreamstudios.journal.data.MobStat;

public final class SyncMobStatsPayload {
    public static final class_2960 ID = new class_2960("journal", "sync_mob_stats");
    private final Map<class_2960, MobStat> stats;

    public SyncMobStatsPayload(Map<class_2960, MobStat> stats) {
        this.stats = stats;
    }

    public Map<class_2960, MobStat> stats() {
        return this.stats;
    }

    public static SyncMobStatsPayload read(class_2540 buf) {
        int size = buf.method_10816();
        HashMap<class_2960, MobStat> stats = new HashMap<class_2960, MobStat>(Math.max(0, size));
        for (int i = 0; i < size; ++i) {
            class_2960 id = buf.method_10810();
            int kills = buf.method_10816();
            int deaths = buf.method_10816();
            stats.put(id, new MobStat(kills, deaths));
        }
        return new SyncMobStatsPayload(stats);
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.stats.size());
        for (Map.Entry<class_2960, MobStat> e : this.stats.entrySet()) {
            buf.method_10812(e.getKey());
            MobStat s = e.getValue();
            buf.method_10804(s.kills());
            buf.method_10804(s.deaths());
        }
    }

    public static void sendToClient(class_3222 player, Map<class_2960, MobStat> stats) {
        class_2540 buf = PacketByteBufs.create();
        new SyncMobStatsPayload(stats).write(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buf);
    }

    public static void sendToServer(Map<class_2960, MobStat> stats) {
        class_2540 buf = PacketByteBufs.create();
        new SyncMobStatsPayload(stats).write(buf);
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buf);
    }

    public static void registerS2C(S2CHandler handler) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ID, (client, netHandler, buf, responseSender) -> {
            SyncMobStatsPayload payload = SyncMobStatsPayload.read(buf);
            client.execute(() -> handler.handle(payload));
        });
    }

    public static void registerC2S(C2SHandler handler) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ID, (server, player, netHandler, buf, responseSender) -> {
            SyncMobStatsPayload payload = SyncMobStatsPayload.read(buf);
            server.execute(() -> handler.handle(player, payload));
        });
    }

    public static interface S2CHandler {
        public void handle(SyncMobStatsPayload var1);
    }

    public static interface C2SHandler {
        public void handle(class_3222 var1, SyncMobStatsPayload var2);
    }
}

