/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore;

import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.common.data.DynamicServerResources;
import dev.tazer.clutternomore.common.registry.BlockSetRegistry;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClutterNoMore {
    public static final String MODID = "clutternomore";
    public static final Logger LOGGER = LogManager.getLogger((String)"ClutterNoMore");

    public static void init() {
        LOGGER.info("Initializing {} on {}", (Object)MODID, (Object)Platform.INSTANCE.loader());
        BlockSetRegistry.init();
        DynamicServerResources.register();
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static void load(HolderLookup.Provider registries, RecipeManager recipeManager) {
        boolean changed = false;
        Collection originalRecipes = recipeManager.getRecipes();
        ArrayList<RecipeHolder> newRecipes = new ArrayList<RecipeHolder>();
        for (RecipeHolder recipeHolder : originalRecipes) {
            Recipe recipe = recipeHolder.value();
            Item result = recipe.getResultItem(registries).getItem();
            if (ShapeMap.isShape(result)) continue;
            NonNullList ingredients = recipe.getIngredients();
            for (Ingredient ingredient : new ArrayList(ingredients)) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    if (ShapeMap.isShape(item)) {
                        ItemStack originalStack = ShapeMap.getParent(item).getDefaultInstance();
                        originalStack.setCount(stack.getCount());
                        stacks.add(originalStack);
                        changed = true;
                        continue;
                    }
                    stacks.add(stack);
                }
                Stream newStacks = stacks.stream();
                if (!changed) continue;
                try {
                    int index = ingredients.indexOf((Object)ingredient);
                    ingredients.set(index, (Object)Ingredient.of(newStacks));
                }
                catch (Exception exception) {}
            }
            RecipeHolder newHolder = new RecipeHolder(recipeHolder.id(), recipe);
            newRecipes.add(newHolder);
        }
        if (changed) {
            recipeManager.replaceRecipes(newRecipes);
        }
    }
}

