/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore;

import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.client.ShapeSwitcherOverlay;
import dev.tazer.clutternomore.client.assets.DynamicClientResources;
import dev.tazer.clutternomore.common.mixin.SlotAccessor;
import dev.tazer.clutternomore.common.mixin.screen.ScreenAccessor;
import dev.tazer.clutternomore.common.networking.ChangeStackPayload;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClutterNoMoreClient {
    public static boolean showTooltip = false;
    public static ShapeSwitcherOverlay OVERLAY = null;

    public static void init() {
        DynamicClientResources.register();
    }

    public static void onItemTooltips(ItemStack stack, Item.TooltipContext tooltipContext, TooltipFlag tooltipFlag, List<Component> tooltip) {
        if (!showTooltip && ShapeMap.contains(stack.getItem())) {
            MutableComponent component = tooltip.getFirst().copy().append((Component)Component.literal((String)" [+]").withStyle(ChatFormatting.DARK_GRAY));
            tooltip.removeFirst();
            tooltip.addFirst((Component)component);
        }
    }

    public static void onKeyInput(int action) {
        ItemStack heldStack;
        LocalPlayer player;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen == null && (player = minecraft.player) != null && ShapeMap.contains((heldStack = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem())) {
            switch ((CNMConfig.InputType)((Object)CNMConfig.HOLD.get())) {
                case HOLD: {
                    if (OVERLAY == null && action == 1) {
                        OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                        break;
                    }
                    if (action != 0) break;
                    OVERLAY = null;
                    break;
                }
                case TOGGLE: {
                    if (action != 1) break;
                    if (OVERLAY == null) {
                        OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                        break;
                    }
                    OVERLAY = null;
                    break;
                }
                case PRESS: {
                    if (action != 1) break;
                    if (OVERLAY == null) {
                        OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, false);
                    }
                    OVERLAY.onMouseScrolled(-1);
                    OVERLAY = null;
                }
            }
        }
    }

    public static void onKeyPress(Screen screen) {
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            Slot slot = ((ScreenAccessor)screen).getSlotUnderMouse();
            if (slot != null) {
                ItemStack heldStack = slot.getItem();
                LocalPlayer player = screen.getMinecraft().player;
                if (slot.allowModification((Player)player) && ShapeMap.contains(heldStack.getItem())) {
                    switch ((CNMConfig.InputType)((Object)CNMConfig.HOLD.get())) {
                        case HOLD: {
                            showTooltip = true;
                            break;
                        }
                        case TOGGLE: {
                            showTooltip = !showTooltip;
                            break;
                        }
                        case PRESS: {
                            ClutterNoMoreClient.switchShapeInSlot((Player)player, containerScreen.getMenu().containerId, ((SlotAccessor)slot).getSlotIndex(), heldStack, -1);
                        }
                    }
                }
            }
        }
    }

    public static void onKeyRelease() {
        if (CNMConfig.HOLD.get() == CNMConfig.InputType.HOLD) {
            showTooltip = false;
        }
    }

    public static void switchShapeInSlot(Player player, int containerId, int slotId, ItemStack heldStack, int direction) {
        Item item = ShapeMap.getParent(heldStack.getItem());
        int count = heldStack.getCount();
        ArrayList<Item> shapes = new ArrayList<Item>(ShapeMap.getShapes(item));
        shapes.addFirst(item);
        int selectedIndex = shapes.indexOf(heldStack.getItem());
        int maxIndex = shapes.size() - 1;
        if ((selectedIndex -= direction) < 0) {
            selectedIndex = maxIndex;
        }
        if (selectedIndex > maxIndex) {
            selectedIndex = 0;
        }
        Item nextItem = (Item)shapes.get(selectedIndex);
        ItemStack next = nextItem.getDefaultInstance();
        next.setCount(count);
        player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.3f, 1.5f);
        if (slotId < 9) {
            slotId += 36;
        }
        ChangeStackPayload p = new ChangeStackPayload(containerId, slotId, next);
        PacketDistributor.sendToServer((CustomPacketPayload)p, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

