/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.ClutterNoMoreClient;
import dev.tazer.clutternomore.common.networking.ShapeTooltip;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;

public class ClientShapeTooltip
implements ClientTooltipComponent {
    public final List<Item> shapes;
    public int selectedIndex;

    public ClientShapeTooltip(ShapeTooltip shapeTooltip) {
        this.shapes = shapeTooltip.shapes();
        this.selectedIndex = shapeTooltip.selectedIndex();
    }

    public int getHeight() {
        return ClutterNoMoreClient.showTooltip ? 22 : 0;
    }

    public int getWidth(Font font) {
        return ClutterNoMoreClient.showTooltip ? this.shapes.size() * 22 : 0;
    }

    public void renderImage(Font font, int mouseX, int mouseY, GuiGraphics guiGraphics) {
        if (ClutterNoMoreClient.showTooltip) {
            ResourceLocation selected = ClutterNoMore.location("textures/gui/selected_shape_inventory.png");
            int spacing = 22;
            int startX = mouseX + 2;
            for (int index = 0; index < this.shapes.size(); ++index) {
                int x = startX + index * spacing;
                guiGraphics.renderItem(this.shapes.get(index).getDefaultInstance(), x, mouseY);
            }
            RenderSystem.enableBlend();
            guiGraphics.blit(selected, Mth.floor((float)(startX + this.selectedIndex * spacing)) - 3, mouseY - 3, 0.0f, 0.0f, 22, 22, 22, 22);
            RenderSystem.disableBlend();
        }
    }
}

