/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<? extends VerticalSlabBlock> CODEC = VerticalSlabBlock.simpleCodec(VerticalSlabBlock::new);
    public static final BooleanProperty DOUBLE = BooleanProperty.create((String)"double");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public VerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DOUBLE, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends VerticalSlabBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DOUBLE}).add(new Property[]{FACING}).add(new Property[]{WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Vec3 exactPos = context.getClickLocation();
        Direction direction = context.getHorizontalDirection();
        BlockState replacingBlockState = context.getLevel().getBlockState(pos);
        FluidState replacingFluidState = context.getLevel().getFluidState(pos);
        if (replacingBlockState.is((Block)this)) {
            return (BlockState)replacingBlockState.setValue((Property)DOUBLE, (Comparable)Boolean.valueOf(true));
        }
        BlockState stateForPlacement = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(replacingFluidState.getType() == Fluids.WATER));
        switch (direction) {
            case NORTH: {
                if (!(exactPos.z - (double)pos.getZ() > 0.5)) break;
                direction = direction.getOpposite();
                break;
            }
            case SOUTH: {
                if (!(exactPos.z - (double)pos.getZ() < 0.5)) break;
                direction = direction.getOpposite();
                break;
            }
            case EAST: {
                if (!(exactPos.x - (double)pos.getX() < 0.5)) break;
                direction = direction.getOpposite();
                break;
            }
            case WEST: {
                if (!(exactPos.x - (double)pos.getX() > 0.5)) break;
                direction = direction.getOpposite();
            }
        }
        return (BlockState)stateForPlacement.setValue((Property)FACING, (Comparable)direction);
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        ItemStack itemStack = context.getItemInHand();
        if (((Boolean)state.getValue((Property)DOUBLE)).booleanValue() || !itemStack.is(this.asItem())) {
            return false;
        }
        if (!context.replacingClickedOnBlock()) {
            return true;
        }
        double hitposX = context.getClickLocation().x - (double)context.getClickedPos().getX();
        double hitposZ = context.getClickLocation().z - (double)context.getClickedPos().getZ();
        Direction facingDirection = (Direction)state.getValue((Property)FACING);
        return switch (facingDirection) {
            case Direction.NORTH -> {
                if (hitposZ >= 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (hitposX <= 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (hitposZ <= 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (hitposX >= 0.5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)DOUBLE)).booleanValue()) {
            return Shapes.block();
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5);
            case Direction.EAST -> Shapes.create((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            case Direction.SOUTH -> Shapes.create((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
            case Direction.WEST -> Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0);
            default -> Shapes.block();
        };
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return (Boolean)state.getValue((Property)DOUBLE) == false;
    }

    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return state.getFluidState();
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)DOUBLE)).booleanValue()) {
            return super.placeLiquid(level, pos, state, fluidState);
        }
        return false;
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (!((Boolean)state.getValue((Property)DOUBLE)).booleanValue()) {
            return super.canPlaceLiquid(player, level, pos, state, fluid);
        }
        return false;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return (Boolean)state.getValue((Property)DOUBLE);
    }
}

