/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.registry;

import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.common.blocks.StepBlock;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Nullable;

public class BlockSetRegistry {
    public static void init() {
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)new ShapeSetRegistry());
        BlockSetAPI.addDynamicBlockRegistration(BlockSetRegistry::registerShapeBlocks, ShapeSet.class);
        BlockSetAPI.addDynamicItemRegistration(BlockSetRegistry::registerShapeItems, ShapeSet.class);
    }

    private static void registerShapeBlocks(Registrator<Block> event, Collection<ShapeSet> shapeSets) {
        for (ShapeSet set : shapeSets) {
            Block stairs;
            HorizontalDirectionalBlock block;
            Block slab;
            ResourceLocation id;
            if (((Boolean)CNMConfig.VERTICAL_SLABS.get()).booleanValue() && set.hasChild("slab") && !BuiltInRegistries.BLOCK.containsKey(id = ClutterNoMore.location(set.getVariantId("vertical", "slab"))) && (slab = Block.byItem((Item)((Item)set.getChild("slab")))).defaultBlockState().getValues().size() == 2) {
                block = new VerticalSlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Block.byItem((Item)((Item)set.getChild("slab")))));
                event.register(id, (Object)block);
                set.addChild("vertical_slab_block", block);
            }
            if (!((Boolean)CNMConfig.STEPS.get()).booleanValue() || !set.hasChild("stairs") || BuiltInRegistries.BLOCK.containsKey(id = ClutterNoMore.location(set.getVariantId("", "step"))) || (stairs = Block.byItem((Item)((Item)set.getChild("stairs")))).defaultBlockState().getValues().size() != 4) continue;
            block = new StepBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)stairs));
            event.register(id, (Object)block);
            set.addChild("step_block", block);
        }
    }

    private static void registerShapeItems(Registrator<Item> event, Collection<ShapeSet> shapeSets) {
        for (ShapeSet type : shapeSets) {
            BlockItem item;
            ResourceLocation id;
            Block block = (Block)type.getChild("vertical_slab_block");
            if (block != null && !BuiltInRegistries.ITEM.containsKey(id = ClutterNoMore.location(type.getVariantId("vertical", "slab")))) {
                item = new BlockItem(block, new Item.Properties());
                event.register(id, (Object)item);
                type.addChild("vertical_slab", item);
            }
            if ((block = (Block)type.getChild("step_block")) == null || BuiltInRegistries.ITEM.containsKey(id = ClutterNoMore.location(type.getVariantId("", "step")))) continue;
            item = new BlockItem(block, new Item.Properties());
            event.register(id, (Object)item);
            type.addChild("step", item);
        }
    }

    private static String stripSuffix(String path, String suffix) {
        if (path.endsWith("_" + suffix)) {
            return path.substring(0, path.length() - suffix.length() - 1);
        }
        if (path.endsWith(suffix)) {
            return path.substring(0, path.length() - suffix.length());
        }
        return path;
    }

    private static String stripPrefix(String path, String prefix) {
        if (path.startsWith(prefix + "_")) {
            return path.substring(prefix.length() + 1);
        }
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        return path;
    }

    public static class ShapeSetRegistry
    extends BlockTypeRegistry<ShapeSet> {
        public static final ShapeSet STONE = new ShapeSet(ResourceLocation.withDefaultNamespace((String)"stone"), Blocks.STONE);

        protected ShapeSetRegistry() {
            super(ShapeSet.class, "shape_set");
        }

        public Optional<ShapeSet> detectTypeFromBlock(Block block, ResourceLocation blockId) {
            if (block.asItem() != Items.AIR && ShapeSetRegistry.isParentBlock(blockId)) {
                return Optional.of(new ShapeSet(blockId, block));
            }
            return Optional.empty();
        }

        private static boolean has(ResourceLocation block) {
            return BuiltInRegistries.BLOCK.containsKey(block);
        }

        private static boolean isParentBlock(ResourceLocation block) {
            List<String> namespaces = List.of(block.getNamespace(), "minecraft");
            String path = block.getPath();
            List<String> parentSuffixes = List.of("log", "planks", "block");
            List<String> ignoredSuffixes = List.of("block");
            Map<String, String> replacements = Map.of("log", "wood");
            List<String> prefixes = List.of("spiked");
            List<String> ignoredPrefixes = List.of("stripped");
            List<String> suffixes = List.of("stairs", "slab", "wall");
            for (String namespace : namespaces) {
                ResourceLocation candidate;
                ResourceLocation base = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
                String suffixBase = path;
                for (String string : ignoredSuffixes) {
                    suffixBase = BlockSetRegistry.stripSuffix(suffixBase, string);
                }
                for (String string : parentSuffixes) {
                    ResourceLocation candidate2;
                    String suffixed = suffixBase + "_" + string;
                    if (suffixed.equals(path) || !ShapeSetRegistry.has(candidate2 = base.withPath(p -> suffixed))) continue;
                    return false;
                }
                for (Map.Entry entry : replacements.entrySet()) {
                    ResourceLocation candidate2;
                    String replaced = path.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    if (replaced.equals(path) || !ShapeSetRegistry.has(candidate2 = base.withPath(p -> replaced))) continue;
                    return true;
                }
                String prefixBase = path;
                for (String ignored : ignoredPrefixes) {
                    prefixBase = BlockSetRegistry.stripPrefix(prefixBase, ignored);
                }
                for (String prefix : prefixes) {
                    String prefixed = prefix + "_" + prefixBase;
                    if (prefixed.equals(path) || !ShapeSetRegistry.has(candidate = base.withPath(p -> prefixed))) continue;
                    return true;
                }
                for (String parent : parentSuffixes) {
                    suffixBase = BlockSetRegistry.stripSuffix(suffixBase, parent);
                }
                for (String suffix : suffixes) {
                    ResourceLocation candidate3;
                    String trimmed;
                    String suffixed;
                    if (suffixBase.endsWith("s") && !(suffixed = (trimmed = suffixBase.substring(0, suffixBase.length() - 1)) + "_" + suffix).equals(path) && ShapeSetRegistry.has(candidate3 = base.withPath(p -> suffixed))) {
                        return true;
                    }
                    String suffixed2 = suffixBase + "_" + suffix;
                    if (suffixed2.equals(path) || !ShapeSetRegistry.has(candidate = base.withPath(p -> suffixed2))) continue;
                    return true;
                }
            }
            return false;
        }

        public ShapeSet getDefaultType() {
            return STONE;
        }
    }

    public static class ShapeSet
    extends BlockType {
        private final ResourceLocation id;
        private final Block block;

        ShapeSet(ResourceLocation id, Block block) {
            super(id);
            this.id = id;
            this.block = block;
        }

        protected void initializeChildrenBlocks() {
            this.addChild("block", this.block);
        }

        public String getVariantId(String prefix, String postfix) {
            Object name = prefix + (prefix.isEmpty() ? "" : "_") + this.getTypeName();
            List<String> suffixes = List.of("_block", "_planks", "s");
            for (String suffix : suffixes) {
                if (!((String)name).endsWith(suffix)) continue;
                name = ((String)name).substring(0, ((String)name).length() - suffix.length());
                break;
            }
            return (String)name + (postfix.isEmpty() ? "" : "_") + postfix;
        }

        @Nullable
        protected Item findRelatedEntry(String prefix, String postfix) {
            String basePath = this.id.getPath();
            List<String> parentSuffixes = List.of("block", "planks");
            for (String parent : parentSuffixes) {
                basePath = BlockSetRegistry.stripSuffix(basePath, parent);
            }
            List<String> ignoredPrefixes = List.of("stripped");
            Object reapplyPrefix = "";
            for (String ignored : ignoredPrefixes) {
                if (!this.id.getPath().startsWith(ignored + "_")) continue;
                reapplyPrefix = ignored + "_";
                basePath = BlockSetRegistry.stripPrefix(basePath, ignored);
            }
            Object prefixPart = prefix.isEmpty() ? "" : prefix + "_";
            Object postfixPart = postfix.isEmpty() ? "" : "_" + postfix;
            ArrayList<String> candidates = new ArrayList<String>();
            if (basePath.endsWith("s")) {
                candidates.add(basePath.substring(0, basePath.length() - 1));
            }
            candidates.add(basePath);
            for (String stem : candidates) {
                String candidatePath = (String)reapplyPrefix + (String)prefixPart + stem + (String)postfixPart;
                ResourceLocation candidateId = this.id.withPath(p -> candidatePath);
                Optional found = BuiltInRegistries.ITEM.getOptional(candidateId);
                if (!found.isPresent()) continue;
                return (Item)found.get();
            }
            return null;
        }

        @Nullable
        protected Item findRelatedEntry(String postfix) {
            return this.findRelatedEntry("", postfix);
        }

        @Nullable
        protected Item getWood() {
            String path = this.id.getPath();
            if (path.endsWith("log")) {
                String stem = path.substring(0, path.length() - 3);
                ResourceLocation woodId = this.id.withPath(p -> stem + "wood");
                return BuiltInRegistries.ITEM.getOptional(woodId).orElse(null);
            }
            return null;
        }

        protected void initializeChildrenItems() {
            Item wood;
            List<String> postfixes = List.of("stairs", "slab", "wall");
            for (String postfix : postfixes) {
                Item found = this.findRelatedEntry(postfix);
                if (found == null) continue;
                this.addChild(postfix, found);
            }
            Item spiked = this.findRelatedEntry("spiked", "");
            if (spiked != null) {
                this.addChild("spiked", spiked);
            }
            if ((wood = this.getWood()) != null) {
                this.addChild("wood", wood);
            }
        }

        public String getTranslationKey() {
            return "shape_set." + this.getNamespace() + "." + this.getTypeName();
        }

        public Block mainChild() {
            return this.block;
        }
    }
}

