/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.registry;

import dev.tazer.clutternomore.ClutterNoMore;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class CommonRegistry {
    public static <R, T extends R> Supplier<T> register(String name, Supplier<T> supplier, Registry<R> reg) {
        Object object = supplier.get();
        Registry.register(reg, (ResourceLocation)ClutterNoMore.location(name), object);
        return () -> object;
    }

    public static <T> Supplier<DataComponentType<T>> registerComponentType(String name, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return CommonRegistry.register(name, () -> ((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build(), BuiltInRegistries.DATA_COMPONENT_TYPE);
    }

    public static <B extends Item> Supplier<B> registerItem(String name, Supplier<B> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.ITEM);
    }

    public static <B extends Block> Supplier<B> registerBlock(String name, Supplier<B> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.BLOCK);
    }

    public static <T extends EntityType<?>> Supplier<T> registerEntity(String name, Supplier<T> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.ENTITY_TYPE);
    }

    public static Supplier<SoundEvent> registerSoundEvent(String name, Supplier<SoundEvent> supplier) {
        return CommonRegistry.register(name, supplier, BuiltInRegistries.SOUND_EVENT);
    }

    public static Supplier<SoundEvent> registerSoundEvent(String name) {
        return CommonRegistry.registerSoundEvent(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ClutterNoMore.location(name)));
    }

    public static Holder<MobEffect> registerMobEffect(String name, Supplier<MobEffect> supplier) {
        return Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)ClutterNoMore.location(name), (Object)supplier.get());
    }
}

