/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.shape_map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class ShapeMapHandler
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().create();

    public ShapeMapHandler() {
        super(GSON, "shape_map");
    }

    protected void apply(Map<ResourceLocation, JsonElement> file, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, List<ResourceLocation>> result = new HashMap<ResourceLocation, List<ResourceLocation>>();
        HashMap<String, ShapeMapFile> namespaceMap = new HashMap<String, ShapeMapFile>();
        for (Map.Entry<ResourceLocation, JsonElement> fileEntry : file.entrySet()) {
            ResourceLocation fileName = fileEntry.getKey();
            String path = fileName.getPath();
            if (!path.equals("add_shapes") && !path.equals("remove_shapes")) continue;
            HashMap fileShapeMap = new HashMap();
            JsonObject content = fileEntry.getValue().getAsJsonObject();
            for (Map.Entry contentEntry : content.entrySet()) {
                ResourceLocation key = ResourceLocation.parse((String)((String)contentEntry.getKey()));
                ArrayList<ResourceLocation> values = new ArrayList<ResourceLocation>();
                for (JsonElement element : ((JsonElement)contentEntry.getValue()).getAsJsonArray()) {
                    values.add(ResourceLocation.parse((String)element.getAsString()));
                }
                fileShapeMap.put(key, values);
            }
            String namespace = fileName.getNamespace();
            ShapeMapFile namespaceShapeMap = namespaceMap.computeIfAbsent(namespace, s -> new ShapeMapFile(new HashMap<ResourceLocation, List<ResourceLocation>>(), new HashMap<ResourceLocation, List<ResourceLocation>>()));
            if (path.equals("add_shapes")) {
                namespaceShapeMap.addMap().putAll(fileShapeMap);
                continue;
            }
            namespaceShapeMap.removeMap().putAll(fileShapeMap);
        }
        for (ShapeMapFile shapeMapFile : namespaceMap.values()) {
            result.putAll(shapeMapFile.getResultingMap());
        }
        ShapeMap.set(result);
    }

    private record ShapeMapFile(Map<ResourceLocation, List<ResourceLocation>> addMap, Map<ResourceLocation, List<ResourceLocation>> removeMap) {
        public Map<ResourceLocation, List<ResourceLocation>> getResultingMap() {
            for (Map.Entry<ResourceLocation, List<ResourceLocation>> entry : new HashSet<Map.Entry<ResourceLocation, List<ResourceLocation>>>(this.removeMap.entrySet())) {
                ResourceLocation key = entry.getKey();
                List<ResourceLocation> removeList = entry.getValue();
                List<ResourceLocation> list = this.addMap.get(key);
                if (list == null || !list.removeAll(removeList) || !list.isEmpty()) continue;
                this.addMap.remove(key);
            }
            return this.addMap;
        }
    }
}

