/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.neoforge;

import dev.tazer.clutternomore.ClutterNoMoreClient;
import dev.tazer.clutternomore.client.ClientShapeTooltip;
import dev.tazer.clutternomore.common.networking.ShapeTooltip;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="clutternomore", value={Dist.CLIENT})
public class ClientEvents {
    public static final Lazy<KeyMapping> SHAPE_KEY = Lazy.of(() -> new KeyMapping("key.clutternomore.change_block_shape", 342, "key.categories.inventory"));

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)SHAPE_KEY.get());
    }

    @SubscribeEvent
    public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ShapeTooltip.class, ClientShapeTooltip::new);
    }

    @SubscribeEvent
    public static void onItemTooltips(ItemTooltipEvent event) {
        ClutterNoMoreClient.onItemTooltips(event.getItemStack(), event.getContext(), event.getFlags(), event.getToolTip());
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        int action = event.getAction();
        if (event.getKey() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClutterNoMoreClient.onKeyInput(action);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.MouseButton.Post event) {
        int action = event.getAction();
        if (event.getButton() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClutterNoMoreClient.onKeyInput(action);
        }
    }

    @SubscribeEvent
    public static void onMouseScrolling(InputEvent.MouseScrollingEvent event) {
        int direction = (int)event.getScrollDeltaY();
        if (ClutterNoMoreClient.OVERLAY != null) {
            ClutterNoMoreClient.OVERLAY.onMouseScrolled(direction);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onScreenScroll(ScreenEvent.MouseScrolled.Post event) {
        Screen screen;
        if (ClutterNoMoreClient.showTooltip && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
            ItemStack heldStack;
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot slot = screen2.getSlotUnderMouse();
            LocalPlayer player = screen2.getMinecraft().player;
            if (slot != null && slot.allowModification((Player)player) && ShapeMap.contains((heldStack = slot.getItem()).getItem())) {
                ClutterNoMoreClient.switchShapeInSlot((Player)player, screen2.getMenu().containerId, slot.getSlotIndex(), heldStack, (int)event.getScrollDeltaY());
            }
        }
    }

    @SubscribeEvent
    public static void onScreenInput(ScreenEvent.KeyPressed.Post event) {
        if (event.getKeyCode() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClutterNoMoreClient.onKeyPress(event.getScreen());
        }
    }

    @SubscribeEvent
    public static void onScreenInput(ScreenEvent.MouseButtonPressed.Post event) {
        if (event.getButton() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClutterNoMoreClient.onKeyPress(event.getScreen());
        }
    }

    @SubscribeEvent
    public static void onScreenInput(ScreenEvent.KeyReleased.Post event) {
        if (event.getKeyCode() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClutterNoMoreClient.onKeyRelease();
        }
    }

    @SubscribeEvent
    public static void onScreenInput(ScreenEvent.MouseButtonReleased.Post event) {
        if (event.getButton() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClutterNoMoreClient.onKeyRelease();
        }
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        if (ClutterNoMoreClient.OVERLAY != null && ClutterNoMoreClient.OVERLAY.render) {
            ClutterNoMoreClient.OVERLAY.render(event.getGuiGraphics(), event.getPartialTick().getGameTimeDeltaTicks());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        if (ClutterNoMoreClient.OVERLAY != null && !ClutterNoMoreClient.OVERLAY.shouldStayOpenThisTick()) {
            ClutterNoMoreClient.OVERLAY = null;
        }
    }
}

