/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.neoforge;

import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.ClutterNoMoreClient;
import dev.tazer.clutternomore.common.networking.ChangeStackPayload;
import dev.tazer.clutternomore.common.shape_map.ShapeMapHandler;
import dev.tazer.clutternomore.neoforge.CReloadListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="clutternomore")
public class NeoForgeEntrypoint {
    public static final Logger LOGGER = LogManager.getLogger((String)"ClutterNoMore");

    public NeoForgeEntrypoint(IEventBus modEventBus, ModContainer modContainer, Dist dist) {
        ClutterNoMore.init();
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)CNMConfig.STARTUP_CONFIG);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CNMConfig.CLIENT_CONFIG);
        if (dist.isClient()) {
            ClutterNoMoreClient.init();
        }
        modEventBus.addListener(NeoForgeEntrypoint::registerPayloadHandlers);
        NeoForge.EVENT_BUS.addListener(NeoForgeEntrypoint::addReloadListeners);
        NeoForge.EVENT_BUS.addListener(NeoForgeEntrypoint::onServerStarted);
    }

    private static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(ChangeStackPayload.TYPE, ChangeStackPayload.STREAM_CODEC, ChangeStackPayload::handleDataOnServer);
    }

    private static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        ClutterNoMore.load((HolderLookup.Provider)server.registryAccess(), server.getRecipeManager());
    }

    private static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new CReloadListener(event.getServerResources()));
        event.addListener((PreparableReloadListener)new ShapeMapHandler());
    }
}

