/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client.assets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.common.registry.BlockSetRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

public final class VerticalSlabGenerator
implements AssetGenerator {
    public static List<String> VERTICAL_SLABS = new ArrayList<String>();

    @Override
    public void initialize(class_3300 manager, ResourceSink sink) {
        VERTICAL_SLABS.clear();
    }

    @Override
    public void generate(class_1792 item, class_3300 manager, ResourceSink sink) {
        BlockSetRegistry.ShapeSet set = (BlockSetRegistry.ShapeSet)BlockSetAPI.getBlockTypeOf((class_1935)item, BlockSetRegistry.ShapeSet.class);
        if (set == null || !set.hasChild("vertical_slab_block") || item != set.getChild("slab")) {
            return;
        }
        class_2960 key = class_7923.field_41178.method_10221((Object)item);
        String name = VerticalSlabGenerator.verticalSlabName(key.method_12832());
        VERTICAL_SLABS.add(name);
        class_2960 id = ClutterNoMore.location(name);
        String modelPath = this.getModel(manager, key);
        if (modelPath == null) {
            return;
        }
        class_2960 sourceModel = class_2960.method_60654((String)modelPath).method_45134(path -> "models/" + path + ".json");
        Optional modelResource = manager.method_14486(sourceModel);
        String bottom = null;
        String side = null;
        String top = null;
        if (modelResource.isPresent()) {
            try (BufferedReader reader = ((class_3298)modelResource.get()).method_43039();){
                String line = reader.readLine();
                while (line != null) {
                    int end = line.lastIndexOf("\"");
                    if (line.contains("\"bottom\": ")) {
                        bottom = line.substring(line.indexOf("\"bottom\": ") + 11, end);
                    }
                    if (line.contains("\"side\": ")) {
                        side = line.substring(line.indexOf("\"side\": ") + 9, end);
                    }
                    if (line.contains("\"top\": ")) {
                        top = line.substring(line.indexOf("\"top\": ") + 8, end);
                    }
                    if (bottom != null && side != null && top != null) {
                        break;
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                ClutterNoMore.LOGGER.catching((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (top == null) {
            if (side != null) {
                top = side;
            } else if (bottom != null) {
                top = bottom;
            }
        }
        if (side == null) {
            side = top;
        }
        if (bottom == null) {
            bottom = side;
        }
        JsonObject textures = new JsonObject();
        if (top != null) {
            textures.addProperty("bottom", bottom);
            textures.addProperty("side", side);
            textures.addProperty("top", top);
        }
        if (manager.method_14486(id.method_45134(path -> "blockstates/" + path + ".json")).isEmpty()) {
            class_2960 doubleId;
            if (manager.method_14486(id.method_45134(path -> "models/block/" + path + ".json")).isEmpty()) {
                JsonObject blockModel = new JsonObject();
                blockModel.addProperty("parent", "clutternomore:block/templates/vertical_slab");
                if (!textures.isEmpty()) {
                    blockModel.add("textures", (JsonElement)textures);
                }
                sink.addBlockModel(id, (JsonElement)blockModel);
            }
            if (manager.method_14486((doubleId = ClutterNoMore.location(name + "_double")).method_45134(path -> "models/block/" + path + ".json")).isEmpty()) {
                JsonObject blockModel = new JsonObject();
                blockModel.addProperty("parent", "clutternomore:block/templates/vertical_slab_double");
                if (!textures.isEmpty()) {
                    blockModel.add("textures", (JsonElement)textures);
                }
                sink.addBlockModel(doubleId, (JsonElement)blockModel);
            }
            StaticResource template = StaticResource.getOrThrow((class_3300)manager, (class_2960)ClutterNoMore.location("blockstates/vertical_slab.json"));
            sink.addSimilarJsonResource(manager, template, string -> string.replace("vertical_slab", name));
        }
        if (set.hasChild("vertical_slab") && manager.method_14486(id.method_45134(path -> "models/item/" + path + ".json")).isEmpty()) {
            JsonObject itemModel = new JsonObject();
            itemModel.addProperty("parent", "clutternomore:block/" + name);
            sink.addItemModel(ClutterNoMore.location(name), (JsonElement)itemModel);
        }
    }

    @Override
    public void translate(AfterLanguageLoadEvent languageEvent) {
        VERTICAL_SLABS.forEach(name -> languageEvent.addEntry("block.clutternomore." + name, VerticalSlabGenerator.langName(name)));
    }

    public static String langName(String name) {
        String processed = name.replace("_", " ");
        List<String> nonCapital = List.of("of", "and", "with");
        String[] words = processed.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (!nonCapital.contains(word)) {
                result.append(Character.toUpperCase(word.charAt(0)));
            } else {
                result.append(word.charAt(0));
            }
            result.append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    public static String verticalSlabName(String name) {
        if (((String)(name = "vertical_" + ((String)name).substring(0, ((String)name).length() - 5))).endsWith("_block")) {
            name = ((String)name).substring(0, ((String)name).length() - 6);
        }
        if (((String)name).endsWith("_planks")) {
            name = ((String)name).substring(0, ((String)name).length() - 7);
        }
        if (((String)name).endsWith("s")) {
            name = ((String)name).substring(0, ((String)name).length() - 1);
        }
        return (String)name + "_slab";
    }
}

