/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.registry;

import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.common.blocks.StepBlock;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2383;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockSetRegistry {
    public static void init() {
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)new ShapeSetRegistry());
        BlockSetAPI.addDynamicBlockRegistration(BlockSetRegistry::registerShapeBlocks, ShapeSet.class);
        BlockSetAPI.addDynamicItemRegistration(BlockSetRegistry::registerShapeItems, ShapeSet.class);
    }

    private static void registerShapeBlocks(Registrator<class_2248> event, Collection<ShapeSet> shapeSets) {
        for (ShapeSet set : shapeSets) {
            class_2248 stairs;
            class_2383 block;
            class_2248 slab;
            class_2960 id;
            if (((Boolean)CNMConfig.VERTICAL_SLABS.get()).booleanValue() && set.hasChild("slab") && !class_7923.field_41175.method_10250(id = ClutterNoMore.location(set.getVariantId("vertical", "slab"))) && (slab = class_2248.method_9503((class_1792)((class_1792)set.getChild("slab")))).method_9564().method_11656().size() == 2) {
                block = new VerticalSlabBlock(class_4970.class_2251.method_9630((class_4970)class_2248.method_9503((class_1792)((class_1792)set.getChild("slab")))));
                event.register(id, (Object)block);
                set.addChild("vertical_slab_block", block);
            }
            if (!((Boolean)CNMConfig.STEPS.get()).booleanValue() || !set.hasChild("stairs") || class_7923.field_41175.method_10250(id = ClutterNoMore.location(set.getVariantId("", "step"))) || (stairs = class_2248.method_9503((class_1792)((class_1792)set.getChild("stairs")))).method_9564().method_11656().size() != 4) continue;
            block = new StepBlock(class_4970.class_2251.method_9630((class_4970)stairs));
            event.register(id, (Object)block);
            set.addChild("step_block", block);
        }
    }

    private static void registerShapeItems(Registrator<class_1792> event, Collection<ShapeSet> shapeSets) {
        for (ShapeSet type : shapeSets) {
            class_1747 item;
            class_2960 id;
            class_2248 block = (class_2248)type.getChild("vertical_slab_block");
            if (block != null && !class_7923.field_41178.method_10250(id = ClutterNoMore.location(type.getVariantId("vertical", "slab")))) {
                item = new class_1747(block, new class_1792.class_1793());
                event.register(id, (Object)item);
                type.addChild("vertical_slab", item);
            }
            if ((block = (class_2248)type.getChild("step_block")) == null || class_7923.field_41178.method_10250(id = ClutterNoMore.location(type.getVariantId("", "step")))) continue;
            item = new class_1747(block, new class_1792.class_1793());
            event.register(id, (Object)item);
            type.addChild("step", item);
        }
    }

    private static String stripSuffix(String path, String suffix) {
        if (path.endsWith("_" + suffix)) {
            return path.substring(0, path.length() - suffix.length() - 1);
        }
        if (path.endsWith(suffix)) {
            return path.substring(0, path.length() - suffix.length());
        }
        return path;
    }

    private static String stripPrefix(String path, String prefix) {
        if (path.startsWith(prefix + "_")) {
            return path.substring(prefix.length() + 1);
        }
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        return path;
    }

    public static class ShapeSetRegistry
    extends BlockTypeRegistry<ShapeSet> {
        public static final ShapeSet STONE = new ShapeSet(class_2960.method_60656((String)"stone"), class_2246.field_10340);

        protected ShapeSetRegistry() {
            super(ShapeSet.class, "shape_set");
        }

        public Optional<ShapeSet> detectTypeFromBlock(class_2248 block, class_2960 blockId) {
            if (block.method_8389() != class_1802.field_8162 && ShapeSetRegistry.isParentBlock(blockId)) {
                return Optional.of(new ShapeSet(blockId, block));
            }
            return Optional.empty();
        }

        private static boolean has(class_2960 block) {
            return class_7923.field_41175.method_10250(block);
        }

        private static boolean isParentBlock(class_2960 block) {
            List<String> namespaces = List.of(block.method_12836(), "minecraft");
            String path = block.method_12832();
            List<String> parentSuffixes = List.of("log", "planks", "block");
            List<String> ignoredSuffixes = List.of("block");
            Map<String, String> replacements = Map.of("log", "wood");
            List<String> prefixes = List.of("spiked");
            List<String> ignoredPrefixes = List.of("stripped");
            List<String> suffixes = List.of("stairs", "slab", "wall");
            for (String namespace : namespaces) {
                class_2960 candidate;
                class_2960 base = class_2960.method_60655((String)namespace, (String)path);
                String suffixBase = path;
                for (String string : ignoredSuffixes) {
                    suffixBase = BlockSetRegistry.stripSuffix(suffixBase, string);
                }
                for (String string : parentSuffixes) {
                    class_2960 candidate2;
                    String suffixed = suffixBase + "_" + string;
                    if (suffixed.equals(path) || !ShapeSetRegistry.has(candidate2 = base.method_45134(p -> suffixed))) continue;
                    return false;
                }
                for (Map.Entry entry : replacements.entrySet()) {
                    class_2960 candidate2;
                    String replaced = path.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    if (replaced.equals(path) || !ShapeSetRegistry.has(candidate2 = base.method_45134(p -> replaced))) continue;
                    return true;
                }
                String prefixBase = path;
                for (String ignored : ignoredPrefixes) {
                    prefixBase = BlockSetRegistry.stripPrefix(prefixBase, ignored);
                }
                for (String prefix : prefixes) {
                    String prefixed = prefix + "_" + prefixBase;
                    if (prefixed.equals(path) || !ShapeSetRegistry.has(candidate = base.method_45134(p -> prefixed))) continue;
                    return true;
                }
                for (String parent : parentSuffixes) {
                    suffixBase = BlockSetRegistry.stripSuffix(suffixBase, parent);
                }
                for (String suffix : suffixes) {
                    class_2960 candidate3;
                    String trimmed;
                    String suffixed;
                    if (suffixBase.endsWith("s") && !(suffixed = (trimmed = suffixBase.substring(0, suffixBase.length() - 1)) + "_" + suffix).equals(path) && ShapeSetRegistry.has(candidate3 = base.method_45134(p -> suffixed))) {
                        return true;
                    }
                    String suffixed2 = suffixBase + "_" + suffix;
                    if (suffixed2.equals(path) || !ShapeSetRegistry.has(candidate = base.method_45134(p -> suffixed2))) continue;
                    return true;
                }
            }
            return false;
        }

        public ShapeSet getDefaultType() {
            return STONE;
        }
    }

    public static class ShapeSet
    extends BlockType {
        private final class_2960 id;
        private final class_2248 block;

        ShapeSet(class_2960 id, class_2248 block) {
            super(id);
            this.id = id;
            this.block = block;
        }

        protected void initializeChildrenBlocks() {
            this.addChild("block", this.block);
        }

        public String getVariantId(String prefix, String postfix) {
            Object name = prefix + (prefix.isEmpty() ? "" : "_") + this.getTypeName();
            List<String> suffixes = List.of("_block", "_planks", "s");
            for (String suffix : suffixes) {
                if (!((String)name).endsWith(suffix)) continue;
                name = ((String)name).substring(0, ((String)name).length() - suffix.length());
                break;
            }
            return (String)name + (postfix.isEmpty() ? "" : "_") + postfix;
        }

        @Nullable
        protected class_1792 findRelatedEntry(String prefix, String postfix) {
            String basePath = this.id.method_12832();
            List<String> parentSuffixes = List.of("block", "planks");
            for (String parent : parentSuffixes) {
                basePath = BlockSetRegistry.stripSuffix(basePath, parent);
            }
            List<String> ignoredPrefixes = List.of("stripped");
            Object reapplyPrefix = "";
            for (String ignored : ignoredPrefixes) {
                if (!this.id.method_12832().startsWith(ignored + "_")) continue;
                reapplyPrefix = ignored + "_";
                basePath = BlockSetRegistry.stripPrefix(basePath, ignored);
            }
            Object prefixPart = prefix.isEmpty() ? "" : prefix + "_";
            Object postfixPart = postfix.isEmpty() ? "" : "_" + postfix;
            ArrayList<String> candidates = new ArrayList<String>();
            if (basePath.endsWith("s")) {
                candidates.add(basePath.substring(0, basePath.length() - 1));
            }
            candidates.add(basePath);
            for (String stem : candidates) {
                String candidatePath = (String)reapplyPrefix + (String)prefixPart + stem + (String)postfixPart;
                class_2960 candidateId = this.id.method_45134(p -> candidatePath);
                Optional found = class_7923.field_41178.method_17966(candidateId);
                if (!found.isPresent()) continue;
                return (class_1792)found.get();
            }
            return null;
        }

        @Nullable
        protected class_1792 findRelatedEntry(String postfix) {
            return this.findRelatedEntry("", postfix);
        }

        @Nullable
        protected class_1792 getWood() {
            String path = this.id.method_12832();
            if (path.endsWith("log")) {
                String stem = path.substring(0, path.length() - 3);
                class_2960 woodId = this.id.method_45134(p -> stem + "wood");
                return class_7923.field_41178.method_17966(woodId).orElse(null);
            }
            return null;
        }

        protected void initializeChildrenItems() {
            class_1792 wood;
            List<String> postfixes = List.of("stairs", "slab", "wall");
            for (String postfix : postfixes) {
                class_1792 found = this.findRelatedEntry(postfix);
                if (found == null) continue;
                this.addChild(postfix, found);
            }
            class_1792 spiked = this.findRelatedEntry("spiked", "");
            if (spiked != null) {
                this.addChild("spiked", spiked);
            }
            if ((wood = this.getWood()) != null) {
                this.addChild("wood", wood);
            }
        }

        public String getTranslationKey() {
            return "shape_set." + this.getNamespace() + "." + this.getTypeName();
        }

        public class_2248 mainChild() {
            return this.block;
        }
    }
}

