/*
 * Decompiled with CFR 0.152.
 */
package mod.torchbowmod;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mod.torchbowmod.EntityTorch;
import mod.torchbowmod.TorchBowMod;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class TorchBow
extends ProjectileWeaponItem {
    public static final Predicate<ItemStack> TORCH = itemStack -> itemStack.is(Blocks.TORCH.asItem());
    public static final Predicate<ItemStack> MULTI_TORCH = itemStack -> itemStack.is((Item)TorchBowMod.multiTorch.get());
    public static final Predicate<ItemStack> TORCH_ARROW = itemStack -> itemStack.is((Item)TorchBowMod.torchArrow.get());
    public static final Predicate<ItemStack> TORCH_BOW_ONLY = TORCH.or(MULTI_TORCH).or(TORCH_ARROW);

    public TorchBow(Item.Properties p_40660_) {
        super(p_40660_);
    }

    public boolean releaseUsing(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int i1) {
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)livingEntity;
        ItemStack itemstack = player.getProjectile(itemStack);
        if (itemstack.isEmpty()) {
            return false;
        }
        int i = this.getUseDuration(itemStack, livingEntity) - i1;
        if ((i = EventHooks.onArrowLoose((ItemStack)itemStack, (Level)level, (Player)player, (int)i, (boolean)true)) < 0) {
            return false;
        }
        float f = TorchBow.getPowerForTime(i);
        if ((double)f < 0.1) {
            return false;
        }
        List list = TorchBow.draw((ItemStack)itemStack, (ItemStack)itemstack, (LivingEntity)player);
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (!list.isEmpty()) {
                if (((ItemStack)list.getFirst()).is((Item)TorchBowMod.multiTorch.get())) {
                    ItemStack item = ((ItemStack)list.getFirst()).copy();
                    list.addAll(Collections.nCopies(8, item));
                }
                this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), itemStack, list, f * 3.0f, 1.0f, f == 1.0f, null);
            }
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return true;
    }

    protected void shootProjectile(@NotNull LivingEntity livingEntity, @NotNull Projectile projectile, int i, float v, float v1, float v2, @Nullable LivingEntity livingEntity1) {
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (i < 9) {
            float range = 10.0f;
            Offsets[] offsets = new Offsets[]{new Offsets(0.0f, 0.0f), new Offsets(-range, -range), new Offsets(-range, 0.0f), new Offsets(-range, range), new Offsets(0.0f, -range), new Offsets(0.0f, range), new Offsets(range, -range), new Offsets(range, 0.0f), new Offsets(range, range)};
            offsetX = offsets[i].X;
            offsetY = offsets[i].Y;
        }
        projectile.shootFromRotation((Entity)livingEntity, livingEntity.getXRot() + offsetX, livingEntity.getYRot() + offsetY + v2, 0.0f, v, v1);
    }

    public static float getPowerForTime(int i) {
        float f = (float)i / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int getUseDuration(@NotNull ItemStack itemStack, @NotNull LivingEntity livingEntity) {
        return 72000;
    }

    @NotNull
    public ItemUseAnimation getUseAnimation(@NotNull ItemStack itemStack) {
        return ItemUseAnimation.BOW;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemstack;
        boolean flag = !player.getProjectile(itemstack = player.getItemInHand(interactionHand)).isEmpty();
        InteractionResult ret = EventHooks.onArrowNock((ItemStack)itemstack, (Level)level, (Player)player, (InteractionHand)interactionHand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!player.hasInfiniteMaterials() && !flag) {
            return InteractionResult.FAIL;
        }
        player.startUsingItem(interactionHand);
        return InteractionResult.CONSUME;
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return TORCH_BOW_ONLY;
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    @NotNull
    protected Projectile createProjectile(@NotNull Level worldIn, @NotNull LivingEntity livingEntity, @NotNull ItemStack weaponStack, ItemStack pickupItem, boolean p_336242_) {
        if (pickupItem.is((Item)TorchBowMod.multiTorch.get())) {
            pickupItem = Items.TORCH.getDefaultInstance();
        }
        return new EntityTorch(worldIn, livingEntity, pickupItem.copyWithCount(1), weaponStack);
    }

    private static class Offsets {
        private final float X;
        private final float Y;

        Offsets(float x, float y) {
            this.X = x;
            this.Y = y;
        }
    }
}

