/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.mixins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4066;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_761.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private class_4599 field_20951;
    @Unique
    private static final int TARGET_REMOVAL_CHECK_INTERVAL = 5;
    @Unique
    private int frameCounter = 0;
    @Unique
    private final Map<class_1297, Map<TargetInfo, Long>> pendingRemovals = new HashMap<class_1297, Map<TargetInfo, Long>>();

    @Shadow
    private void method_22977(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrices, class_4597 vertexConsumers) {
    }

    @Shadow
    protected abstract class_4066 method_3268(boolean var1);

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=0)})
    private void onRender(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f positionMatrix, CallbackInfo ci) {
        double minDistance;
        double thresholdSquared;
        class_243 playerPos;
        class_243 cameraPos;
        double distanceSquared;
        if (Freecam.isEnabled() && Freecam.MC.field_1761.method_2920() != class_1934.field_9215 && ClientModConfig.INSTANCE.visual.showPlayer && (distanceSquared = (cameraPos = camera.method_19326()).method_1025(playerPos = Freecam.MC.field_1724.method_33571())) > (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
            this.method_22977((class_1297)Freecam.MC.field_1724, cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350, tickDelta, matrices, (class_4597)this.field_20951.method_23000());
        }
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderEntity(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrices, class_4597 bufferSource, CallbackInfo ci) {
        double minDistance;
        double thresholdSquared;
        class_243 entityPos;
        class_243 cameraPos;
        double distanceSquared;
        BaseCombatEntity baseCombatEntity;
        if (entity instanceof BaseCombatEntity && !(baseCombatEntity = (BaseCombatEntity)entity).getShouldRender()) {
            ci.cancel();
            return;
        }
        if (this.isEntityInInternalSeat(entity)) {
            ci.cancel();
            return;
        }
        if (!Freecam.isEnabled()) {
            return;
        }
        if (entity instanceof BaseCombatEntity && (distanceSquared = (cameraPos = Freecam.MC.field_1773.method_19418().method_19326()).method_1025(entityPos = entity.method_33571())) <= (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean isEntityInInternalSeat(class_1297 entity) {
        class_1297 vehicle = entity.method_5854();
        if (vehicle instanceof MultiSeatVehicle) {
            MultiSeatVehicle multiSeatVehicle = (MultiSeatVehicle)vehicle;
            return multiSeatVehicle.getSeatForEntity(entity).map(seat -> seat.getType() == MultiSeatVehicle.SeatType.INTERNAL).orElse(false);
        }
        return false;
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevel(class_4587 poseStack, float f, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f matrix4f, CallbackInfo ci) {
        ++this.frameCounter;
        if (this.frameCounter >= 5) {
            this.frameCounter = 0;
            this.processTargetRemoval();
        }
        this.renderEntityTargets(poseStack, camera);
    }

    @Unique
    private void processTargetRemoval() {
        CopyOnWriteArraySet<TargetInfo> targets;
        class_1297 entity;
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return;
        }
        Map<class_1297, CopyOnWriteArraySet<TargetInfo>> targetMap = SelectionHandler.getInstance().getCombinedTargetMap();
        if (targetMap.isEmpty()) {
            return;
        }
        HashMap<String, List> formationMap = new HashMap<String, List>();
        for (Map.Entry<class_1297, CopyOnWriteArraySet<TargetInfo>> entry : targetMap.entrySet()) {
            entity = entry.getKey();
            if (!(entity instanceof BaseCombatEntity) || (targets = entry.getValue()) == null) continue;
            for (TargetInfo target : targets) {
                String type = target.getType();
                if (!"formTarget".equals(type) && !"formAttackTarget".equals(type)) continue;
                class_2338 targetPos = target.getPosition();
                String formationKey = type + "_" + targetPos.method_23854();
                formationMap.computeIfAbsent(formationKey, k -> new ArrayList()).add(entity);
            }
        }
        for (Map.Entry<class_1297, CopyOnWriteArraySet<TargetInfo>> entry : targetMap.entrySet()) {
            entity = entry.getKey();
            if (!(entity instanceof BaseCombatEntity) || (targets = entry.getValue()) == null || targets.isEmpty()) continue;
            class_243 formationCenter = entity.method_19538();
            List formationEntities = Collections.singletonList(entity);
            for (Map.Entry formationEntry : formationMap.entrySet()) {
                if (!((List)formationEntry.getValue()).contains(entity)) continue;
                formationEntities = (List)formationEntry.getValue();
                formationCenter = this.calculateCenterPosition(formationEntities);
                break;
            }
            this.processTargetRemovalForEntity(entity, targets, formationCenter, formationEntities);
        }
    }

    @Unique
    private void processTargetRemovalForEntity(class_1297 entity, CopyOnWriteArraySet<TargetInfo> targets, class_243 formationCenter, List<class_1297> formationEntities) {
        Iterator<TargetInfo> iterator;
        if (this.pendingRemovals.containsKey(entity)) {
            Map<TargetInfo, Long> removalMap = this.pendingRemovals.get(entity);
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<TargetInfo, Long>> entryIterator = removalMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                long timeout;
                Map.Entry<TargetInfo, Long> entry = entryIterator.next();
                String type = entry.getKey().getType();
                long l = timeout = (Objects.equals(type, "formTarget") || Objects.equals(type, "formAttackTarget")) && formationEntities.size() > 1 ? 1500L : 500L;
                if (currentTime - entry.getValue() <= timeout) continue;
                targets.remove(entry.getKey());
                entryIterator.remove();
            }
            if (removalMap.isEmpty()) {
                this.pendingRemovals.remove(entity);
            }
        }
        if (!targets.isEmpty() && (iterator = targets.iterator()).hasNext()) {
            TargetInfo firstTarget = iterator.next();
            class_2338 pos = firstTarget.getPosition();
            String type = firstTarget.getType();
            if (!Objects.equals(type, "entityTarget") && !Objects.equals(type, "followTarget")) {
                if (!Objects.equals(type, "formTarget") && !Objects.equals(type, "formAttackTarget")) {
                    double threshold = Math.max(((BaseCombatEntity)entity).getArrivalThreshold() * 1.2, 1.0);
                    if (!(!this.hasArrivedAtTarget(entity, pos, threshold) || this.pendingRemovals.containsKey(entity) && this.pendingRemovals.get(entity).containsKey(firstTarget))) {
                        this.pendingRemovals.computeIfAbsent(entity, k -> new HashMap()).put(firstTarget, System.currentTimeMillis());
                    }
                } else {
                    double threshold;
                    class_243 targetPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.1, (double)pos.method_10260() + 0.5);
                    double distance = this.calculateHorizontalDistance(formationCenter, targetPos);
                    if (!(!(distance < (threshold = this.calculateFormationThreshold(formationEntities))) || this.pendingRemovals.containsKey(entity) && this.pendingRemovals.get(entity).containsKey(firstTarget))) {
                        this.pendingRemovals.computeIfAbsent(entity, k -> new HashMap()).put(firstTarget, System.currentTimeMillis());
                    }
                }
            }
        }
        targets.removeIf(target -> {
            String type = target.getType();
            if (Objects.equals(type, "entityTarget") || Objects.equals(type, "followTarget")) {
                class_1297 targetEntity = target.getHywTarget();
                return !targetEntity.method_5805();
            }
            return false;
        });
    }

    @Unique
    private void renderEntityTargets(class_4587 poseStack, class_4184 camera) {
        boolean shouldRender;
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return;
        }
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!shouldRender) {
            return;
        }
        HashMap<String, List> formationMap = new HashMap<String, List>();
        for (class_1297 entity : level.method_18112()) {
            if (!(entity instanceof BaseCombatEntity)) continue;
            BaseCombatEntity baseEntity = (BaseCombatEntity)entity;
            CopyOnWriteArraySet<TargetInfo> targets = SelectionHandler.getInstance().getCombinedTargetMap().get(entity);
            if (targets == null) continue;
            for (TargetInfo targetInfo : targets) {
                String type = targetInfo.getType();
                if (!"formTarget".equals(type) && !"formAttackTarget".equals(type)) continue;
                class_2338 targetPos = targetInfo.getPosition();
                String formationKey = type + "_" + targetPos.method_23854();
                formationMap.computeIfAbsent(formationKey, k -> new ArrayList()).add(entity);
            }
        }
        HashSet<class_2338> renderedPositions = new HashSet<class_2338>();
        for (Map.Entry entry : formationMap.entrySet()) {
            List formationEntities = (List)entry.getValue();
            class_243 formationCenter = this.calculateCenterPosition(formationEntities);
            for (class_1297 entity : formationEntities) {
                CopyOnWriteArraySet<TargetInfo> targets = SelectionHandler.getInstance().getCombinedTargetMap().get(entity);
                if (targets == null) continue;
                this.renderTargetPositions(poseStack, entity, targets, formationCenter, renderedPositions, formationEntities);
            }
        }
        for (class_1297 entity : level.method_18112()) {
            class_2338 unloadTarget;
            class_2338 bombardTarget;
            SelectionHandler selectionHandler;
            CopyOnWriteArraySet<TargetInfo> copyOnWriteArraySet;
            if (!(entity instanceof BaseCombatEntity)) continue;
            BaseCombatEntity baseEntity = (BaseCombatEntity)entity;
            boolean inFormation = formationMap.values().stream().anyMatch(list -> list.contains(entity));
            if (!inFormation && (copyOnWriteArraySet = SelectionHandler.getInstance().getCombinedTargetMap().get(entity)) != null) {
                List<class_1297> singleEntityList = Collections.singletonList(entity);
                this.renderTargetPositions(poseStack, entity, copyOnWriteArraySet, entity.method_19538(), renderedPositions, singleEntityList);
            }
            if ((selectionHandler = SelectionHandler.getInstance()).getPatrolPointsMap().containsKey(entity)) {
                this.renderPatrolPositions(poseStack, entity, selectionHandler.getPatrolPointsMap().get(entity));
            }
            if (entity instanceof PositionAttackable && selectionHandler.getSelectedEntities().contains(entity) && (bombardTarget = selectionHandler.getBombardTarget(entity)) != null) {
                this.renderBombardTarget(poseStack, entity, bombardTarget);
            }
            if (!(entity instanceof UnloadPassengerable) || !selectionHandler.getSelectedEntities().contains(entity) || (unloadTarget = selectionHandler.getUnloadTarget(entity)) == null) continue;
            this.renderUnloadTarget(poseStack, entity, unloadTarget);
        }
    }

    @Unique
    public double calculateHorizontalDistance(class_243 pos1, class_243 pos2) {
        return Math.sqrt(Math.pow(pos1.method_10216() - pos2.method_10216(), 2.0) + Math.pow(pos1.method_10215() - pos2.method_10215(), 2.0));
    }

    @Unique
    private boolean hasArrivedAtTarget(class_1297 entity, class_2338 targetPos, double threshold) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return false;
        }
        class_243 entityPos = entity.method_19538();
        class_243 targetPosVec = new class_243((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 1.1, (double)targetPos.method_10260() + 0.5);
        class_2680 targetBlockState = level.method_8320(targetPos);
        boolean isTargetAir = targetBlockState.method_26215();
        double horizontalDistance = this.calculateHorizontalDistance(entityPos, targetPosVec);
        if (isTargetAir) {
            return horizontalDistance < threshold;
        }
        double verticalDistance = Math.abs(entityPos.method_10214() - targetPosVec.method_10214());
        return horizontalDistance < threshold && verticalDistance < threshold;
    }

    @Unique
    private class_243 calculateCenterPosition(List<class_1297> selectedEntities) {
        if (selectedEntities.isEmpty()) {
            return class_243.field_1353;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (class_1297 entity : selectedEntities) {
            class_243 entityPos = entity.method_19538();
            sumX += entityPos.field_1352;
            sumY += entityPos.field_1351;
            sumZ += entityPos.field_1350;
        }
        double centerX = sumX / (double)selectedEntities.size();
        double centerY = sumY / (double)selectedEntities.size();
        double centerZ = sumZ / (double)selectedEntities.size();
        return new class_243(centerX, centerY, centerZ);
    }

    @Unique
    private void renderPatrolPositions(class_4587 poseStack, class_1297 entity, CopyOnWriteArrayList<class_2338> patrolPoints) {
        boolean shouldRender;
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        List<class_1297> selectedEntities = selectionHandler.getSelectedEntities();
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (selectedEntities.contains(entity) && shouldRender) {
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            class_243 cameraPos = camera.method_19326();
            class_4588 vertexConsumer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594());
            class_243 previousPos = null;
            for (class_2338 patrolPoint : patrolPoints) {
                class_243 targetPos = new class_243((double)patrolPoint.method_10263() + 0.5, (double)patrolPoint.method_10264() + 1.1, (double)patrolPoint.method_10260() + 0.5);
                class_243 centerPos = targetPos.method_1020(cameraPos);
                double outerMinX = centerPos.method_10216() - 0.5;
                double outerMinZ = centerPos.method_10215() - 0.5;
                double outerMaxX = centerPos.method_10216() + 0.5;
                double outerMaxZ = centerPos.method_10215() + 0.5;
                double innerMinX = centerPos.method_10216() - 0.3;
                double innerMinZ = centerPos.method_10215() - 0.3;
                double innerMaxX = centerPos.method_10216() + 0.3;
                double innerMaxZ = centerPos.method_10215() + 0.3;
                class_238 outerBox = new class_238(outerMinX, centerPos.method_10214(), outerMinZ, outerMaxX, centerPos.method_10214(), outerMaxZ);
                class_238 innerBox = new class_238(innerMinX, centerPos.method_10214(), innerMinZ, innerMaxX, centerPos.method_10214(), innerMaxZ);
                float r = 0.0f;
                float g = 0.0f;
                float b = 1.0f;
                class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)outerBox.field_1323, (double)outerBox.field_1322, (double)outerBox.field_1321, (double)outerBox.field_1320, (double)outerBox.field_1325, (double)outerBox.field_1324, (float)r, (float)g, (float)b, (float)1.0f);
                class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)innerBox.field_1323, (double)innerBox.field_1322, (double)innerBox.field_1321, (double)innerBox.field_1320, (double)innerBox.field_1325, (double)innerBox.field_1324, (float)r, (float)g, (float)b, (float)1.0f);
                if (previousPos != null) {
                    Matrix3f normalMatrix = poseStack.method_23760().method_23762();
                    vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)previousPos.method_10216(), (float)previousPos.method_10214(), (float)previousPos.method_10215()).method_22915(r, g, b, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
                    vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)centerPos.method_10216(), (float)centerPos.method_10214(), (float)centerPos.method_10215()).method_22915(r, g, b, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
                }
                previousPos = centerPos;
            }
        }
    }

    @Unique
    private double calculateFormationThreshold(List<class_1297> formationEntities) {
        if (formationEntities.size() == 1) {
            class_1297 entity = formationEntities.get(0);
            if (entity instanceof BaseCombatEntity) {
                return Math.max(((BaseCombatEntity)entity).getArrivalThreshold() * 1.2, 1.0);
            }
            return 1.0;
        }
        return 8.0;
    }

    @Unique
    private void renderUnloadTarget(class_4587 poseStack, class_1297 entity, class_2338 unloadTarget) {
        boolean shouldRender;
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_4588 vertexConsumer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594());
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (SelectionHandler.getInstance().getSelectedEntities().contains(entity) && shouldRender) {
            class_243 centerPos = new class_243((double)unloadTarget.method_10263() + 0.5, (double)unloadTarget.method_10264() + 0.5, (double)unloadTarget.method_10260() + 0.5).method_1020(cameraPos);
            float innerSize = 0.5f;
            float outerSizeXZ = 1.5f;
            float outerSizeY = 0.5f;
            float red = 1.0f;
            float green = 1.0f;
            float blue = 0.0f;
            float alpha = 1.0f;
            class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)(centerPos.field_1352 - (double)innerSize), (double)(centerPos.field_1351 - (double)innerSize), (double)(centerPos.field_1350 - (double)innerSize), (double)(centerPos.field_1352 + (double)innerSize), (double)(centerPos.field_1351 + (double)innerSize), (double)(centerPos.field_1350 + (double)innerSize), (float)red, (float)green, (float)blue, (float)alpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)(centerPos.field_1352 - (double)outerSizeXZ), (double)(centerPos.field_1351 - (double)outerSizeY), (double)(centerPos.field_1350 - (double)outerSizeXZ), (double)(centerPos.field_1352 + (double)outerSizeXZ), (double)(centerPos.field_1351 + (double)outerSizeY), (double)(centerPos.field_1350 + (double)outerSizeXZ), (float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    @Unique
    private void renderBombardTarget(class_4587 poseStack, class_1297 entity, class_2338 bombardTarget) {
        boolean shouldRender;
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_4588 vertexConsumer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594());
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (SelectionHandler.getInstance().getSelectedEntities().contains(entity) && shouldRender) {
            class_243 centerPos = new class_243((double)bombardTarget.method_10263() + 0.5, (double)bombardTarget.method_10264() + 0.5, (double)bombardTarget.method_10260() + 0.5).method_1020(cameraPos);
            float smallSize = 0.5f;
            float mediumSize = 1.0f;
            float largeSize = 1.5f;
            float red = 1.0f;
            float green = 0.0f;
            float blue = 0.0f;
            float alpha = 1.0f;
            class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)(centerPos.field_1352 - (double)smallSize), (double)(centerPos.field_1351 - (double)smallSize), (double)(centerPos.field_1350 - (double)smallSize), (double)(centerPos.field_1352 + (double)smallSize), (double)(centerPos.field_1351 + (double)smallSize), (double)(centerPos.field_1350 + (double)smallSize), (float)red, (float)green, (float)blue, (float)alpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)(centerPos.field_1352 - (double)largeSize), (double)(centerPos.field_1351 - (double)largeSize), (double)(centerPos.field_1350 - (double)largeSize), (double)(centerPos.field_1352 + (double)largeSize), (double)(centerPos.field_1351 + (double)largeSize), (double)(centerPos.field_1350 + (double)largeSize), (float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    @Unique
    private void renderTargetPositions(class_4587 poseStack, class_1297 entity, CopyOnWriteArraySet<TargetInfo> targets, class_243 formationCenter, Set<class_2338> renderedPositions, List<class_1297> formationEntities) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_4588 vertexConsumer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594());
        AtomicReference<class_243> entityPreviousPos = new AtomicReference<class_243>(entity.method_19538().method_1020(cameraPos));
        AtomicReference<class_243> previousPos = new AtomicReference<class_243>(new class_243(entity.method_23317(), entity.method_23318(), entity.method_23321()).method_1020(cameraPos));
        for (TargetInfo target : targets) {
            float b;
            float g;
            float r;
            class_1297 targetEntity;
            boolean shouldRender;
            class_2338 pos = target.getPosition();
            String type = target.getType();
            if (!Objects.equals(type, "entityTarget") && !Objects.equals(type, "followTarget")) {
                float b2;
                float g2;
                float r2;
                boolean shouldRender2;
                class_243 targetPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.1, (double)pos.method_10260() + 0.5);
                SelectionHandler selectionHandler = SelectionHandler.getInstance();
                List<class_1297> selectedEntities = selectionHandler.getSelectedEntities();
                boolean bl = shouldRender2 = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
                if (!selectedEntities.contains(entity) || !shouldRender2) continue;
                class_243 centerPos = targetPos.method_1020(cameraPos);
                double outerMinX = centerPos.method_10216() - 0.5;
                double outerMinZ = centerPos.method_10215() - 0.5;
                double outerMaxX = centerPos.method_10216() + 0.5;
                double outerMaxZ = centerPos.method_10215() + 0.5;
                double innerMinX = centerPos.method_10216() - 0.3;
                double innerMinZ = centerPos.method_10215() - 0.3;
                double innerMaxX = centerPos.method_10216() + 0.3;
                double innerMaxZ = centerPos.method_10215() + 0.3;
                class_238 outerBox = new class_238(outerMinX, centerPos.method_10214(), outerMinZ, outerMaxX, centerPos.method_10214(), outerMaxZ);
                class_238 innerBox = new class_238(innerMinX, centerPos.method_10214(), innerMinZ, innerMaxX, centerPos.method_10214(), innerMaxZ);
                if (Objects.equals(type, "target") || Objects.equals(type, "formTarget")) {
                    r2 = 0.0f;
                    g2 = 1.0f;
                    b2 = 0.0f;
                } else {
                    r2 = 1.0f;
                    g2 = 0.0f;
                    b2 = 0.0f;
                }
                if (!renderedPositions.contains(pos)) {
                    class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)outerBox.field_1323, (double)outerBox.field_1322, (double)outerBox.field_1321, (double)outerBox.field_1320, (double)outerBox.field_1325, (double)outerBox.field_1324, (float)r2, (float)g2, (float)b2, (float)1.0f);
                    class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)innerBox.field_1323, (double)innerBox.field_1322, (double)innerBox.field_1321, (double)innerBox.field_1320, (double)innerBox.field_1325, (double)innerBox.field_1324, (float)r2, (float)g2, (float)b2, (float)1.0f);
                    renderedPositions.add(pos);
                }
                if (previousPos != null && previousPos.get() != null) {
                    Matrix3f normalMatrix = poseStack.method_23760().method_23762();
                    vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)previousPos.get().method_10216(), (float)previousPos.get().method_10214(), (float)previousPos.get().method_10215()).method_22915(r2, g2, b2, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
                    vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)centerPos.method_10216(), (float)centerPos.method_10214(), (float)centerPos.method_10215()).method_22915(r2, g2, b2, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
                }
                previousPos.set(centerPos);
                entityPreviousPos.set(centerPos);
                continue;
            }
            SelectionHandler selectionHandler = SelectionHandler.getInstance();
            List<class_1297> selectedEntities = selectionHandler.getSelectedEntities();
            boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
            if (!selectedEntities.contains(entity) || !shouldRender || !(targetEntity = target.getHywTarget()).method_5805()) continue;
            class_243 entityPos = targetEntity.method_19538().method_1020(cameraPos);
            if (Objects.equals(type, "entityTarget")) {
                r = 1.0f;
                g = 0.0f;
                b = 0.0f;
            } else if (Objects.equals(type, "followTarget")) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            }
            if (entityPreviousPos.get() != null) {
                Matrix3f normalMatrix = poseStack.method_23760().method_23762();
                vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)entityPreviousPos.get().method_10216(), (float)entityPreviousPos.get().method_10214(), (float)entityPreviousPos.get().method_10215()).method_22915(r, g, b, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
                vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)entityPos.method_10216(), (float)entityPos.method_10214(), (float)entityPos.method_10215()).method_22915(r, g, b, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
            }
            entityPreviousPos.set(entityPos);
            previousPos.set(new class_243(targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321()).method_1020(cameraPos));
        }
    }
}

