/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.selection;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1496;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.client.freecam.mixins.GameRendererAccessor;
import ydmsama.hundred_years_war.client.freecam.selection.ClientPuppetStateHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.client.freecam.util.FreeCamera;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Environment(value=EnvType.CLIENT)
public class SelectionHandler {
    private static SelectionHandler instance;
    private boolean isSelecting = false;
    private double startX;
    private double startY;
    private double endX;
    private double endY;
    List<class_1297> selectedEntities = new ArrayList<class_1297>();
    List<class_2586> selectedBlockEntities = new ArrayList<class_2586>();
    private final Map<class_1297, CopyOnWriteArraySet<TargetInfo>> combinedTargetMap = new ConcurrentHashMap<class_1297, CopyOnWriteArraySet<TargetInfo>>();
    private final Map<class_1297, CopyOnWriteArrayList<class_2338>> patrolPointsMap = new ConcurrentHashMap<class_1297, CopyOnWriteArrayList<class_2338>>();
    private final Map<class_1297, class_2338> bombardTargetMap = new ConcurrentHashMap<class_1297, class_2338>();
    private final Map<class_1297, class_2338> unloadTargetMap = new ConcurrentHashMap<class_1297, class_2338>();

    private SelectionHandler() {
    }

    public static SelectionHandler getInstance() {
        if (instance == null) {
            instance = new SelectionHandler();
        }
        return instance;
    }

    public void startSelection(double x, double y) {
        this.startX = x;
        this.startY = y;
        this.endX = x;
        this.endY = y;
        this.isSelecting = true;
        this.updateSelection(x, y);
    }

    public void updateSelection(double x, double y) {
        this.updateSelectedEntities();
        this.endX = x;
        this.endY = y;
    }

    public boolean hasSelectedEntities() {
        return !this.selectedEntities.isEmpty();
    }

    public void updateSelectedEntities() {
        if (!this.isSelecting || class_310.method_1551().field_1687 == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        ArrayList<class_1297> entitiesToRemove = new ArrayList<class_1297>();
        for (class_1297 entity : new ArrayList<class_1297>(this.selectedEntities)) {
            if (this.isEntityInSelectionBox(entity, mc) || HotKeyManager.getQueueMode()) continue;
            entitiesToRemove.add(entity);
        }
        this.selectedEntities.removeAll(entitiesToRemove);
        for (class_1297 entity : mc.field_1687.method_18112()) {
            BaseCombatEntity combatEntity;
            class_1496 horseEntity;
            class_1297 passenger;
            if (entity instanceof BaseCombatEntity && !this.selectedEntities.contains(entity)) {
                if (entity.method_5854() instanceof MultiSeatVehicle || !this.isEntityInSelectionBox(entity, mc) || !this.hasControl(entity) || this.isEntityObstructed(entity, mc) || this.selectedEntities.contains(entity)) continue;
                this.selectedEntities.add(entity);
                if (SelectionHandler.getInstance().getPatrolPointsMap().containsKey(entity)) continue;
                ClientPacketHandler.sendPatrolPointsRequestPacket(entity);
                continue;
            }
            if (!(entity instanceof class_1496) || !((passenger = (horseEntity = (class_1496)entity).method_31483()) instanceof BaseCombatEntity) || this.selectedEntities.contains(combatEntity = (BaseCombatEntity)passenger) || passenger.method_5854() instanceof MultiSeatVehicle || !this.isEntityInSelectionBox((class_1297)horseEntity, mc) || !this.hasControl((class_1297)combatEntity) || this.isEntityObstructed((class_1297)horseEntity, mc) || this.selectedEntities.contains(combatEntity)) continue;
            this.selectedEntities.add((class_1297)combatEntity);
            if (SelectionHandler.getInstance().getPatrolPointsMap().containsKey(combatEntity)) continue;
            ClientPacketHandler.sendPatrolPointsRequestPacket((class_1297)combatEntity);
        }
        ClientPuppetStateHandler.checkAndRestorePuppetSelection();
    }

    private boolean isEntityInSelectionBox(class_1297 entity, class_310 mc) {
        int[][] edges;
        double[][] selectionBoxCorners;
        class_238 boundingBox = entity.method_5829();
        class_243[] vertices = new class_243[]{new class_243(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1321), new class_243(boundingBox.field_1320, boundingBox.field_1322, boundingBox.field_1321), new class_243(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1321), new class_243(boundingBox.field_1323, boundingBox.field_1325, boundingBox.field_1321), new class_243(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1324), new class_243(boundingBox.field_1320, boundingBox.field_1322, boundingBox.field_1324), new class_243(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1324), new class_243(boundingBox.field_1323, boundingBox.field_1325, boundingBox.field_1324)};
        Matrix4f viewMat = SelectionHandler.buildViewMatrix(mc.field_1773.method_19418());
        for (class_243 vertex : vertices) {
            Vector4f viewPos = new Vector4f((float)vertex.field_1352, (float)vertex.field_1351, (float)vertex.field_1350, 1.0f);
            viewPos.mul((Matrix4fc)viewMat);
            if (!(viewPos.z > 0.0f)) continue;
            return false;
        }
        double[][] screenCoords = new double[8][2];
        for (int i = 0; i < 8; ++i) {
            screenCoords[i] = this.worldToScreen(vertices[i].field_1352, vertices[i].field_1351, vertices[i].field_1350, mc);
        }
        double minX = Math.min(this.startX, this.endX);
        double maxX = Math.max(this.startX, this.endX);
        double minY = Math.min(this.startY, this.endY);
        double maxY = Math.max(this.startY, this.endY);
        boolean allVerticesInside = true;
        for (double[] screenPos : screenCoords) {
            if (!(screenPos[0] < minX || screenPos[0] > maxX || screenPos[1] < minY) && !(screenPos[1] > maxY)) continue;
            allVerticesInside = false;
            break;
        }
        if (allVerticesInside) {
            return true;
        }
        for (double[] corner : selectionBoxCorners = new double[][]{{minX, minY}, {maxX, minY}, {maxX, maxY}, {minX, maxY}}) {
            class_243 worldPos = this.screenToWorld(corner[0], corner[1], mc);
            if (!boundingBox.method_1006(worldPos)) continue;
            return true;
        }
        for (int[] edge : edges = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}}) {
            double[] start = screenCoords[edge[0]];
            double[] end = screenCoords[edge[1]];
            if (!this.lineIntersectsRect(start[0], start[1], end[0], end[1], minX, minY, maxX, maxY)) continue;
            return true;
        }
        return false;
    }

    private boolean lineIntersectsRect(double x1, double y1, double x2, double y2, double minX, double minY, double maxX, double maxY) {
        return this.lineIntersectsLine(x1, y1, x2, y2, minX, minY, maxX, minY) || this.lineIntersectsLine(x1, y1, x2, y2, maxX, minY, maxX, maxY) || this.lineIntersectsLine(x1, y1, x2, y2, maxX, maxY, minX, maxY) || this.lineIntersectsLine(x1, y1, x2, y2, minX, maxY, minX, minY);
    }

    private boolean lineIntersectsLine(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double det1 = this.det(x1, y1, x2, y2, x3, y3);
        double det2 = this.det(x1, y1, x2, y2, x4, y4);
        double det3 = this.det(x3, y3, x4, y4, x1, y1);
        double det4 = this.det(x3, y3, x4, y4, x2, y2);
        return det1 * det2 < 0.0 && det3 * det4 < 0.0;
    }

    private double det(double x1, double y1, double x2, double y2, double x3, double y3) {
        return (x1 - x3) * (y2 - y3) - (y1 - y3) * (x2 - x3);
    }

    private double[] worldToScreen(double worldX, double worldY, double worldZ, class_310 mc) {
        class_4184 camera = mc.field_1773.method_19418();
        GameRendererAccessor accessor = (GameRendererAccessor)class_310.method_1551().field_1773;
        double fov = accessor.invokeGetFov(camera, 1.0f, true);
        Matrix4f projMat = mc.field_1773.method_22973(fov);
        Matrix4f viewMat = SelectionHandler.buildViewMatrix(camera);
        Vector4f worldCoords = new Vector4f((float)worldX, (float)worldY, (float)worldZ, 1.0f);
        worldCoords.mul((Matrix4fc)viewMat);
        worldCoords.mul((Matrix4fc)projMat);
        if (worldCoords.w() != 0.0f) {
            worldCoords.mul(1.0f / worldCoords.w());
        }
        int width = mc.method_22683().method_4480();
        int height = mc.method_22683().method_4507();
        double screenX = ((double)worldCoords.x() + 1.0) / 2.0 * (double)width;
        double screenY = (1.0 - (double)worldCoords.y()) / 2.0 * (double)height;
        return new double[]{screenX, screenY};
    }

    private static Matrix4f buildViewMatrix(class_4184 camera) {
        Matrix4f viewMatrix = new Matrix4f().identity();
        viewMatrix.rotateX((float)Math.toRadians(camera.method_19329()));
        viewMatrix.rotateY((float)Math.toRadians(camera.method_19330() + 180.0f));
        viewMatrix.translate((float)(-camera.method_19326().field_1352), (float)(-camera.method_19326().field_1351), (float)(-camera.method_19326().field_1350));
        return viewMatrix;
    }

    public class_243 screenToWorld(double screenX, double screenY, class_310 mc) {
        int width = mc.method_22683().method_4480();
        int height = mc.method_22683().method_4507();
        double normX = 2.0 * screenX / (double)width - 1.0;
        double normY = 1.0 - 2.0 * screenY / (double)height;
        Matrix4f projMat = mc.field_1773.method_22973((double)((float)((GameRendererAccessor)mc.field_1773).invokeGetFov(mc.field_1773.method_19418(), 1.0f, true)));
        projMat.invert();
        Vector4f clipCoords = new Vector4f((float)normX, (float)normY, -1.0f, 1.0f);
        clipCoords.mul((Matrix4fc)projMat);
        Vector4f worldCoords = new Vector4f(clipCoords.x, clipCoords.y, -1.0f, 0.0f);
        Matrix4f viewMat = SelectionHandler.buildViewMatrix(mc.field_1773.method_19418());
        viewMat.invert();
        worldCoords.mul((Matrix4fc)viewMat);
        class_243 directionVector = new class_243((double)worldCoords.x, (double)worldCoords.y, (double)worldCoords.z).method_1029();
        return directionVector;
    }

    public void endSelection() {
        this.isSelecting = false;
        List<UUID> selectedEntityIds = this.selectedEntities.stream().filter(this::hasControl).map(class_1297::method_5667).collect(Collectors.toList());
        ClientPacketHandler.sendSelectionPacket(selectedEntityIds);
    }

    public boolean hasControl(class_1297 entity) {
        class_746 player = class_310.method_1551().field_1724;
        if (player.method_7337()) {
            return true;
        }
        if (entity instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
            UUID entityOwnerUUID = combatEntity.method_6139();
            if (entityOwnerUUID != null && entityOwnerUUID.equals(player.method_5667())) {
                return true;
            }
            ClientRelationHelper relationHelper = ClientRelationHelper.getInstance();
            return entityOwnerUUID != null && relationHelper.getRelationWithPlayer(entity) == RelationSystem.RelationType.CONTROL;
        }
        return false;
    }

    public boolean isSelecting() {
        return this.isSelecting;
    }

    public void setSelecting(boolean isSelecting) {
        this.isSelecting = isSelecting;
    }

    public double getStartX() {
        return this.startX;
    }

    public double getStartY() {
        return this.startY;
    }

    public double getEndX() {
        return this.endX;
    }

    public double getEndY() {
        return this.endY;
    }

    public void renderSelectionBox() {
        if (SelectionHandler.getInstance().isSelecting()) {
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
            int screenWidth = Freecam.MC.method_22683().method_4480();
            int screenHeight = Freecam.MC.method_22683().method_4507();
            int guiScreenWidth = Freecam.MC.method_22683().method_4486();
            int guiScreenHeight = Freecam.MC.method_22683().method_4502();
            double startX = SelectionHandler.getInstance().getStartX() / ((double)screenWidth / (double)guiScreenWidth);
            double startY = SelectionHandler.getInstance().getStartY() / ((double)screenHeight / (double)guiScreenHeight);
            double endX = Freecam.MC.field_1729.method_1603() / ((double)screenWidth / (double)guiScreenWidth);
            double endY = Freecam.MC.field_1729.method_1604() / ((double)screenHeight / (double)guiScreenHeight);
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            float a = 1.0f;
            bufferBuilder.method_22912(startX, startY, 0.0).method_22915(r, g, b, a).method_1344();
            bufferBuilder.method_22912(endX, startY, 0.0).method_22915(r, g, b, a).method_1344();
            bufferBuilder.method_22912(endX, startY, 0.0).method_22915(r, g, b, a).method_1344();
            bufferBuilder.method_22912(endX, endY, 0.0).method_22915(r, g, b, a).method_1344();
            bufferBuilder.method_22912(endX, endY, 0.0).method_22915(r, g, b, a).method_1344();
            bufferBuilder.method_22912(startX, endY, 0.0).method_22915(r, g, b, a).method_1344();
            bufferBuilder.method_22912(startX, endY, 0.0).method_22915(r, g, b, a).method_1344();
            bufferBuilder.method_22912(startX, startY, 0.0).method_22915(r, g, b, a).method_1344();
            tesselator.method_1350();
            RenderSystem.disableBlend();
        }
    }

    public List<class_2586> getSelectedBlockEntities() {
        return this.selectedBlockEntities;
    }

    public List<class_1297> getSelectedEntities() {
        return this.selectedEntities;
    }

    public void setSelectedEntities(List<class_1297> selectedEntities) {
        this.selectedEntities = selectedEntities;
    }

    public void updateTargetPos(class_1297 entity, class_2338 targetPos) {
        TargetInfo targetInfo = new TargetInfo("target", targetPos, null);
        this.combinedTargetMap.computeIfAbsent(entity, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void updateFormTargetPos(class_1297 entity, class_2338 targetPos) {
        TargetInfo targetInfo = new TargetInfo("formTarget", targetPos, null);
        this.combinedTargetMap.computeIfAbsent(entity, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void updateAttackTargetPos(class_1297 entity, class_2338 targetPos) {
        TargetInfo targetInfo = new TargetInfo("attackTarget", targetPos, null);
        this.combinedTargetMap.computeIfAbsent(entity, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void updateFormAttackTargetPos(class_1297 entity, class_2338 targetPos) {
        TargetInfo targetInfo = new TargetInfo("formAttackTarget", targetPos, null);
        this.combinedTargetMap.computeIfAbsent(entity, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void clearAllTargetPos(class_1297 entity) {
        this.combinedTargetMap.computeIfPresent(entity, (k, v) -> {
            v.removeIf(info -> "target".equals(info.getType()));
            v.removeIf(info -> "formTarget".equals(info.getType()));
            return v.isEmpty() ? null : v;
        });
    }

    public void clearAllAttackTargetPos(class_1297 entity) {
        this.combinedTargetMap.computeIfPresent(entity, (k, v) -> {
            v.removeIf(info -> "attackTarget".equals(info.getType()));
            v.removeIf(info -> "formAttackTarget".equals(info.getType()));
            return v.isEmpty() ? null : v;
        });
    }

    public Set<class_2338> getTargetPos(class_1297 entity) {
        return this.combinedTargetMap.getOrDefault(entity, new CopyOnWriteArraySet()).stream().filter(info -> "target".equals(info.getType())).map(TargetInfo::getPosition).collect(Collectors.toSet());
    }

    public Set<class_2338> getAttackTargetPos(class_1297 entity) {
        return this.combinedTargetMap.getOrDefault(entity, new CopyOnWriteArraySet()).stream().filter(info -> "attackTarget".equals(info.getType())).map(TargetInfo::getPosition).collect(Collectors.toSet());
    }

    public void clearSelectedTargetPos() {
        for (class_1297 selectedEntity : new ArrayList<class_1297>(this.selectedEntities)) {
            this.clearAllTargetPos(selectedEntity);
        }
    }

    public void clearSelectedAttackTargetPos() {
        for (class_1297 selectedEntity : new ArrayList<class_1297>(this.selectedEntities)) {
            this.clearAllAttackTargetPos(selectedEntity);
        }
    }

    public Map<class_1297, CopyOnWriteArraySet<TargetInfo>> getCombinedTargetMap() {
        return this.combinedTargetMap;
    }

    public void updateTarget(class_1297 attacker, class_1297 target) {
        TargetInfo targetInfo = new TargetInfo("entityTarget", null, target);
        this.combinedTargetMap.computeIfAbsent(attacker, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void updateFollowTarget(class_1297 follower, class_1297 target) {
        TargetInfo targetInfo = new TargetInfo("followTarget", null, target);
        this.combinedTargetMap.computeIfAbsent(follower, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void clearAllTargets(class_1297 attacker) {
        this.combinedTargetMap.computeIfPresent(attacker, (k, v) -> {
            v.removeIf(info -> "entityTarget".equals(info.getType()));
            return v.isEmpty() ? null : v;
        });
    }

    public Set<class_1297> getTargets(class_1297 attacker) {
        return this.combinedTargetMap.getOrDefault(attacker, new CopyOnWriteArraySet()).stream().filter(info -> "entityTarget".equals(info.getType())).map(TargetInfo::getHywTarget).collect(Collectors.toSet());
    }

    public void clearSelectedTargets() {
        for (class_1297 selectedEntity : new ArrayList<class_1297>(this.selectedEntities)) {
            this.clearAllTargets(selectedEntity);
        }
    }

    public void clearAllFollowTargets(class_1297 attacker) {
        this.combinedTargetMap.computeIfPresent(attacker, (k, v) -> {
            v.removeIf(info -> "followTarget".equals(info.getType()));
            return v.isEmpty() ? null : v;
        });
    }

    public void clearSelectedFollowTargets() {
        for (class_1297 selectedEntity : new ArrayList<class_1297>(this.selectedEntities)) {
            this.clearAllFollowTargets(selectedEntity);
        }
    }

    public static void clearAllRenderingIfNotQueued() {
        if (!HotKeyManager.getQueueMode() || !Freecam.isEnabled()) {
            SelectionHandler.ClearAllRendering();
        }
    }

    public static void ClearAllRendering() {
        SelectionHandler.getInstance().clearSelectedNonPatrolTargets();
        SelectionHandler.getInstance().clearSelectedPatrolPoints();
    }

    public void clearSelectedNonPatrolTargets() {
        this.clearSelectedTargets();
        this.clearSelectedTargetPos();
        this.clearSelectedAttackTargetPos();
        this.clearSelectedFollowTargets();
        this.clearSelectedBombardTargets();
        this.clearSelectedUnloadTargets();
    }

    public static void clearPatrolPoints() {
        SelectionHandler.getInstance().clearSelectedPatrolPoints();
    }

    public void updatePatrolPoint(class_1297 entity, class_2338 patrolPoint) {
        this.patrolPointsMap.computeIfAbsent(entity, k -> new CopyOnWriteArrayList()).add(patrolPoint);
    }

    public void clearAllPatrolPoints(class_1297 entity) {
        this.patrolPointsMap.remove(entity);
    }

    public List<class_2338> getPatrolPoints(class_1297 entity) {
        return this.patrolPointsMap.getOrDefault(entity, new CopyOnWriteArrayList());
    }

    public void clearSelectedPatrolPoints() {
        for (class_1297 selectedEntity : new ArrayList<class_1297>(this.selectedEntities)) {
            this.clearAllPatrolPoints(selectedEntity);
        }
    }

    public Map<class_1297, CopyOnWriteArrayList<class_2338>> getPatrolPointsMap() {
        return this.patrolPointsMap;
    }

    public void selectAllEntitiesOfSameType(class_1297 referenceEntity) {
        if (class_310.method_1551().field_1687 == null || referenceEntity == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        this.startX = 0.0;
        this.startY = 0.0;
        this.endX = mc.method_22683().method_4480();
        this.endY = mc.method_22683().method_4507();
        ArrayList<Object> entitiesToAdd = new ArrayList<Object>();
        assert (mc.field_1687 != null);
        for (class_1297 class_12972 : mc.field_1687.method_18112()) {
            class_1496 horseEntity;
            class_1297 passenger;
            if (class_12972.getClass() == referenceEntity.getClass() && !this.selectedEntities.contains(class_12972)) {
                if (!(class_12972 instanceof BaseCombatEntity) || !(referenceEntity instanceof BaseCombatEntity)) continue;
                UUID referenceUUID = ((BaseCombatEntity)referenceEntity).method_6139();
                UUID entityUUID = ((BaseCombatEntity)class_12972).method_6139();
                if (!this.isEntityInSelectionBox(class_12972, mc) || class_12972.method_5854() instanceof MultiSeatVehicle) continue;
                if (referenceUUID != null) {
                    if (!ClientRelationHelper.getInstance().getRelationWithPlayer(class_12972).equals((Object)RelationSystem.RelationType.CONTROL)) continue;
                    entitiesToAdd.add(class_12972);
                    continue;
                }
                if (entityUUID != null) continue;
                entitiesToAdd.add(class_12972);
                continue;
            }
            if (!(class_12972 instanceof class_1496) || (passenger = (horseEntity = (class_1496)class_12972).method_31483()) == null || passenger.getClass() != referenceEntity.getClass() || this.selectedEntities.contains(passenger) || !(passenger instanceof BaseCombatEntity)) continue;
            BaseCombatEntity combatPassenger = (BaseCombatEntity)passenger;
            if (!(referenceEntity instanceof BaseCombatEntity)) continue;
            UUID referenceUUID = ((BaseCombatEntity)referenceEntity).method_6139();
            UUID passengerUUID = combatPassenger.method_6139();
            if (!this.isEntityInSelectionBox((class_1297)horseEntity, mc)) continue;
            if (referenceUUID != null) {
                if (!ClientRelationHelper.getInstance().getRelationWithPlayer((class_1297)combatPassenger).equals((Object)RelationSystem.RelationType.CONTROL)) continue;
                entitiesToAdd.add(combatPassenger);
                continue;
            }
            if (passengerUUID != null) continue;
            entitiesToAdd.add(combatPassenger);
        }
        this.selectedEntities.addAll(entitiesToAdd);
        if (!HotKeyManager.getQueueMode()) {
            for (class_1297 class_12973 : entitiesToAdd) {
                if (SelectionHandler.getInstance().getPatrolPointsMap().containsKey(class_12973)) continue;
                ClientPacketHandler.sendPatrolPointsRequestPacket(class_12973);
            }
        }
    }

    private boolean isEntityObstructed(class_1297 entity, class_310 mc) {
        if (!(entity instanceof BaseCombatEntity)) {
            return false;
        }
        class_4184 camera = mc.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_243 entityPos = entity.method_33571();
        FreeCamera contextEntity = Freecam.getFreeCamera();
        if (contextEntity == null) {
            return false;
        }
        class_3965 blockHitResult = mc.field_1687.method_17742(new class_3959(cameraPos, entityPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)contextEntity));
        return blockHitResult.method_17783() != class_239.class_240.field_1333;
    }

    public Map<class_1297, class_2338> getBombardTargetMap() {
        return this.bombardTargetMap;
    }

    public void updateBombardTarget(class_1297 entity, class_2338 bombardTarget) {
        if (entity instanceof PositionAttackable) {
            this.bombardTargetMap.put(entity, bombardTarget);
            this.unloadTargetMap.remove(entity);
        }
    }

    public class_2338 getBombardTarget(class_1297 entity) {
        return this.bombardTargetMap.get(entity);
    }

    public void clearBombardTarget(class_1297 entity) {
        this.bombardTargetMap.remove(entity);
    }

    public void clearSelectedBombardTargets() {
        for (class_1297 entity : new ArrayList<class_1297>(this.selectedEntities)) {
            if (!(entity instanceof PositionAttackable)) continue;
            this.clearBombardTarget(entity);
        }
    }

    public Map<class_1297, class_2338> getUnloadTargetMap() {
        return this.unloadTargetMap;
    }

    public void updateUnloadTarget(class_1297 entity, class_2338 unloadTarget) {
        if (entity instanceof UnloadPassengerable) {
            this.unloadTargetMap.put(entity, unloadTarget);
            this.bombardTargetMap.remove(entity);
        }
    }

    public class_2338 getUnloadTarget(class_1297 entity) {
        return this.unloadTargetMap.get(entity);
    }

    public void clearUnloadTarget(class_1297 entity) {
        this.unloadTargetMap.remove(entity);
    }

    public void clearSelectedUnloadTargets() {
        for (class_1297 entity : new ArrayList<class_1297>(this.selectedEntities)) {
            if (!(entity instanceof UnloadPassengerable)) continue;
            this.clearUnloadTarget(entity);
        }
    }
}

