/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;

@Environment(value=EnvType.CLIENT)
public class MouseControlInfoHandler {
    private static MouseControlInfoHandler instance;
    private static final int PADDING = 5;
    private static final int ITEM_HEIGHT = 12;
    private static final float FONT_SCALE = 0.8f;

    private MouseControlInfoHandler() {
    }

    public static MouseControlInfoHandler getInstance() {
        if (instance == null) {
            instance = new MouseControlInfoHandler();
        }
        return instance;
    }

    private String formatKeyName(String keyName, boolean isLeftMouse) {
        if (isLeftMouse) {
            if (keyName.equals("button.mouse.left") || keyName.equalsIgnoreCase("Left Button")) {
                return "LMB";
            }
        } else if (keyName.equals("button.mouse.right") || keyName.equalsIgnoreCase("Right Button")) {
            return "RMB";
        }
        return keyName;
    }

    private class_2561 getLeftMouseShortInfo() {
        String leftKeyName = HotKeyManager.getSelectCommandKey().method_16007().getString();
        String formattedKeyName = this.formatKeyName(leftKeyName, true);
        return class_2561.method_43469((String)"control.hundred_years_war.left_mouse_short", (Object[])new Object[]{formattedKeyName});
    }

    private class_2561 getLeftMouseLongInfo() {
        String leftKeyName = HotKeyManager.getSelectCommandKey().method_16007().getString();
        String formattedKeyName = this.formatKeyName(leftKeyName, true);
        return class_2561.method_43469((String)"control.hundred_years_war.left_mouse_long", (Object[])new Object[]{formattedKeyName});
    }

    private class_2561 getRightMouseShortInfo() {
        String rightKeyName = HotKeyManager.getMoveCommandKey().method_16007().getString();
        String formattedKeyName = this.formatKeyName(rightKeyName, false);
        return class_2561.method_43469((String)"control.hundred_years_war.right_mouse_short", (Object[])new Object[]{formattedKeyName});
    }

    private class_2561 getRightMouseLongInfo() {
        String rightKeyName = HotKeyManager.getMoveCommandKey().method_16007().getString();
        String formattedKeyName = this.formatKeyName(rightKeyName, false);
        return class_2561.method_43469((String)"control.hundred_years_war.right_mouse_long", (Object[])new Object[]{formattedKeyName});
    }

    private class_2561 getMouseWheelInfo() {
        return class_2561.method_43471((String)"control.hundred_years_war.mouse_wheel");
    }

    private void drawScaledString(class_332 guiGraphics, class_327 font, class_2561 text, float x, float y, int color) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(x, y, 0.0f);
        poseStack.method_22905(0.8f, 0.8f, 1.0f);
        guiGraphics.method_27535(font, text, 0, 0, color);
        poseStack.method_22909();
    }

    private int getScaledWidth(class_327 font, class_2561 text) {
        return (int)((float)font.method_27525((class_5348)text) * 0.8f);
    }

    public void renderMouseControlInfo(class_332 guiGraphics) {
        class_310 minecraft = class_310.method_1551();
        int screenWidth = minecraft.method_22683().method_4486();
        int screenHeight = minecraft.method_22683().method_4502();
        class_327 font = minecraft.field_1772;
        float scaledItemHeight = 9.6f;
        int listHeight = (int)(5.0f * scaledItemHeight) + 10;
        int startY = screenHeight - listHeight - 5;
        class_2561 rightMouseLongText = this.getRightMouseLongInfo();
        int rightMouseLongY = startY + 5;
        this.drawScaledString(guiGraphics, font, rightMouseLongText, screenWidth - 5 - this.getScaledWidth(font, rightMouseLongText), rightMouseLongY, 0xFFFFFF);
        class_2561 leftMouseLongText = this.getLeftMouseLongInfo();
        int leftMouseLongY = rightMouseLongY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, leftMouseLongText, screenWidth - 5 - this.getScaledWidth(font, leftMouseLongText), leftMouseLongY, 0xFFFFFF);
        class_2561 rightMouseShortText = this.getRightMouseShortInfo();
        int rightMouseShortY = leftMouseLongY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, rightMouseShortText, screenWidth - 5 - this.getScaledWidth(font, rightMouseShortText), rightMouseShortY, 0xFFFFFF);
        class_2561 leftMouseShortText = this.getLeftMouseShortInfo();
        int leftMouseShortY = rightMouseShortY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, leftMouseShortText, screenWidth - 5 - this.getScaledWidth(font, leftMouseShortText), leftMouseShortY, 0xFFFFFF);
        class_2561 mouseWheelText = this.getMouseWheelInfo();
        int mouseWheelY = leftMouseShortY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, mouseWheelText, screenWidth - 5 - this.getScaledWidth(font, mouseWheelText), mouseWheelY, 0xFFFFFF);
    }
}

