/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.PlayerRelationListWidget;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Environment(value=EnvType.CLIENT)
public class PlayerRelationListEntry
extends class_4265.class_4266<PlayerRelationListEntry> {
    private final String playerName;
    private final PlayerRelationListWidget parent;
    private final List<class_364> children = new ArrayList<class_364>();
    private final class_310 minecraft;
    private CustomButton relationButton;
    private static final class_2960 PERSONAL_ICON = new class_2960("hundred_years_war", "textures/gui/personal.png");
    private static final class_2960 TEAM_ICON = new class_2960("hundred_years_war", "textures/gui/team.png");
    private static final int ICON_SIZE = 16;
    protected RelationType currentRelation = RelationType.NEUTRAL;
    private UUID playerUUID;
    private BiConsumer<UUID, RelationSystem.RelationType> relationChangeCallback;
    private int nameColor = 0xFFFFFF;
    private EntryType entryType = EntryType.PERSONAL;

    public PlayerRelationListEntry(String playerName, PlayerRelationListWidget parent) {
        this.playerName = playerName;
        this.parent = parent;
        this.minecraft = class_310.method_1551();
        this.updateRelationButton();
    }

    public static PlayerRelationListEntry createForRelationUI(String playerName, UUID playerUUID, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation, PlayerRelationListWidget parent, BiConsumer<UUID, RelationSystem.RelationType> callback) {
        return PlayerRelationListEntry.createForRelationUI(playerName, playerUUID, myRelation, theirRelation, parent, callback, EntryType.PERSONAL);
    }

    public static PlayerRelationListEntry createForRelationUI(String playerName, UUID playerUUID, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation, PlayerRelationListWidget parent, BiConsumer<UUID, RelationSystem.RelationType> callback, EntryType entryType) {
        PlayerRelationListEntry entry = new PlayerRelationListEntry(playerName, parent);
        entry.playerUUID = playerUUID;
        entry.relationChangeCallback = callback;
        entry.entryType = entryType;
        entry.nameColor = PlayerRelationListEntry.getColorForRelationType(theirRelation);
        entry.setRelation(PlayerRelationListEntry.convertFromSystemRelation(myRelation));
        return entry;
    }

    public void setRelation(RelationType relation) {
        this.currentRelation = relation;
        this.updateRelationButton();
    }

    public void setEntryType(EntryType entryType) {
        this.entryType = entryType;
    }

    public EntryType getEntryType() {
        return this.entryType;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public static RelationType convertFromSystemRelation(RelationSystem.RelationType systemRelation) {
        return switch (systemRelation) {
            case RelationSystem.RelationType.HOSTILE -> RelationType.HOSTILE;
            case RelationSystem.RelationType.NEUTRAL -> RelationType.NEUTRAL;
            case RelationSystem.RelationType.FRIENDLY -> RelationType.FRIENDLY;
            case RelationSystem.RelationType.CONTROL -> RelationType.SHARED_CONTROL;
            default -> RelationType.NEUTRAL;
        };
    }

    public static RelationSystem.RelationType convertToSystemRelation(RelationType uiRelation) {
        return switch (uiRelation) {
            case RelationType.HOSTILE -> RelationSystem.RelationType.HOSTILE;
            case RelationType.NEUTRAL -> RelationSystem.RelationType.NEUTRAL;
            case RelationType.FRIENDLY -> RelationSystem.RelationType.FRIENDLY;
            case RelationType.SHARED_CONTROL -> RelationSystem.RelationType.CONTROL;
            default -> RelationSystem.RelationType.NEUTRAL;
        };
    }

    public static int getColorForRelationType(RelationSystem.RelationType relationType) {
        return switch (relationType) {
            case RelationSystem.RelationType.HOSTILE -> 0xFF5555;
            case RelationSystem.RelationType.NEUTRAL, RelationSystem.RelationType.FRIENDLY -> 0xFFFF55;
            case RelationSystem.RelationType.CONTROL -> 0x55FF55;
            default -> 0xFFFFFF;
        };
    }

    private void updateRelationButton() {
        if (this.relationButton == null) {
            this.relationButton = new CustomButton(0, 0, 100, 18, (class_2561)class_2561.method_43471((String)this.currentRelation.getTranslationKey()).method_27694(style -> style.method_36139(this.currentRelation.getColor())), button -> this.onRelationToggle());
            this.children.add(this.relationButton);
        } else {
            this.relationButton.method_25355((class_2561)class_2561.method_43471((String)this.currentRelation.getTranslationKey()).method_27694(style -> style.method_36139(this.currentRelation.getColor())));
        }
    }

    protected void onRelationToggle() {
        this.currentRelation = this.currentRelation.next();
        this.updateRelationButton();
        if (this.relationChangeCallback != null && this.playerUUID != null) {
            RelationSystem.RelationType systemRelation = PlayerRelationListEntry.convertToSystemRelation(this.currentRelation);
            this.relationChangeCallback.accept(this.playerUUID, systemRelation);
        } else {
            this.minecraft.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)("\u8bbe\u7f6e\u4e0e " + this.playerName + " \u7684\u5173\u7cfb\u4e3a: " + class_2561.method_43471((String)this.currentRelation.getTranslationKey()).getString())));
        }
    }

    public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
        class_2960 iconResource = this.entryType == EntryType.TEAM ? TEAM_ICON : PERSONAL_ICON;
        guiGraphics.method_25290(iconResource, left + 5, top + 4, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.method_25303(this.minecraft.field_1772, this.playerName, left + 6 + 16, top + 8, this.nameColor);
        int buttonY = top + 3;
        int buttonWidth = 60;
        int buttonsLeft = left + width - buttonWidth - 10;
        this.relationButton.method_46421(buttonsLeft);
        this.relationButton.method_46419(buttonY);
        this.relationButton.method_25358(buttonWidth);
        this.relationButton.method_25355((class_2561)class_2561.method_43471((String)this.currentRelation.getTranslationKey()).method_27694(style -> style.method_36139(this.currentRelation.getColor())));
        this.relationButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 listener : new ArrayList<class_364>(this.children)) {
            if (!listener.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    @NotNull
    public List<? extends class_6379> method_37025() {
        ArrayList<class_6379> result = new ArrayList<class_6379>();
        for (class_364 child : this.children) {
            if (!(child instanceof class_6379)) continue;
            result.add((class_6379)child);
        }
        return result;
    }

    public void hideRelationButton() {
        if (this.relationButton != null) {
            this.relationButton.field_22764 = false;
        }
    }

    public void setButtonText(class_2561 text) {
        this.relationButton.method_25355(text);
    }

    public void setButtonClickHandler(Runnable handler) {
        CustomButton newButton = new CustomButton(this.relationButton.method_46426(), this.relationButton.method_46427(), this.relationButton.method_25368(), this.relationButton.method_25364(), this.relationButton.method_25369(), button -> handler.run());
        this.children.remove((Object)this.relationButton);
        this.relationButton = newButton;
        this.children.add(this.relationButton);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum RelationType {
        HOSTILE(0, "relation.type.hostile", 0xFF5555),
        NEUTRAL(1, "relation.type.neutral", 0xFFFF55),
        FRIENDLY(2, "relation.type.friendly", 0xFFFF55),
        SHARED_CONTROL(3, "relation.type.control", 0x55FF55);

        private final int id;
        private final String translationKey;
        private final int color;

        private RelationType(int id, String translationKey, int color) {
            this.id = id;
            this.translationKey = translationKey;
            this.color = color;
        }

        public RelationType next() {
            RelationType[] values = RelationType.values();
            return values[(this.id + 1) % values.length];
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public int getColor() {
            return this.color;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum EntryType {
        PERSONAL,
        TEAM;

    }
}

