/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4265;
import ydmsama.hundred_years_war.client.freecam.ui.PlayerRelationListEntry;

@Environment(value=EnvType.CLIENT)
public class PlayerRelationListWidget
extends class_4265<PlayerRelationListEntry> {
    private final Map<UUID, List<Integer>> teamEntriesMap = new HashMap<UUID, List<Integer>>();
    private final Map<Integer, UUID> entryTeamMap = new HashMap<Integer, UUID>();
    private final Set<UUID> teamUUIDs = new HashSet<UUID>();

    public PlayerRelationListWidget(class_310 minecraft, int width, int height, int y0, int y1, int itemHeight) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.method_31322(false);
        this.method_31323(false);
        this.method_29344(true);
    }

    public int method_25322() {
        return this.field_22742;
    }

    protected int method_25329() {
        return this.field_19088 + this.field_22742 - 6;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.field_19085 && mouseY <= (double)this.field_19086 && mouseX >= (double)this.field_19088 && mouseX <= (double)this.field_19087;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_25294(this.field_19088, this.field_19085, this.field_19088 + this.field_22742, this.field_19086, Integer.MIN_VALUE);
        this.renderTeamDividers(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderTeamDividers(class_332 guiGraphics) {
        int y0 = (int)this.method_25341();
        int y1 = y0 + this.field_22743;
        for (UUID teamUUID : this.teamUUIDs) {
            List<Integer> memberIndices = this.teamEntriesMap.get(teamUUID);
            if (memberIndices == null) continue;
            int teamIndex = -1;
            for (int i = 0; i < this.method_25396().size(); ++i) {
                PlayerRelationListEntry entry = (PlayerRelationListEntry)((Object)this.method_25396().get(i));
                if (entry.getEntryType() != PlayerRelationListEntry.EntryType.TEAM || !entry.getPlayerUUID().equals(teamUUID)) continue;
                teamIndex = i;
                break;
            }
            if (teamIndex == -1) continue;
            int topDividerY = this.field_19085 + teamIndex * this.field_22741 - y0 + 4;
            int lastMemberIndex = -1;
            for (int index : memberIndices) {
                if (index <= lastMemberIndex) continue;
                lastMemberIndex = index;
            }
            if (topDividerY < this.field_19085 || topDividerY > this.field_19086) continue;
            for (int i = 0; i < 2; ++i) {
                int alpha = 180 - i * 80;
                guiGraphics.method_25294(this.field_19088, topDividerY - i, this.field_19088 + this.field_22742, topDividerY - i + 1, alpha << 24 | 0xBBBBBB);
            }
        }
    }

    public void method_25339() {
        super.method_25339();
        this.teamEntriesMap.clear();
        this.entryTeamMap.clear();
        this.teamUUIDs.clear();
    }

    public int addEntry(PlayerRelationListEntry entry) {
        int index = this.method_25396().size();
        super.method_25321((class_350.class_351)entry);
        if (entry.getEntryType() == PlayerRelationListEntry.EntryType.TEAM) {
            UUID teamUUID = entry.getPlayerUUID();
            this.teamUUIDs.add(teamUUID);
            this.teamEntriesMap.computeIfAbsent(teamUUID, k -> new ArrayList());
        }
        return index;
    }

    public void markAsMember(int memberIndex, UUID teamUUID) {
        if (this.teamUUIDs.contains(teamUUID)) {
            this.teamEntriesMap.computeIfAbsent(teamUUID, k -> new ArrayList()).add(memberIndex);
            this.entryTeamMap.put(memberIndex, teamUUID);
        }
    }

    public void setTeamMembers(UUID teamUUID, List<Integer> memberIndices) {
        if (this.teamUUIDs.contains(teamUUID)) {
            this.teamEntriesMap.put(teamUUID, new ArrayList<Integer>(memberIndices));
            for (int index : memberIndices) {
                this.entryTeamMap.put(index, teamUUID);
            }
        }
    }
}

