/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.wheel;

import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_746;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelUI;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Environment(value=EnvType.CLIENT)
public class CommandWheelHandler {
    private static CommandWheelHandler instance;
    private boolean isWheelOpen = false;
    private boolean isFollowing = false;
    private String currentFormation = "loose";
    private boolean isFormationMode = false;
    private class_239 lastHitResult = null;
    public static final int PICK_DISTANCE = 200;
    private long lastCommandTime = 0L;
    private static final long COMMAND_RENDER_DURATION = 3000L;

    private CommandWheelHandler() {
    }

    public static synchronized CommandWheelHandler getInstance() {
        if (instance == null) {
            instance = new CommandWheelHandler();
        }
        return instance;
    }

    public void recordCommandTime() {
        this.lastCommandTime = System.currentTimeMillis();
    }

    public boolean shouldRenderCommandEffect() {
        return CommandWheelHandler.getInstance().isWheelOpen() || System.currentTimeMillis() - this.lastCommandTime < 3000L;
    }

    public void openCommandWheel() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1755 != null) {
            return;
        }
        if (!this.isWheelOpen) {
            this.isWheelOpen = true;
            minecraft.method_1507((class_437)new CommandWheelUI());
        }
    }

    public void closeCommandWheel() {
        if (this.isWheelOpen) {
            this.isWheelOpen = false;
            if (class_310.method_1551().field_1755 instanceof CommandWheelUI) {
                class_310.method_1551().method_1507(null);
            }
        }
    }

    public boolean isWheelOpen() {
        return this.isWheelOpen;
    }

    public boolean isFollowing() {
        return this.isFollowing;
    }

    public void setFollowing(boolean following) {
        this.isFollowing = following;
    }

    public void toggleFollowing() {
        this.isFollowing = !this.isFollowing;
    }

    public String getCurrentFormation() {
        return this.currentFormation;
    }

    public void setCurrentFormation(String formation) {
        this.currentFormation = formation;
    }

    public boolean isFormationMode() {
        return this.isFormationMode;
    }

    public void setFormationMode(boolean formationMode) {
        this.isFormationMode = formationMode;
    }

    public void toggleFormationMode() {
        this.isFormationMode = !this.isFormationMode;
    }

    public class_239 getLastHitResult() {
        return this.lastHitResult;
    }

    public void tick() {
        if (this.isWheelOpen) {
            this.lastHitResult = this.performWheelRayTrace();
            class_310 minecraft = class_310.method_1551();
            class_437 class_4372 = minecraft.field_1755;
            if (class_4372 instanceof CommandWheelUI) {
                CommandWheelUI wheelUI = (CommandWheelUI)class_4372;
                wheelUI.getCommandWheelTree().updateNodesOnTick();
            }
        }
    }

    public class_239 performWheelRayTrace() {
        return this.performWheelRayTrace(false);
    }

    public class_239 performWheelRayTrace(boolean ignoreControlledEntities) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return null;
        }
        class_4184 camera = minecraft.field_1773.method_19418();
        class_243 eyePos = camera.method_19326();
        class_243 lookVec = class_243.method_1030((float)camera.method_19329(), (float)camera.method_19330());
        class_243 targetPos = eyePos.method_1031(lookVec.field_1352 * 200.0, lookVec.field_1351 * 200.0, lookVec.field_1350 * 200.0);
        class_3965 blockResult = minecraft.field_1687.method_17742(new class_3959(eyePos, targetPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        double blockDistance = Double.MAX_VALUE;
        if (blockResult.method_17783() != class_239.class_240.field_1333) {
            blockDistance = eyePos.method_1025(blockResult.method_17784());
        }
        class_1297 closestEntity = null;
        class_243 closestHitPos = null;
        double closestDistance = Double.MAX_VALUE;
        class_238 searchBox = new class_238(eyePos.field_1352 - 200.0, eyePos.field_1351 - 200.0, eyePos.field_1350 - 200.0, eyePos.field_1352 + 200.0, eyePos.field_1351 + 200.0, eyePos.field_1350 + 200.0);
        List entities = minecraft.field_1687.method_8335((class_1297)player, searchBox);
        for (class_1297 entity : entities) {
            double distance;
            class_238 entityBox;
            Optional hitPos;
            if (entity == player || !entity.method_5805() || !entity.method_5863() || ignoreControlledEntities && this.shouldIgnoreControlledEntity(entity) || !(hitPos = (entityBox = entity.method_5829().method_1014(0.3)).method_992(eyePos, targetPos)).isPresent() || !((distance = eyePos.method_1025((class_243)hitPos.get())) < closestDistance) || !(distance < blockDistance)) continue;
            closestEntity = entity;
            closestHitPos = (class_243)hitPos.get();
            closestDistance = distance;
        }
        if (closestEntity != null) {
            return new class_3966(closestEntity, closestHitPos);
        }
        if (blockResult.method_17783() != class_239.class_240.field_1333) {
            return blockResult;
        }
        class_2338 targetBlockPos = class_2338.method_49637((double)targetPos.field_1352, (double)targetPos.field_1351, (double)targetPos.field_1350);
        return class_3965.method_17778((class_243)targetPos, (class_2350)class_2350.method_10142((double)lookVec.field_1352, (double)lookVec.field_1351, (double)lookVec.field_1350), (class_2338)targetBlockPos);
    }

    private boolean shouldIgnoreControlledEntity(class_1297 entity) {
        if (entity instanceof BaseCombatEntity) {
            RelationSystem.RelationType relation = ClientRelationHelper.getInstance().getRelationWithPlayer(entity);
            return relation == RelationSystem.RelationType.CONTROL;
        }
        return false;
    }

    public static void init() {
        CommandWheelHandler.getInstance();
    }
}

