/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.wheel;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelNode;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelTree;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.TrapezoidButton;

@Environment(value=EnvType.CLIENT)
public class CommandWheelUI
extends class_437 {
    private final List<TrapezoidButton> buttons = new ArrayList<TrapezoidButton>();
    private final CommandWheelTree tree = new CommandWheelTree();
    private String lastAttackState = "";
    private int currentPage = 0;
    private static final int SEGMENT = 8;
    private static final int ITEMS_PER_PAGE = 8;
    private static final float INNER = 40.0f;
    private static final float OUTER = 120.0f;
    private static final float PAGINATION_BUTTON_INNER_RADIUS = 5.0f;
    private static final float PAGINATION_BUTTON_OUTER_RADIUS = 20.0f;
    private static final float PAGINATION_BUTTON_ANGLE_SPAN = 40.0f;
    private static final float PAGINATION_BUTTON_Y_OFFSET = 15.0f;
    private static final float PAGINATION_TEXT_Y_OFFSET = 15.0f;
    private static final int PAGINATION_TEXT_COLOR = 0xFFFFFF;
    private static final int PAGINATION_CUSTOM_BUTTON_WIDTH = 15;
    private static final int PAGINATION_CUSTOM_BUTTON_HEIGHT = 10;
    private static final int PAGINATION_BUTTON_SPACING = 15;
    private static final int PAGINATION_TEXT_HORIZONTAL_OFFSET = 0;

    public CommandWheelUI() {
        super((class_2561)class_2561.method_43473());
    }

    protected void method_25426() {
        CommandWheelNode attackNode;
        this.method_37067();
        this.buttons.clear();
        int cx = this.field_22789 / 2;
        int cy = this.field_22790 / 2;
        float segDeg = 45.0f;
        this.tree.updateDynamicNodes();
        List<CommandWheelNode> allNodesInCurrentLevel = this.tree.getCurrentNode().getChildren();
        int totalNodesInLevel = allNodesInCurrentLevel.size();
        int totalPages = this.tree.getTotalPages(8);
        if (this.currentPage >= totalPages && totalPages > 0) {
            this.currentPage = totalPages - 1;
        }
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
        List<CommandWheelNode> nodesToShow = this.tree.getCurrentPageNodes(this.currentPage, 8);
        int emptyButtonsNeeded = 8 - nodesToShow.size();
        for (int i = 0; i < 8; ++i) {
            float a1;
            float a0 = (float)i * segDeg - 90.0f;
            if (a0 < 0.0f) {
                a0 += 360.0f;
            }
            if ((a1 = a0 + segDeg) >= 360.0f) {
                a1 -= 360.0f;
            }
            if (i < nodesToShow.size()) {
                class_5250 label;
                CommandWheelNode node = nodesToShow.get(i);
                String titleKey = node.getTitleKey();
                if ("wheel.hundred_years_war.formation".equals(titleKey) && this.tree.getCurrentNode() == this.tree.getRoot() && node.isDynamic() && node.getState() != null) {
                    label = class_2561.method_43469((String)"wheel.hundred_years_war.formation.current", (Object[])new Object[]{class_2561.method_43471((String)("wheel.hundred_years_war.formation." + node.getState())).getString()});
                } else if ("wheel.hundred_years_war.recruitment_config".equals(titleKey) && this.tree.getCurrentNode() == this.tree.getRoot() && node.isDynamic() && node.getState() != null) {
                    class_5250 stateComponent = class_2561.method_43471((String)node.getState());
                    label = class_2561.method_43469((String)"wheel.hundred_years_war.recruitment_config", (Object[])new Object[]{stateComponent.getString()});
                } else if (titleKey.startsWith("army.hundred_years_war.") && node.isDynamic() && node.getState() != null) {
                    String baseText = class_2561.method_43471((String)titleKey).getString();
                    int expCost = Integer.parseInt(node.getState());
                    int playerExp = this.getTotalExperience();
                    String costColor = playerExp >= expCost ? "\u00a7a" : "\u00a7c";
                    String costText = class_2561.method_43469((String)"wheel.hundred_years_war.cost", (Object[])new Object[]{expCost}).getString();
                    label = class_2561.method_43470((String)(baseText + "\n" + costColor + costText + "\u00a7r"));
                } else if (node.isDynamic() && node.getState() != null) {
                    String stateKey = titleKey + "." + node.getState();
                    label = class_2561.method_43471((String)stateKey);
                } else {
                    label = class_2561.method_43471((String)node.getTitleKey());
                }
                CommandWheelNode finalNode = node;
                TrapezoidButton btn = new TrapezoidButton(cx, cy, 40.0f, 120.0f, a0, a1, (class_2561)label, () -> {
                    finalNode.executeAction();
                    String nodeTitleKey = finalNode.getTitleKey();
                    boolean isFormationMode = "wheel.hundred_years_war.formation_mode".equals(nodeTitleKey);
                    boolean isFormationSelection = "wheel.hundred_years_war.formation".equals(nodeTitleKey);
                    boolean isFollow = "wheel.hundred_years_war.follow".equals(nodeTitleKey);
                    boolean isBack = "wheel.hundred_years_war.back".equals(nodeTitleKey);
                    boolean isFormationOption = nodeTitleKey.startsWith("wheel.hundred_years_war.formation.");
                    boolean isCreateSquad = "wheel.hundred_years_war.create_squad".equals(nodeTitleKey);
                    boolean isSelectSquad = "wheel.hundred_years_war.select_squad".equals(nodeTitleKey);
                    boolean isRecruitmentConfig = "wheel.hundred_years_war.recruitment_config".equals(nodeTitleKey);
                    boolean isRecruitmentCategory = nodeTitleKey.startsWith("recruitment.hundred_years_war.category.");
                    boolean isRecruitmentUnit = nodeTitleKey.startsWith("recruitment.hundred_years_war.unit.");
                    boolean isLoading = "wheel.hundred_years_war.loading".equals(nodeTitleKey);
                    if (!isFollow) {
                        if (isFormationMode || isFormationSelection || isBack || isFormationOption || isCreateSquad || isSelectSquad || isRecruitmentConfig || isRecruitmentCategory || isRecruitmentUnit || isLoading) {
                            this.refreshUI();
                        } else if (!finalNode.hasChildren() || finalNode.getAction() == null) {
                            this.close();
                        }
                    }
                });
                this.method_37063((class_364)btn);
                this.buttons.add(btn);
                continue;
            }
            TrapezoidButton emptyBtn = new TrapezoidButton(cx, cy, 40.0f, 120.0f, a0, a1, (class_2561)class_2561.method_43473(), () -> {});
            emptyBtn.method_25350(0.3f);
            this.method_37063((class_364)emptyBtn);
            this.buttons.add(emptyBtn);
        }
        if (totalPages > 1) {
            CustomButton prevPageButton = new CustomButton(cx - 15 - 15, (int)((float)cy + 15.0f - 5.0f), 15, 10, (class_2561)class_2561.method_43470((String)"<"), button -> {
                --this.currentPage;
                if (this.currentPage < 0) {
                    this.currentPage = totalPages - 1;
                }
                this.refreshUI();
            });
            this.method_37063(prevPageButton);
            CustomButton nextPageButton = new CustomButton(cx + 15, (int)((float)cy + 15.0f - 5.0f), 15, 10, (class_2561)class_2561.method_43470((String)">"), button -> {
                ++this.currentPage;
                if (this.currentPage >= totalPages) {
                    this.currentPage = 0;
                }
                this.refreshUI();
            });
            this.method_37063(nextPageButton);
        }
        if ((attackNode = this.tree.getAttackNode()) != null && attackNode.getState() != null) {
            this.lastAttackState = attackNode.getState();
        }
    }

    public void refreshUI() {
        this.method_25426();
    }

    public void method_25393() {
        String currentState;
        super.method_25393();
        this.tree.updateNodesOnTick();
        CommandWheelNode attackNode = this.tree.getAttackNode();
        if (attackNode != null && attackNode.isDynamic() && (currentState = attackNode.getState()) != null && !currentState.equals(this.lastAttackState)) {
            this.lastAttackState = currentState;
            this.refreshUI();
        }
    }

    private void close() {
        this.field_22787.method_1507(null);
        CommandWheelHandler.getInstance().closeCommandWheel();
    }

    public boolean method_25401(double dMouseX, double dMouseY, double delta) {
        int totalPages = this.tree.getTotalPages(8);
        if (totalPages > 1) {
            if (delta > 0.0) {
                --this.currentPage;
                if (this.currentPage < 0) {
                    this.currentPage = totalPages - 1;
                }
            } else if (delta < 0.0) {
                ++this.currentPage;
                if (this.currentPage >= totalPages) {
                    this.currentPage = 0;
                }
            }
            this.refreshUI();
            return true;
        }
        return super.method_25401(dMouseX, dMouseY, delta);
    }

    public CommandWheelTree getCommandWheelTree() {
        return this.tree;
    }

    private int getTotalExperience() {
        if (this.field_22787.field_1724 == null) {
            return 0;
        }
        int currentExp = (int)(this.field_22787.field_1724.field_7510 * (float)this.field_22787.field_1724.method_7349()) + this.getTotalExperienceForLevel(this.field_22787.field_1724.field_7520);
        return currentExp;
    }

    private int getTotalExperienceForLevel(int level) {
        if (level < 0) {
            return 0;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    private boolean isInRecruitmentLevelSelection() {
        CommandWheelNode currentNode = this.tree.getCurrentNode();
        if (currentNode == null || currentNode.getChildren().isEmpty()) {
            return false;
        }
        boolean hasLevelNodes = false;
        for (CommandWheelNode child : currentNode.getChildren()) {
            String titleKey = child.getTitleKey();
            if (titleKey.startsWith("army.hundred_years_war.")) {
                hasLevelNodes = true;
                continue;
            }
            if ("wheel.hundred_years_war.back".equals(titleKey)) continue;
            return false;
        }
        return hasLevelNodes;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int totalPages;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.field_22787.field_1724 != null && CommandWheelHandler.getInstance().isWheelOpen()) {
            int playerExp = this.getTotalExperience();
            String expText = class_2561.method_43469((String)"wheel.hundred_years_war.player_exp", (Object[])new Object[]{playerExp}).getString();
            String[] lines = expText.split("\\n");
            Objects.requireNonNull(this.field_22787.field_1772);
            int lineHeight = 9;
            int totalHeight = lines.length * lineHeight;
            int startY = this.field_22790 / 2 - 15 - totalHeight / 2;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.matches(".*\\d+.*")) {
                    String textPart = line.replaceAll("\\d+", "").trim();
                    String numberPart = line.replaceAll("\\D+", "");
                    int textWidth = this.field_22787.field_1772.method_1727(textPart);
                    int numberWidth = this.field_22787.field_1772.method_1727("\u00a7e" + numberPart + "\u00a7r");
                    int totalWidth = textWidth + numberWidth;
                    int startX = this.field_22789 / 2 - totalWidth / 2;
                    int textY = startY + i * lineHeight;
                    guiGraphics.method_25303(this.field_22787.field_1772, textPart, startX, textY, 0xFFFFFF);
                    guiGraphics.method_25303(this.field_22787.field_1772, "\u00a7e" + numberPart + "\u00a7r", startX + textWidth, textY, 0xFFFFFF);
                    continue;
                }
                int textWidth = this.field_22787.field_1772.method_1727(line);
                int textX = this.field_22789 / 2 - textWidth / 2;
                int textY = startY + i * lineHeight;
                guiGraphics.method_25303(this.field_22787.field_1772, line, textX, textY, 0xFFFFFF);
            }
        }
        if ((totalPages = this.tree.getTotalPages(8)) > 1) {
            String pageText = this.currentPage + 1 + " / " + totalPages;
            int textWidth = this.field_22787.field_1772.method_1727(pageText);
            int textX = this.field_22789 / 2 - textWidth / 2 + 0;
            int n = this.field_22790 / 2 + 15;
            Objects.requireNonNull(this.field_22787.field_1772);
            int textY = n - 9 / 2;
            guiGraphics.method_25303(this.field_22787.field_1772, pageText, textX, textY, 0xFFFFFF);
        }
    }
}

