/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_638;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.ui.RelationUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamApplicationsUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamCreateUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamInfoUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamJoinUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamMembersUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamRelationUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamUI;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualUI;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelTree;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelUI;
import ydmsama.hundred_years_war.client.structure.BuildModeRenderer;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;
import ydmsama.hundred_years_war.main.network.packets.BombardPositionPacket;
import ydmsama.hundred_years_war.main.network.packets.BuildCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.ClearFollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.ClearSelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAddEntityPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAttackPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffFollowPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffMovePacket;
import ydmsama.hundred_years_war.main.network.packets.FollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.MoveAttackCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.MoveCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointsPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentConfigUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.RelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.RelationSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.SelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.SiegeModeTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.SquadCreatePacket;
import ydmsama.hundred_years_war.main.network.packets.SquadPacket;
import ydmsama.hundred_years_war.main.network.packets.SquadSelectPacket;
import ydmsama.hundred_years_war.main.network.packets.StructureSizePacket;
import ydmsama.hundred_years_war.main.network.packets.TargetUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamJoinRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamLeaveRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamListRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamListResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamManageRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.UnloadPassengersPacket;

@Environment(value=EnvType.CLIENT)
public class ClientPacketHandler {
    private static RelationResponsePacket latestRelationData;
    private static TeamInfoResponsePacket latestTeamData;
    private static TeamListResponsePacket latestTeamListData;
    private static TeamApplicationsResponsePacket latestTeamApplicationsData;
    private static TeamMembersResponsePacket latestTeamMembersData;
    private static TeamRelationResponsePacket latestTeamRelationData;
    private static Map<String, RecruitmentDataResponsePacket> latestRecruitmentData;

    public static RelationResponsePacket getLatestRelationData() {
        return latestRelationData;
    }

    public static TeamInfoResponsePacket getLatestTeamData() {
        return latestTeamData;
    }

    public static TeamListResponsePacket getLatestTeamListData() {
        return latestTeamListData;
    }

    public static TeamApplicationsResponsePacket getLatestTeamApplicationsData() {
        return latestTeamApplicationsData;
    }

    public static TeamMembersResponsePacket getLatestTeamMembersData() {
        return latestTeamMembersData;
    }

    public static TeamRelationResponsePacket getLatestTeamRelationData() {
        return latestTeamRelationData;
    }

    public static RecruitmentDataResponsePacket getLatestRecruitmentData(String categoryId) {
        return latestRecruitmentData.get(categoryId);
    }

    public static Map<String, RecruitmentDataResponsePacket> getAllRecruitmentData() {
        return latestRecruitmentData;
    }

    public static void handleStructureSizePacket(StructureSizePacket packet) {
        class_2382 size = packet.getSize();
        class_310.method_1551().execute(() -> BuildModeRenderer.updateStructureSize(size));
    }

    public static void registerClientPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RelationResponsePacket.RELATION_RESPONSE_PACKET_ID, (client, handler, buf, responseSender) -> {
            RelationResponsePacket packet;
            latestRelationData = packet = RelationResponsePacket.decode(buf);
            client.execute(() -> {
                class_437 patt4558$temp = client.field_1755;
                if (patt4558$temp instanceof RelationUI) {
                    RelationUI relationUI = (RelationUI)patt4558$temp;
                    relationUI.onRelationDataUpdate(packet);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TeamInfoResponsePacket.ID, (client, handler, buf, responseSender) -> {
            TeamInfoResponsePacket packet;
            latestTeamData = packet = TeamInfoResponsePacket.decode(buf);
            client.execute(() -> {
                class_437 patt5213$temp = client.field_1755;
                if (patt5213$temp instanceof TeamUI) {
                    TeamUI teamUI = (TeamUI)patt5213$temp;
                    teamUI.onTeamDataUpdate(packet);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TeamCreateResponsePacket.ID, (client, handler, buf, responseSender) -> {
            TeamCreateResponsePacket packet = TeamCreateResponsePacket.decode(buf);
            client.execute(() -> {
                class_437 patt5830$temp = client.field_1755;
                if (patt5830$temp instanceof TeamCreateUI) {
                    TeamCreateUI createUI = (TeamCreateUI)patt5830$temp;
                    createUI.onTeamCreateResponse(packet);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)StructureSizePacket.ID, (client, handler, buf, responseSender) -> {
            StructureSizePacket packet = StructureSizePacket.decode(buf);
            client.execute(() -> ClientPacketHandler.handleStructureSizePacket(packet));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RelationSyncPacket.RELATION_SYNC_PACKET_ID, (client, handler, buf, responseSender) -> {
            RelationSyncPacket packet = RelationSyncPacket.decode(buf);
            client.execute(() -> {
                ClientRelationHelper.getInstance().updateEnemyRelations(packet.getEnemyUUIDs());
                ClientRelationHelper.getInstance().updateSharedControlRelations(packet.getSharedControlUUIDs());
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PatrolPointsPacket.ID, (client, handler, buf, responseSender) -> {
            UUID entityUUID = buf.method_10790();
            int patrolPointsCount = buf.readInt();
            CopyOnWriteArrayList<class_2338> patrolPoints = new CopyOnWriteArrayList<class_2338>();
            for (int i = 0; i < patrolPointsCount; ++i) {
                patrolPoints.add(buf.method_10811());
            }
            client.execute(() -> {
                class_1297 entity = null;
                assert (client.field_1687 != null);
                for (class_1297 e : client.field_1687.method_18112()) {
                    if (!e.method_5667().equals(entityUUID)) continue;
                    entity = e;
                    break;
                }
                if (entity != null) {
                    SelectionHandler.getInstance().getPatrolPointsMap().put(entity, patrolPoints);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SquadSelectPacket.ID, (client, handler, buf, responseSender) -> {
            int size = buf.readInt();
            ArrayList<class_1297> selectedEntities = new ArrayList<class_1297>();
            for (int i = 0; i < size; ++i) {
                class_1297 entity = ClientPacketHandler.getEntityByUUID(buf.method_10790());
                if (entity == null) continue;
                selectedEntities.add(entity);
            }
            client.execute(() -> SelectionHandler.getInstance().setSelectedEntities(selectedEntities));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SquadPacket.ID, (client, handler, buf, responseSender) -> {
            int size = buf.readInt();
            ArrayList<class_1297> selectedEntities = new ArrayList<class_1297>();
            for (int i = 0; i < size; ++i) {
                class_1297 entity = ClientPacketHandler.getEntityByUUID(buf.method_10790());
                if (entity == null) continue;
                selectedEntities.add(entity);
            }
            client.execute(() -> SelectionHandler.getInstance().setSelectedEntities(selectedEntities));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TeamListResponsePacket.ID, (client, handler, buf, responseSender) -> {
            TeamListResponsePacket packet;
            latestTeamListData = packet = TeamListResponsePacket.decode(buf);
            client.execute(() -> {
                class_437 patt9719$temp = client.field_1755;
                if (patt9719$temp instanceof TeamJoinUI) {
                    TeamJoinUI joinUI = (TeamJoinUI)patt9719$temp;
                    joinUI.onTeamListUpdate(packet);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TeamApplicationsResponsePacket.ID, (client, handler, buf, responseSender) -> {
            TeamApplicationsResponsePacket packet;
            latestTeamApplicationsData = packet = TeamApplicationsResponsePacket.decode(buf);
            client.execute(() -> {
                class_437 patt10402$temp = client.field_1755;
                if (patt10402$temp instanceof TeamApplicationsUI) {
                    TeamApplicationsUI applicationsUI = (TeamApplicationsUI)patt10402$temp;
                    applicationsUI.onApplicationsDataUpdate(packet);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TeamMembersResponsePacket.ID, (client, handler, buf, responseSender) -> {
            TeamMembersResponsePacket packet;
            latestTeamMembersData = packet = TeamMembersResponsePacket.decode(buf);
            System.out.println("\u6536\u5230\u56e2\u961f\u6210\u5458\u54cd\u5e94\u5305\uff1a" + packet.getTeamName() + ", \u6210\u5458\u6570\u91cf: " + packet.getMembers().size());
            for (TeamMembersResponsePacket.Member member : packet.getMembers()) {
                System.out.println("\u6210\u5458: " + member.getPlayerName() + ", \u89d2\u8272: " + member.getRole());
            }
            client.execute(() -> {
                class_437 patt11461$temp = client.field_1755;
                if (patt11461$temp instanceof TeamInfoUI) {
                    TeamInfoUI teamInfoUI = (TeamInfoUI)patt11461$temp;
                    teamInfoUI.onMembersDataUpdate(packet);
                } else {
                    class_437 patt11616$temp = client.field_1755;
                    if (patt11616$temp instanceof TeamMembersUI) {
                        TeamMembersUI teamMembersUI = (TeamMembersUI)patt11616$temp;
                        teamMembersUI.updateMembersFromResponse(packet);
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TeamRelationResponsePacket.ID, (client, handler, buf, responseSender) -> {
            TeamRelationResponsePacket packet;
            latestTeamRelationData = packet = TeamRelationResponsePacket.decode(buf);
            client.execute(() -> {
                class_437 patt12307$temp = client.field_1755;
                if (patt12307$temp instanceof TeamRelationUI) {
                    TeamRelationUI teamRelationUI = (TeamRelationUI)patt12307$temp;
                    teamRelationUI.onTeamRelationDataUpdate(packet);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "open_manual"), (client, handler, buf, responseSender) -> client.execute(() -> client.method_1507((class_437)new ManualUI())));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RecruitmentDataResponsePacket.ID, (client, handler, buf, responseSender) -> {
            RecruitmentDataResponsePacket packet = RecruitmentDataResponsePacket.decode(buf);
            latestRecruitmentData.put(packet.getCategoryId(), packet);
            client.execute(() -> {
                System.out.println("\u6536\u5230\u62db\u52df\u6570\u636e: " + packet.getCategoryId() + ", \u5175\u79cd\u6570\u91cf: " + packet.getUnitTypes().size());
                class_437 patt13676$temp = client.field_1755;
                if (patt13676$temp instanceof CommandWheelUI) {
                    CommandWheelUI wheelUI = (CommandWheelUI)patt13676$temp;
                    CommandWheelTree tree = wheelUI.getCommandWheelTree();
                    tree.refreshRecruitmentMenu(packet.getCategoryId());
                    wheelUI.refreshUI();
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ClearFollowTargetPacket.ID, (client, handler, buf, responseSender) -> {
            ClearFollowTargetPacket packet = ClearFollowTargetPacket.decode(buf);
            client.execute(() -> {
                class_1297 entity = ClientPacketHandler.getEntityByUUID(packet.getEntityUUID());
                if (entity != null) {
                    SelectionHandler.getInstance().clearAllFollowTargets(entity);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ClearSelectionPacket.ID, (client, handler, buf, responseSender) -> {
            ClearSelectionPacket packet = ClearSelectionPacket.decode(buf);
            client.execute(() -> {
                class_1297 entity = ClientPacketHandler.getEntityByUUID(packet.getEntityUUID());
                if (entity != null) {
                    SelectionHandler.getInstance().getSelectedEntities().remove(entity);
                    SelectionHandler.getInstance().getCombinedTargetMap().remove(entity);
                    SelectionHandler.getInstance().getPatrolPointsMap().remove(entity);
                }
            });
        });
    }

    public static void requestRelationData() {
        RelationRequestPacket packet = new RelationRequestPacket();
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)RelationRequestPacket.RELATION_REQUEST_PACKET_ID, (class_2540)buf);
    }

    public static void requestTeamData() {
        TeamInfoRequestPacket packet = new TeamInfoRequestPacket();
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)TeamInfoRequestPacket.ID, (class_2540)buf);
    }

    public static void sendRelationUpdate(RelationUpdatePacket updatePacket) {
        class_2540 buf = PacketByteBufs.create();
        updatePacket.encode(buf);
        ClientPlayNetworking.send((class_2960)RelationUpdatePacket.RELATION_UPDATE_PACKET_ID, (class_2540)buf);
    }

    public static void sendTeamMemberRolesUpdate(UUID teamUUID, Map<UUID, TeamMembersResponsePacket.Member.Role> memberUpdates) {
        block5: for (Map.Entry<UUID, TeamMembersResponsePacket.Member.Role> entry : memberUpdates.entrySet()) {
            String actionType;
            UUID memberUUID = entry.getKey();
            TeamMembersResponsePacket.Member.Role newRole = entry.getValue();
            switch (newRole) {
                case OWNER: {
                    actionType = "set_owner";
                    break;
                }
                case ADMIN: {
                    actionType = "promote";
                    break;
                }
                case MEMBER: {
                    actionType = "demote";
                    break;
                }
                default: {
                    continue block5;
                }
            }
            ClientPacketHandler.requestTeamManage(teamUUID, actionType, memberUUID);
        }
    }

    public static void requestCreateTeam(String teamName) {
        TeamCreateRequestPacket packet = new TeamCreateRequestPacket(teamName);
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)TeamCreateRequestPacket.ID, (class_2540)buf);
    }

    public static void requestJoinTeam(UUID teamUUID) {
        TeamJoinRequestPacket packet = new TeamJoinRequestPacket(teamUUID);
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)TeamJoinRequestPacket.ID, (class_2540)buf);
    }

    public static void requestLeaveTeam(UUID teamUUID) {
        TeamLeaveRequestPacket packet = new TeamLeaveRequestPacket(teamUUID);
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)TeamLeaveRequestPacket.ID, (class_2540)buf);
    }

    public static void requestTeamManage(UUID teamUUID, String actionType, UUID targetUUID) {
        TeamManageRequestPacket packet = new TeamManageRequestPacket(teamUUID, actionType, targetUUID);
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)TeamManageRequestPacket.ID, (class_2540)buf);
    }

    public static void requestTeamList() {
        TeamListRequestPacket packet = new TeamListRequestPacket();
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)TeamListRequestPacket.ID, (class_2540)buf);
    }

    public static void requestTeamApplications() {
        TeamApplicationsRequestPacket packet = new TeamApplicationsRequestPacket();
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)TeamApplicationsRequestPacket.ID, (class_2540)buf);
    }

    public static void requestTeamMembers(UUID teamUUID) {
        TeamMembersRequestPacket packet = new TeamMembersRequestPacket(teamUUID);
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)TeamMembersRequestPacket.ID, (class_2540)buf);
    }

    public static void requestTeamRelationData(UUID teamUUID) {
        TeamRelationRequestPacket packet = new TeamRelationRequestPacket(teamUUID);
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)TeamRelationRequestPacket.ID, (class_2540)buf);
    }

    public static void sendTeamRelationUpdate(TeamRelationUpdatePacket updatePacket) {
        class_2540 buf = PacketByteBufs.create();
        updatePacket.encode(buf);
        ClientPlayNetworking.send((class_2960)TeamRelationUpdatePacket.ID, (class_2540)buf);
    }

    public static class_1297 getEntityByUUID(UUID uuid) {
        class_638 clientWorld = class_310.method_1551().field_1687;
        if (clientWorld != null) {
            for (class_1297 entity : clientWorld.method_18112()) {
                if (!entity.method_5667().equals(uuid)) continue;
                return entity;
            }
        }
        return null;
    }

    public static void sendSelectionPacket(List<UUID> selectedEntityIds) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(selectedEntityIds.size());
        for (UUID id : selectedEntityIds) {
            buf.method_10797(id);
        }
        ClientPlayNetworking.send((class_2960)SelectionPacket.ID, (class_2540)buf);
    }

    public static void sendCommandPacket(String command, boolean queueMode) {
        SelectionHandler.clearAllRenderingIfNotQueued();
        SelectionHandler.clearPatrolPoints();
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(command);
        buf.writeBoolean(queueMode);
        ClientPlayNetworking.send((class_2960)CommandPacket.ID, (class_2540)buf);
    }

    public static void sendMoveCommandPacket(class_239 result, boolean queueMode, boolean formationMode) {
        SelectionHandler.clearAllRenderingIfNotQueued();
        SelectionHandler.clearPatrolPoints();
        List<class_1297> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
        if (!(result instanceof class_3965)) {
            return;
        }
        class_3965 blockResult = (class_3965)result;
        class_2338 targetPos = blockResult.method_17777();
        if (blockResult.method_17783() == class_239.class_240.field_1333) {
            class_243 hitLocation = blockResult.method_17784();
            targetPos = new class_2338((int)hitLocation.field_1352, (int)hitLocation.field_1351, (int)hitLocation.field_1350);
        }
        if (!formationMode) {
            for (class_1297 selectedEntity : selectedEntities) {
                SelectionHandler.getInstance().updateTargetPos(selectedEntity, targetPos);
            }
        } else {
            for (class_1297 selectedEntity : selectedEntities) {
                SelectionHandler.getInstance().updateFormTargetPos(selectedEntity, targetPos);
            }
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_17813(blockResult);
        buf.writeBoolean(queueMode);
        if (SelectionHandler.getInstance().getSelectedEntities().size() == 1) {
            formationMode = false;
        }
        buf.writeBoolean(formationMode);
        if (formationMode) {
            buf.method_10814(CommandWheelHandler.getInstance().getCurrentFormation());
        } else {
            buf.method_10814("loose");
        }
        ClientPlayNetworking.send((class_2960)MoveCommandPacket.ID, (class_2540)buf);
    }

    public static void sendTargetUpdatePacket(class_239 result, boolean queueMode) {
        SelectionHandler.clearAllRenderingIfNotQueued();
        SelectionHandler.clearPatrolPoints();
        if (result instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)result;
            class_1297 targetEntity = entityHitResult.method_17782();
            UUID targetUUID = targetEntity.method_5667();
            List<class_1297> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
            for (class_1297 selectedEntity : selectedEntities) {
                SelectionHandler.getInstance().updateTarget(selectedEntity, targetEntity);
            }
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(targetUUID);
            buf.writeBoolean(queueMode);
            ClientPlayNetworking.send((class_2960)TargetUpdatePacket.ID, (class_2540)buf);
        }
    }

    public static void sendMoveAttackCommandPacket(class_239 result, boolean queueMode, boolean formationMode) {
        SelectionHandler.clearAllRenderingIfNotQueued();
        SelectionHandler.clearPatrolPoints();
        List<class_1297> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
        if (!(result instanceof class_3965)) {
            return;
        }
        class_3965 blockResult = (class_3965)result;
        class_2338 targetPos = blockResult.method_17777();
        if (blockResult.method_17783() == class_239.class_240.field_1333) {
            class_243 hitLocation = blockResult.method_17784();
            targetPos = new class_2338((int)hitLocation.field_1352, (int)hitLocation.field_1351, (int)hitLocation.field_1350);
        }
        if (!formationMode) {
            for (class_1297 selectedEntity : selectedEntities) {
                SelectionHandler.getInstance().updateAttackTargetPos(selectedEntity, targetPos);
            }
        } else {
            for (class_1297 selectedEntity : selectedEntities) {
                SelectionHandler.getInstance().updateFormAttackTargetPos(selectedEntity, targetPos);
            }
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_17813(blockResult);
        buf.writeBoolean(queueMode);
        if (SelectionHandler.getInstance().getSelectedEntities().size() == 1) {
            formationMode = false;
        }
        buf.writeBoolean(formationMode);
        if (formationMode) {
            buf.method_10814(CommandWheelHandler.getInstance().getCurrentFormation());
        } else {
            buf.method_10814("loose");
        }
        ClientPlayNetworking.send((class_2960)MoveAttackCommandPacket.ID, (class_2540)buf);
    }

    public static void sendBuildCommandPacket(class_2338 buildPos, String templateName, class_2470 rotation) {
        if (buildPos == null) {
            return;
        }
        SelectionHandler.clearPatrolPoints();
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(buildPos);
        buf.method_10814(templateName);
        buf.method_10817((Enum)rotation);
        ClientPlayNetworking.send((class_2960)BuildCommandPacket.ID, (class_2540)buf);
    }

    public static void sendPatrolPointPacket(class_3965 hitResult, boolean queueMode) {
        if (!queueMode) {
            SelectionHandler.clearAllRenderingIfNotQueued();
        } else {
            SelectionHandler.getInstance().clearSelectedNonPatrolTargets();
        }
        List<class_1297> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
        for (class_1297 selectedEntity : selectedEntities) {
            SelectionHandler.getInstance().updatePatrolPoint(selectedEntity, hitResult.method_17777());
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_17813(hitResult);
        buf.writeBoolean(queueMode);
        ClientPlayNetworking.send((class_2960)PatrolPointPacket.ID, (class_2540)buf);
    }

    public static void sendFollowTargetPacket(class_3966 hitResult, boolean queueMode) {
        SelectionHandler.clearAllRenderingIfNotQueued();
        SelectionHandler.clearPatrolPoints();
        List<class_1297> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
        for (class_1297 selectedEntity : selectedEntities) {
            SelectionHandler.getInstance().updateFollowTarget(selectedEntity, hitResult.method_17782());
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(hitResult.method_17782().method_5667());
        buf.writeBoolean(queueMode);
        ClientPlayNetworking.send((class_2960)FollowTargetPacket.ID, (class_2540)buf);
    }

    public static void sendPatrolPointsRequestPacket(class_1297 selectedEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(selectedEntity.method_5667());
        ClientPlayNetworking.send((class_2960)PatrolPointsRequestPacket.ID, (class_2540)buf);
    }

    public static void sendSquadCreatePacket(int numberPressed) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(numberPressed);
        ClientPlayNetworking.send((class_2960)SquadCreatePacket.ID, (class_2540)buf);
    }

    public static void sendSelectSquadPacket(int numberPressed) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(numberPressed);
        ClientPlayNetworking.send((class_2960)SquadSelectPacket.ID, (class_2540)buf);
    }

    public static void sendCommandStaffAddEntityPacket(UUID staffUUID, UUID entityUUID, boolean isAdding) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(staffUUID);
        buf.method_10797(entityUUID);
        buf.writeBoolean(isAdding);
        ClientPlayNetworking.send((class_2960)CommandStaffAddEntityPacket.ID, (class_2540)buf);
    }

    public static void sendCommandStaffMovePacket(UUID staffUUID, class_2338 targetPos, int priority) {
        ClientPacketHandler.sendCommandStaffMovePacket(staffUUID, targetPos, priority, false);
    }

    public static void sendCommandStaffMovePacket(UUID staffUUID, class_2338 targetPos, int priority, boolean formationMode) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(staffUUID);
        buf.method_10807(targetPos);
        buf.writeInt(priority);
        buf.writeBoolean(formationMode);
        buf.method_10814(CommandWheelHandler.getInstance().getCurrentFormation());
        ClientPlayNetworking.send((class_2960)CommandStaffMovePacket.ID, (class_2540)buf);
    }

    public static void sendCommandStaffFollowPacket(UUID staffUUID) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(staffUUID);
        ClientPlayNetworking.send((class_2960)CommandStaffFollowPacket.ID, (class_2540)buf);
    }

    public static void sendCommandStaffAttackPacket(UUID staffUUID, UUID targetEntityUUID) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(staffUUID);
        buf.method_10797(targetEntityUUID);
        ClientPlayNetworking.send((class_2960)CommandStaffAttackPacket.ID, (class_2540)buf);
    }

    public static void sendSiegeModeTogglePacket(boolean newState) {
        SelectionHandler.clearPatrolPoints();
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(newState);
        ClientPlayNetworking.send((class_2960)SiegeModeTogglePacket.ID, (class_2540)buf);
    }

    public static void sendBombardPositionPacket(class_243 position) {
        boolean queueMode = HotKeyManager.getQueueMode();
        if (!queueMode) {
            SelectionHandler.clearAllRenderingIfNotQueued();
        }
        SelectionHandler.clearPatrolPoints();
        if (position != null) {
            List<class_1297> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
            for (class_1297 entity : selectedEntities) {
                if (!(entity instanceof PositionAttackable)) continue;
                class_2338 bombardTarget = class_2338.method_49638((class_2374)position);
                SelectionHandler.getInstance().updateBombardTarget(entity, bombardTarget);
            }
        } else {
            SelectionHandler.getInstance().clearSelectedBombardTargets();
        }
        class_2540 buf = PacketByteBufs.create();
        if (position != null) {
            buf.writeDouble(position.field_1352);
            buf.writeDouble(position.field_1351);
            buf.writeDouble(position.field_1350);
            buf.writeBoolean(false);
        } else {
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
            buf.writeBoolean(true);
        }
        buf.writeBoolean(queueMode);
        ClientPlayNetworking.send((class_2960)BombardPositionPacket.ID, (class_2540)buf);
    }

    public static void sendUnloadPassengersPacket(class_243 position) {
        boolean queueMode = HotKeyManager.getQueueMode();
        if (!queueMode) {
            SelectionHandler.clearAllRenderingIfNotQueued();
        }
        SelectionHandler.clearPatrolPoints();
        if (position != null) {
            List<class_1297> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
            for (class_1297 entity : selectedEntities) {
                if (!(entity instanceof UnloadPassengerable)) continue;
                class_2338 unloadTarget = class_2338.method_49638((class_2374)position);
                SelectionHandler.getInstance().updateUnloadTarget(entity, unloadTarget);
            }
        } else {
            SelectionHandler.getInstance().clearSelectedUnloadTargets();
        }
        class_2540 buf = PacketByteBufs.create();
        if (position != null) {
            buf.writeDouble(position.field_1352);
            buf.writeDouble(position.field_1351);
            buf.writeDouble(position.field_1350);
            buf.writeBoolean(false);
        } else {
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
            buf.writeBoolean(true);
        }
        buf.writeBoolean(queueMode);
        ClientPlayNetworking.send((class_2960)UnloadPassengersPacket.ID, (class_2540)buf);
    }

    public static void requestRecruitmentData(String categoryId) {
        RecruitmentDataRequestPacket packet = categoryId != null ? new RecruitmentDataRequestPacket(categoryId) : new RecruitmentDataRequestPacket();
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)RecruitmentDataRequestPacket.ID, (class_2540)buf);
    }

    public static void sendRecruitmentConfigUpdate(String categoryId, String unitTypeId, int level) {
        RecruitmentConfigUpdatePacket packet = new RecruitmentConfigUpdatePacket(categoryId, unitTypeId, level);
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)RecruitmentConfigUpdatePacket.ID, (class_2540)buf);
    }

    static {
        latestRecruitmentData = new HashMap<String, RecruitmentDataResponsePacket>();
    }
}

