/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks;

import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.structure.ConstructionManager;
import ydmsama.hundred_years_war.main.structure.ConstructionTask;

public class BaseStructureCoreBlockEntity
extends class_2586 {
    private String templateName = "";
    private class_2382 size = class_2382.field_11176;
    private class_2470 rotation = class_2470.field_11467;
    private class_2415 mirror = class_2415.field_11302;
    private class_2338 placementPos = class_2338.field_10980;
    private boolean taskComplete = false;
    private int currentBlockIndex = 0;
    private int currentBatchIndex = 0;
    private class_238 boundingBox;
    private boolean selected;

    public BaseStructureCoreBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.BASE_STRUCTURE_CORE, pos, state);
    }

    public void setTemplateData(String templateName, class_2382 size, class_2470 rotation, class_2415 mirror, class_2338 placementPos) {
        this.templateName = templateName;
        this.size = size;
        this.rotation = rotation;
        this.mirror = mirror;
        this.placementPos = placementPos;
    }

    public class_2596<class_2602> method_38235() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return class_2622.method_39026((class_2586)this, blockEntity -> tag);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    public void setTaskComplete(boolean taskComplete) {
        this.taskComplete = taskComplete;
    }

    public boolean isTaskComplete() {
        return this.taskComplete;
    }

    public void setCurrentBlockIndex(int currentBlockIndex) {
        this.currentBlockIndex = currentBlockIndex;
    }

    public int getCurrentBlockIndex() {
        return this.currentBlockIndex;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10582("TemplateName", this.templateName);
        tag.method_10539("Size", new int[]{this.size.method_10263(), this.size.method_10264(), this.size.method_10260()});
        tag.method_10582("Rotation", this.rotation.name());
        tag.method_10582("Mirror", this.mirror.name());
        tag.method_10539("PlacementPos", new int[]{this.placementPos.method_10263(), this.placementPos.method_10264(), this.placementPos.method_10260()});
        tag.method_10556("TaskComplete", this.taskComplete);
        tag.method_10569("CurrentBlockIndex", this.currentBlockIndex);
        tag.method_10569("CurrentBatchIndex", this.currentBatchIndex);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.templateName = tag.method_10558("TemplateName");
        int[] sizeArray = tag.method_10561("Size");
        if (sizeArray.length == 3) {
            this.size = new class_2382(sizeArray[0], sizeArray[1], sizeArray[2]);
        }
        this.rotation = class_2470.valueOf((String)tag.method_10558("Rotation"));
        this.mirror = class_2415.valueOf((String)tag.method_10558("Mirror"));
        int[] posArray = tag.method_10561("PlacementPos");
        if (posArray.length == 3) {
            this.placementPos = new class_2338(posArray[0], posArray[1], posArray[2]);
        }
        this.taskComplete = tag.method_10577("TaskComplete");
        this.currentBlockIndex = tag.method_10550("CurrentBlockIndex");
        this.currentBatchIndex = tag.method_10550("CurrentBatchIndex");
        if (this.currentBatchIndex != 1 && !this.taskComplete) {
            ConstructionManager.addBlockEntityToRestore(this);
        }
        this.updateBoundingBox();
    }

    public void restoreTask(class_3218 serverLevel) {
        class_2960 structureLocation;
        class_3485 structureTemplateManager = serverLevel.method_14183();
        Optional structureTemplateOptional = structureTemplateManager.method_15094(structureLocation = new class_2960("hundred_years_war", this.templateName));
        if (structureTemplateOptional.isPresent()) {
            class_3499 structureTemplate = (class_3499)structureTemplateOptional.get();
            class_3492 placeSettings = new class_3492();
            placeSettings.method_15123(this.rotation);
            placeSettings.method_15125(this.mirror);
            ConstructionTask task = new ConstructionTask(serverLevel, structureTemplate, placeSettings, this.placementPos, 1200, this.templateName, this.currentBlockIndex, this);
            ConstructionManager.addTask(task);
        }
    }

    public class_2382 getSize() {
        return this.size;
    }

    public class_2470 getRotation() {
        return this.rotation;
    }

    public class_2338 getPlacementPos() {
        return this.placementPos;
    }

    public void setCurrentBatchIndex(int currentBatchIndex) {
        this.currentBatchIndex = currentBatchIndex;
    }

    public int getCurrentBatchIndex() {
        return this.currentBatchIndex;
    }

    public class_238 getBoundingBox() {
        return this.boundingBox;
    }

    public void updateBoundingBox() {
        class_2382 structureSize = this.size;
        class_2470 rotation = this.rotation;
        class_2338 placementPos = this.placementPos;
        class_2338 entityPos = this.method_11016();
        if (structureSize != null && structureSize.method_10263() > 0 && structureSize.method_10264() > 0 && structureSize.method_10260() > 0) {
            class_2382 rotatedSize = this.rotateVec3i(structureSize, rotation);
            class_2338 offset = this.calculateOffset(structureSize, rotation);
            double dx = placementPos.method_10263() - entityPos.method_10263();
            double dy = placementPos.method_10264() - entityPos.method_10264();
            double dz = placementPos.method_10260() - entityPos.method_10260();
            double startX = (double)offset.method_10263() + dx;
            double startY = (double)offset.method_10264() + dy;
            double startZ = (double)offset.method_10260() + dz;
            double endX = startX + (double)rotatedSize.method_10263();
            double endY = startY + (double)rotatedSize.method_10264();
            double endZ = startZ + (double)rotatedSize.method_10260();
            this.boundingBox = new class_238(startX, startY, startZ, endX, endY, endZ);
        }
    }

    private class_2382 rotateVec3i(class_2382 vec, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11463 -> new class_2382(-vec.method_10260(), vec.method_10264(), vec.method_10263());
            case class_2470.field_11464 -> new class_2382(-vec.method_10263(), vec.method_10264(), -vec.method_10260());
            case class_2470.field_11465 -> new class_2382(vec.method_10260(), vec.method_10264(), -vec.method_10263());
            default -> vec;
        };
    }

    private class_2338 calculateOffset(class_2382 vec, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11463 -> new class_2338(1, 0, 0);
            case class_2470.field_11464 -> new class_2338(1, 0, 1);
            case class_2470.field_11465 -> new class_2338(0, 0, 1);
            default -> class_2338.field_10980;
        };
    }

    public class_238 getAbsoluteBoundingBox() {
        if (this.boundingBox == null) {
            return null;
        }
        class_2338 entityPos = this.method_11016();
        return this.boundingBox.method_989((double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260());
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

