/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.fabricmc.loader.api.FabricLoader;

public class ServerModConfig {
    public static final ServerModConfig INSTANCE = new ServerModConfig();
    public boolean enableRecruitBalance = true;
    public boolean enableFirstJoinManual = true;
    public boolean enableScrollLootGeneration = true;
    public boolean enableScrollMobDrops = true;
    public boolean allowSoldierRecall = true;
    public boolean allowEquipmentChange = true;
    public boolean allowSiegeRecall = false;
    public boolean enablePlayerPuppets = true;
    public double followDistanceInner = 5.0;
    public double followDistanceOuter = 15.0;
    public float baseCombatEntityPathfindingRange = 35.0f;
    public int pathfindingTasksPerTick = 10;
    public int soldierLevelCap = 99999;
    public boolean allowLevel4ArmySummoning = false;
    public boolean allowNecromancySummoning = false;
    public boolean enableWorshipMechanism = true;
    public boolean enableSiegeTreeFelling = true;
    public double siegeTreeFellingExtraRange = 3.0;
    public int siegeTreeFellingInterval = 40;
    public double siegeTreeFellingMoveThreshold = 2.0;
    public int maxTreeLogCount = 100;
    public int minTreeLogCount = 1;
    public int maxTreeHeight = 30;
    public int minTreeHeight = 1;
    public int maxSiegeTreeBlocksPerAction = 50;
    public float siegeTreeParticleChance = 0.3f;
    public boolean allowMeleeAttackCreeper = false;
    public double playerFriendlyFireDamageMultiplier = 0.5;
    public boolean allowEquipmentDrop = false;
    public boolean shareExperienceWithPlayer = true;
    public boolean enableBetterMobCombat = true;
    public boolean enableEpicKnightsCompat = false;
    private static final String CONFIG_FILE = "config/hundredyearswar/hyw_main.json5";

    public static void load() {
        try {
            File configFile;
            File configDir = new File("config/hundredyearswar");
            if (!configDir.exists()) {
                configDir.mkdirs();
                System.out.println("\u5df2\u521b\u5efaconfig/hundredyearswar\u76ee\u5f55");
            }
            if (!(configFile = new File(CONFIG_FILE)).exists()) {
                System.out.println("hyw_main.json5\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u9ed8\u8ba4\u914d\u7f6e");
                ServerModConfig.save();
                return;
            }
            try (FileReader reader = new FileReader(configFile);){
                int length;
                StringBuilder content = new StringBuilder();
                char[] buffer = new char[1024];
                while ((length = reader.read(buffer)) != -1) {
                    content.append(buffer, 0, length);
                }
                Gson gson = new Gson();
                String jsonContent = content.toString().replaceAll("//.*", "").replaceAll("([a-zA-Z_][a-zA-Z0-9_]*):", "\"$1\":").replaceAll(",\\s*}", "}");
                ServerModConfig loaded = (ServerModConfig)gson.fromJson(jsonContent, ServerModConfig.class);
                if (loaded != null) {
                    ServerModConfig.copyFrom(loaded);
                    System.out.println("\u6210\u529f\u52a0\u8f7d\u4e3b\u914d\u7f6e\u6587\u4ef6");
                }
            }
        }
        catch (IOException e) {
            System.err.println("\u52a0\u8f7d\u4e3b\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            File configDir = new File("config/hundredyearswar");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            File configFile = new File(CONFIG_FILE);
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write("{\n");
                writer.write("  // Enable recruitment balance feature (survival mode summoning gives units weakness and slowness effects)\n");
                writer.write("  \"enableRecruitBalance\": " + ServerModConfig.INSTANCE.enableRecruitBalance + ",\n\n");
                writer.write("  // Give manual to players on first join\n");
                writer.write("  \"enableFirstJoinManual\": " + ServerModConfig.INSTANCE.enableFirstJoinManual + ",\n\n");
                writer.write("  // Generate scrolls in treasure chests\n");
                writer.write("  \"enableScrollLootGeneration\": " + ServerModConfig.INSTANCE.enableScrollLootGeneration + ",\n\n");
                writer.write("  // Allow monsters to drop scrolls\n");
                writer.write("  \"enableScrollMobDrops\": " + ServerModConfig.INSTANCE.enableScrollMobDrops + ",\n\n");
                writer.write("  // Allow recalling soldiers to inventory (shift + right click)\n");
                writer.write("  \"allowSoldierRecall\": " + ServerModConfig.INSTANCE.allowSoldierRecall + ",\n\n");
                writer.write("  // Allow changing soldier equipment (shift + attack)\n");
                writer.write("  \"allowEquipmentChange\": " + ServerModConfig.INSTANCE.allowEquipmentChange + ",\n\n");
                writer.write("  // Allow recalling siege units to inventory in survival mode (shift + right click)\n");
                writer.write("  \"allowSiegeRecall\": " + ServerModConfig.INSTANCE.allowSiegeRecall + ",\n\n");
                writer.write("  // Allow melee attack creepers\n");
                writer.write("  \"allowMeleeAttackCreeper\": " + ServerModConfig.INSTANCE.allowMeleeAttackCreeper + ",\n\n");
                writer.write("  // Player friendly fire damage multiplier (damage dealt by players to their own soldiers)\n");
                writer.write("  \"playerFriendlyFireDamageMultiplier\": " + ServerModConfig.INSTANCE.playerFriendlyFireDamageMultiplier + ",\n\n");
                writer.write("  // Allow soldiers to drop equipment when killed\n");
                writer.write("  \"allowEquipmentDrop\": " + ServerModConfig.INSTANCE.allowEquipmentDrop + ",\n\n");
                writer.write("  // Whether soldiers share experience with the player upon killing mobs\n");
                writer.write("  \"shareExperienceWithPlayer\": " + ServerModConfig.INSTANCE.shareExperienceWithPlayer + ",\n\n");
                writer.write("  // Soldier follow distance configuration\n");
                writer.write("  // Follow distance (inner) - maximum follow distance when idle\n");
                writer.write("  \"followDistanceInner\": " + ServerModConfig.INSTANCE.followDistanceInner + ",\n");
                writer.write("  // Follow distance (outer) - maximum follow distance during combat\n");
                writer.write("  \"followDistanceOuter\": " + ServerModConfig.INSTANCE.followDistanceOuter + ",\n\n");
                writer.write("  // Base combat entity pathfinding range - higher values make entity pathfinding smarter but impact performance heavily\n");
                writer.write("  // (e.g., 20 supports 500 entities smoothly, 200 causes lag with just 50 entities)\n");
                writer.write("  \"baseCombatEntityPathfindingRange\": " + ServerModConfig.INSTANCE.baseCombatEntityPathfindingRange + ",\n\n");
                writer.write("  // Soldier level cap\n");
                writer.write("  \"soldierLevelCap\": " + ServerModConfig.INSTANCE.soldierLevelCap + ",\n\n");
                writer.write("  // Allow summoning tier 4 armies\n");
                writer.write("  \"allowLevel4ArmySummoning\": " + ServerModConfig.INSTANCE.allowLevel4ArmySummoning + ",\n\n");
                writer.write("  // Allow summoning undead armies\n");
                writer.write("  \"allowNecromancySummoning\": " + ServerModConfig.INSTANCE.allowNecromancySummoning + ",\n\n");
                writer.write("  // Enable worship mechanism (resistance boost and health regeneration based on nearby controlled entities)\n");
                writer.write("  \"enableWorshipMechanism\": " + ServerModConfig.INSTANCE.enableWorshipMechanism + ",\n\n");
                writer.write("  // Enable player puppets (whether to convert players into controllable units in RTS mode)\n");
                writer.write("  \"enablePlayerPuppets\": " + ServerModConfig.INSTANCE.enablePlayerPuppets + ",\n\n");
                writer.write("  // Enable Better Mob Combat integration (use Better Combat attack system for melee units)\n");
                writer.write("  \"enableBetterMobCombat\": " + ServerModConfig.INSTANCE.enableBetterMobCombat + ",\n\n");
                writer.write("  // Enable Epic Knights compatibility (use Epic Knights equipment by default)\n");
                writer.write("  \"enableEpicKnightsCompat\": " + ServerModConfig.INSTANCE.enableEpicKnightsCompat + "\n");
                writer.write("}\n");
                System.out.println("\u5df2\u4fdd\u5b58\u4e3b\u914d\u7f6e\u6587\u4ef6");
            }
        }
        catch (IOException e) {
            System.err.println("\u4fdd\u5b58\u4e3b\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void copyFrom(ServerModConfig other) {
        ServerModConfig.INSTANCE.enableRecruitBalance = other.enableRecruitBalance;
        ServerModConfig.INSTANCE.enableFirstJoinManual = other.enableFirstJoinManual;
        ServerModConfig.INSTANCE.enableScrollLootGeneration = other.enableScrollLootGeneration;
        ServerModConfig.INSTANCE.enableScrollMobDrops = other.enableScrollMobDrops;
        ServerModConfig.INSTANCE.allowSoldierRecall = other.allowSoldierRecall;
        ServerModConfig.INSTANCE.allowEquipmentChange = other.allowEquipmentChange;
        ServerModConfig.INSTANCE.allowSiegeRecall = other.allowSiegeRecall;
        ServerModConfig.INSTANCE.followDistanceInner = other.followDistanceInner;
        ServerModConfig.INSTANCE.followDistanceOuter = other.followDistanceOuter;
        ServerModConfig.INSTANCE.baseCombatEntityPathfindingRange = other.baseCombatEntityPathfindingRange;
        ServerModConfig.INSTANCE.pathfindingTasksPerTick = other.pathfindingTasksPerTick;
        ServerModConfig.INSTANCE.soldierLevelCap = other.soldierLevelCap;
        ServerModConfig.INSTANCE.allowLevel4ArmySummoning = other.allowLevel4ArmySummoning;
        ServerModConfig.INSTANCE.allowNecromancySummoning = other.allowNecromancySummoning;
        ServerModConfig.INSTANCE.enableWorshipMechanism = other.enableWorshipMechanism;
        ServerModConfig.INSTANCE.allowMeleeAttackCreeper = other.allowMeleeAttackCreeper;
        ServerModConfig.INSTANCE.playerFriendlyFireDamageMultiplier = other.playerFriendlyFireDamageMultiplier;
        ServerModConfig.INSTANCE.allowEquipmentDrop = other.allowEquipmentDrop;
        ServerModConfig.INSTANCE.shareExperienceWithPlayer = other.shareExperienceWithPlayer;
        ServerModConfig.INSTANCE.enablePlayerPuppets = other.enablePlayerPuppets;
        ServerModConfig.INSTANCE.enableBetterMobCombat = other.enableBetterMobCombat;
        ServerModConfig.INSTANCE.enableEpicKnightsCompat = other.enableEpicKnightsCompat;
    }

    public boolean isEnableRecruitBalance() {
        return this.enableRecruitBalance;
    }

    public boolean isEnableFirstJoinManual() {
        return this.enableFirstJoinManual;
    }

    public boolean isEnableScrollLootGeneration() {
        return this.enableScrollLootGeneration;
    }

    public boolean isEnableScrollMobDrops() {
        return this.enableScrollMobDrops;
    }

    public boolean isAllowSoldierRecall() {
        return this.allowSoldierRecall;
    }

    public boolean isAllowEquipmentChange() {
        return this.allowEquipmentChange;
    }

    public double getFollowDistanceInner() {
        return this.followDistanceInner;
    }

    public double getFollowDistanceOuter() {
        return this.followDistanceOuter;
    }

    public float getBaseCombatEntityPathfindingRange() {
        return this.baseCombatEntityPathfindingRange;
    }

    public int getPathfindingTasksPerTick() {
        return this.pathfindingTasksPerTick;
    }

    public int getSoldierLevelCap() {
        return this.soldierLevelCap;
    }

    public boolean isAllowLevel4ArmySummoning() {
        return this.allowLevel4ArmySummoning;
    }

    public boolean isAllowNecromancySummoning() {
        return this.allowNecromancySummoning;
    }

    public boolean isEnableWorshipMechanism() {
        return this.enableWorshipMechanism;
    }

    public boolean isAllowSiegeRecall() {
        return this.allowSiegeRecall;
    }

    public boolean isAllowMeleeAttackCreeper() {
        return this.allowMeleeAttackCreeper;
    }

    public boolean isEnablePlayerPuppets() {
        return this.enablePlayerPuppets;
    }

    public double getPlayerFriendlyFireDamageMultiplier() {
        return this.playerFriendlyFireDamageMultiplier;
    }

    public boolean isAllowEquipmentDrop() {
        return this.allowEquipmentDrop;
    }

    public boolean isShareExperienceWithPlayer() {
        return this.shareExperienceWithPlayer;
    }

    public boolean isEnableBetterMobCombat() {
        return this.enableBetterMobCombat;
    }

    public boolean isEnableEpicKnightsCompat() {
        return this.enableEpicKnightsCompat;
    }

    public static String getCurrentEquipmentFileName() {
        boolean useEpicKnights = INSTANCE.isEnableEpicKnightsCompat() && FabricLoader.getInstance().isModLoaded("magistuarmory");
        return useEpicKnights ? "equipment_epic_knights.json" : "equipment.json";
    }
}

