/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.UseCrossbow;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class CrossbowmanEntity
extends BaseCombatEntity
implements class_1603,
UseCrossbow,
LightUnit,
RangedUnit,
CounterHeavy,
Mountable {
    private static final float ATTACK_REACH = 80.0f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 3.5f;
    private static final class_2940<Integer> USE_ANGLE = class_2945.method_12791(CrossbowmanEntity.class, (class_2941)class_2943.field_13327);

    public CrossbowmanEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(USE_ANGLE, (Object)1);
    }

    public static class_5132.class_5133 createCrossbowmanAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 80.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23724, 2.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23718, 0.4).method_26868(HywAttributes.ATTACK_REACH, 80.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 3.5);
    }

    @Override
    public void method_5773() {
        super.method_5773();
    }

    @Override
    protected void setDefaultEquipment() {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8399));
        this.method_5673(class_1304.field_6171, class_1799.field_8037);
        this.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8283));
        this.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8873));
        this.method_5673(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8218));
        this.method_5673(class_1304.field_6166, new class_1799((class_1935)class_1802.field_8313));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        class_1799 crossbowStack = this.method_5998(class_1268.field_5808);
        int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)crossbowStack);
        int baseCooldown = 25;
        int cooldownReduction = quickChargeLevel * 5;
        return baseCooldown - cooldownReduction;
    }

    @Override
    public int getAttackDamageTickDelay() {
        Random random = new Random();
        return Math.max(this.getBaseAttackAnimationTime() - random.nextInt(10), 5);
    }

    @Override
    public int getAttackCoolDownDuration() {
        class_1799 crossbowStack = this.method_5998(class_1268.field_5808);
        int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)crossbowStack);
        Random random = new Random();
        int baseCooldown = 60 + random.nextInt(20);
        int cooldownReduction = quickChargeLevel * 10;
        return Math.max(baseCooldown - cooldownReduction, 20);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        class_1799 crossbowStack = this.method_5998(class_1268.field_5808);
        int piercingLevel = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)crossbowStack);
        int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)crossbowStack);
        boolean hasMultishot = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)crossbowStack) > 0;
        float speed = 3.0f;
        float inaccuracy = 2.0f;
        if (hasMultishot) {
            for (int i = -1; i <= 1; ++i) {
                class_1665 arrow = this.createArrow(crossbowStack, piercingLevel);
                this.shootArrowAtTarget(arrow, target, speed, inaccuracy, i * 10);
            }
        } else {
            class_1665 arrow = this.createArrow(crossbowStack, piercingLevel);
            this.shootArrowAtTarget(arrow, target, speed, inaccuracy, 0.0f);
        }
        this.method_5783(class_3417.field_15187, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        this.method_6021();
    }

    private class_1665 createArrow(class_1799 crossbowStack, int piercingLevel) {
        class_1665 arrow = class_1675.method_18813((class_1309)this, (class_1799)new class_1799((class_1935)class_1802.field_8107), (float)1.0f);
        arrow.method_7438(this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE));
        if (piercingLevel > 0) {
            arrow.method_7451((byte)piercingLevel);
        }
        return arrow;
    }

    private void shootArrowAtTarget(class_1665 arrow, class_1309 target, float speed, float inaccuracy, float yawOffset) {
        double dy;
        double dz;
        double dx = target.method_23317() - this.method_23317();
        double distance = Math.sqrt(dx * dx + (dz = target.method_23321() - this.method_23321()) * dz + (dy = target.method_23323(0.5) - arrow.method_23318()) * dy);
        if (distance == 0.0) {
            return;
        }
        double gravity = 0.05;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        if (!(!Double.isNaN(angles[1]) && this.isPathClear(arrow, angles[1], speed, dx, dy, dz, distance, target) || distance < 5.0)) {
            return;
        }
        double angle = angles[1];
        double randomSpeedOffset = CrossbowmanEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.method_18798().method_10216();
        double targetVelocityZ = target.method_18798().method_10215();
        double predictedX = target.method_23317() + targetVelocityX * timeToTarget;
        double predictedZ = target.method_23321() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - this.method_23317()) * (predictedX - this.method_23317()) + (predictedZ - this.method_23321()) * (predictedZ - this.method_23321()));
        angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        angle = angles[1];
        double yaw = Math.atan2(predictedZ - this.method_23321(), predictedX - this.method_23317());
        double yawOffsetRadians = Math.toRadians(yawOffset);
        double adjustedYaw = yaw + yawOffsetRadians;
        double horizontalSpeed = Math.cos(angle) * (double)speed;
        float velocityX = (float)(horizontalSpeed * Math.cos(adjustedYaw));
        float velocityY = (float)(Math.sin(angle) * (double)speed);
        float velocityZ = (float)(horizontalSpeed * Math.sin(adjustedYaw));
        arrow.method_7485((double)velocityX, (double)velocityY, (double)velocityZ, speed, inaccuracy);
        this.method_37908().method_8649((class_1297)arrow);
    }

    private boolean isPathClear(class_1665 arrow, double angle, float speed, double dx, double dy, double dz, double distance, class_1309 target) {
        class_243 startPos = this.method_33571();
        class_243 direction = new class_243(dx / distance, Math.tan(angle), dz / distance).method_1029();
        class_243 endPos = startPos.method_1019(direction.method_1021(5.0));
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)arrow));
        return hitResult.method_17783() == class_239.class_240.field_1333;
    }

    private boolean isTargetExposedToSky(class_1309 target) {
        class_2338 targetPos = target.method_24515();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 posToCheck = targetPos.method_10069(x, 0, z);
                if (!this.method_37908().method_8311(posToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(5, (class_1352)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    @Override
    public class_1792 getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> HywItemRegistry.SCROLL_CROSSBOWMAN;
            case 2 -> HywItemRegistry.SCROLL_CROSSBOWMAN_1;
            case 3 -> HywItemRegistry.SCROLL_CROSSBOWMAN_2;
            case 4 -> HywItemRegistry.SCROLL_CROSSBOWMAN_3;
            default -> null;
        };
    }

    @Override
    public boolean isValidTarget(class_1309 potentialTarget) {
        if (this.isObstructed(potentialTarget)) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    @Override
    public boolean canFireAtTarget(class_1309 target) {
        if (this.isObstructed(target)) {
            return false;
        }
        return super.canFireAtTarget(target);
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        super.increaseStatsOnLevelUp();
        class_1324 rangedAttackDamage = this.method_5996(HywAttributes.RANGED_ATTACK_DAMAGE);
        if (rangedAttackDamage != null) {
            rangedAttackDamage.method_6192(rangedAttackDamage.method_6201() + 0.1);
        }
    }

    @Override
    public double getLightDamageModifier() {
        return 0.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 1.5;
    }
}

