/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1496;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.entity.utils.PathfindingUtil;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;

public class FormMoveGoal
extends class_1352
implements CommandedGoal,
MoveGoal {
    private class_11 currentPath;
    private boolean init = true;
    private double formationSpeed;
    private double totalMovedDistance = 0.0;
    private final UUID FormationUUID;
    private FormationManager.FormationStatus status;
    private boolean formCompleted = false;
    private boolean shouldRemove = false;
    private final int waitLimitTicks = 60;
    private int waitLimit = -1;
    private BaseCombatEntity mob;
    private final double speed;
    private class_2338 targetPos;
    private double newTargetX;
    private double newTargetY;
    private double newTargetZ;
    private static final double ARRIVAL_THRESHOLD = 5.0;
    private double minSpeed;
    private boolean pathGenerated = false;
    private static final double SMALL_FORM_DISTANCE_THRESHOLD = 5.0;
    private static final UUID FORMATION_SPEED_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440001");
    private static final UUID RIDER_SPEED_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440012");

    public FormMoveGoal(BaseCombatEntity mob, double speed, UUID formationUUID, double minSpeed) {
        this.mob = mob;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.FormationUUID = formationUUID;
        this.formationSpeed = mob.method_26825(class_5134.field_23719);
        this.minSpeed = minSpeed;
    }

    public void setTargetPos(class_2338 targetPos) {
        this.targetPos = targetPos.method_10084();
    }

    public boolean method_6264() {
        if (this.targetPos == null) {
            return false;
        }
        return !this.shouldRemove;
    }

    public boolean method_6266() {
        return !this.shouldRemove;
    }

    public void method_6269() {
        if (this.init) {
            double formDistance = FormationManager.getFormationStatus(this.FormationUUID).getFormDistance();
            class_243 formDirection = FormationManager.getFormationStatus(this.FormationUUID).getFormDirection();
            class_243 movementVector = formDirection.method_1021(formDistance);
            class_2338 homePos = new class_2338((int)((double)this.targetPos.method_10263() + movementVector.field_1352), this.targetPos.method_10264(), (int)((double)this.targetPos.method_10260() + movementVector.field_1350));
            this.mob.setHomePosition(homePos);
            this.mob.setFormationUUID(this.FormationUUID);
            if (this.FormationUUID != null) {
                this.status = FormationManager.getFormationStatus(this.FormationUUID);
            }
            this.newTargetX = this.targetPos.method_10263();
            this.newTargetZ = this.targetPos.method_10260();
            this.mob.setCommandHold(false);
            PathfindingUtil.moveTo(this.mob, this.targetPos, this.speed, () -> {
                this.pathGenerated = true;
            });
            this.init = false;
        }
    }

    public void method_6270() {
        if (this.mob != null) {
            class_1324 speedAttr;
            BaseCombatEntity targetEntity = this.mob;
            class_1297 class_12972 = this.mob.method_5854();
            if (class_12972 instanceof class_1496) {
                class_1496 horse = (class_1496)class_12972;
                targetEntity = horse;
            }
            if ((speedAttr = targetEntity.method_5996(class_5134.field_23719)) != null && speedAttr.method_6199(FORMATION_SPEED_MODIFIER_UUID) != null) {
                speedAttr.method_6200(FORMATION_SPEED_MODIFIER_UUID);
            }
        }
        this.mob.method_5942().method_6340();
        FormationManager.getFormationStatus(this.FormationUUID).markEntityReady(this.mob);
    }

    public void method_6268() {
        class_2338 currentHorizontalPos;
        if (this.targetPos == null) {
            return;
        }
        this.updateTargetPos();
        if (this.status != null) {
            if (this.waitLimit == -1) {
                int size = this.status.getFormationSize();
                this.waitLimit = Math.max(2 * size, 60);
            }
            if (!this.status.getFormationReadyEntities().isEmpty()) {
                --this.waitLimit;
            }
        }
        if ((currentHorizontalPos = new class_2338((int)Math.floor(this.mob.method_23317()), this.targetPos.method_10264(), (int)Math.floor(this.mob.method_23321()))).method_19771((class_2382)this.targetPos, 5.0)) {
            FormationManager.markEntityReady(this.FormationUUID, this.mob);
            if (this.formCompleted) {
                FormationManager.getFormationStatus(this.FormationUUID).markTargetReached(this.mob);
                this.shouldRemove = true;
                this.executeNext();
            } else {
                this.startMove(this.mob, this.speed - (double)0.2f);
            }
            if (FormationManager.FormationReadyAll(this.FormationUUID) || this.waitLimit == 0) {
                this.formCompleted = true;
                this.pathGenerated = false;
                PathfindingUtil.moveTo(this.mob, this.targetPos, this.speed, () -> {
                    this.pathGenerated = true;
                });
            }
        } else {
            if (this.formCompleted) {
                this.setEntitySpeed(this.mob, this.minSpeed);
                this.startMove(this.mob, this.speed);
            } else if (this.shouldSpeedUp(this.status, currentHorizontalPos)) {
                this.startMove(this.mob, this.speed + 0.25);
            } else {
                this.startMove(this.mob, this.speed);
            }
            if (!this.formCompleted && this.waitLimit <= 0) {
                if (FormationManager.shouldTeleport(this.FormationUUID) && this.inTeleportRange(this.status, currentHorizontalPos)) {
                    this.safeTeleport(this.mob, this.FormationUUID);
                    FormationManager.markEntityReady(this.FormationUUID, this.mob);
                }
                FormationManager.markEntityReady(this.FormationUUID, this.mob);
            }
        }
    }

    private boolean shouldSpeedUp(FormationManager.FormationStatus status, class_2338 currentHorizontalPos) {
        return currentHorizontalPos.method_19771((class_2382)this.targetPos, (double)(2 * status.getFormationSize()));
    }

    private boolean inTeleportRange(FormationManager.FormationStatus status, class_2338 currentHorizontalPos) {
        return currentHorizontalPos.method_19771((class_2382)this.targetPos, (double)(10 * status.getFormationSize()));
    }

    private void safeTeleport(BaseCombatEntity mob, UUID formationUUID) {
        class_2338 position;
        class_2338 safePosition;
        Set<BaseCombatEntity> formationReadyEntities = FormationManager.getFormationStatus(formationUUID).getFormationReadyEntities();
        ArrayList<BaseCombatEntity> entityList = new ArrayList<BaseCombatEntity>(formationReadyEntities);
        BaseCombatEntity closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        class_2338 mobPosition = mob.method_24515();
        for (BaseCombatEntity entity : entityList) {
            double distance = mobPosition.method_10262((class_2382)entity.method_24515());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        if (closestEntity != null && (safePosition = this.findSafePosition(position = closestEntity.method_24515(), mob)) != null) {
            mob.method_5859(safePosition.method_10263(), safePosition.method_10264(), safePosition.method_10260());
        }
        if (FormationManager.FormationReadyAll(formationUUID)) {
            this.formCompleted = true;
            this.pathGenerated = false;
            PathfindingUtil.moveTo(mob, this.targetPos, this.speed, () -> {
                this.pathGenerated = true;
            });
        }
    }

    private class_2338 findSafePosition(class_2338 position, BaseCombatEntity mob) {
        class_1937 level = ((EntityAccessor)((Object)mob)).getLevel();
        int radius = 5;
        if (this.isPositionSafe(level, position, mob)) {
            return position;
        }
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 newPos = position.method_10069(dx, dy, dz);
                    if (!this.isPositionSafe(level, newPos, mob)) continue;
                    return newPos;
                }
            }
        }
        return null;
    }

    private boolean isPositionSafe(class_1937 level, class_2338 position, BaseCombatEntity mob) {
        class_238 boundingBox = mob.method_5829().method_989((double)position.method_10263() - mob.method_23317(), (double)position.method_10264() - mob.method_23318(), (double)position.method_10260() - mob.method_23321());
        return level.method_8587((class_1297)mob, boundingBox);
    }

    private void startMove(BaseCombatEntity mob, double speed) {
        if (this.pathGenerated) {
            PathfindingUtil.continueVanillaMovement(mob, this.targetPos, speed);
        }
    }

    private void updateTargetPos() {
        FormationManager.FormationStatus formationStatus = FormationManager.getFormationStatus(this.FormationUUID);
        double formDistance = formationStatus.getFormDistance();
        if (this.totalMovedDistance >= formDistance) {
            return;
        }
        if (formDistance < 5.0) {
            class_243 formDirection = formationStatus.getFormDirection();
            class_243 finalTarget = new class_243((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260()).method_1019(formDirection.method_1021(formDistance));
            this.newTargetX = finalTarget.field_1352;
            this.newTargetZ = finalTarget.field_1350;
            this.targetPos = new class_2338((int)this.newTargetX, this.targetPos.method_10264(), (int)this.newTargetZ);
            this.totalMovedDistance = formDistance;
            class_1937 level = ((EntityAccessor)((Object)this.mob)).getLevel();
            this.targetPos = this.adjustYCoordinate(this.targetPos, level, 10);
            return;
        }
        double targetSpeed = this.formCompleted ? this.formationSpeed * 3.0 : (this.speed - (double)0.2f) * this.formationSpeed;
        class_243 formDirection = formationStatus.getFormDirection();
        class_243 movementVector = formDirection.method_1021(targetSpeed);
        double movementDistance = movementVector.method_1033();
        if (this.totalMovedDistance + movementDistance <= formDistance) {
            this.newTargetX += movementVector.field_1352;
            this.newTargetZ += movementVector.field_1350;
            this.targetPos = new class_2338((int)this.newTargetX, this.targetPos.method_10264(), (int)this.newTargetZ);
            this.totalMovedDistance += movementDistance;
        } else {
            this.updatePositionWithRemainingDistance(formDirection, targetSpeed, formDistance, movementDistance);
        }
        if (this.formCompleted) {
            this.updatePositionWithRemainingDistance(formDirection, targetSpeed, formDistance, movementDistance);
        }
        class_1937 level = ((EntityAccessor)((Object)this.mob)).getLevel();
        this.targetPos = this.adjustYCoordinate(this.targetPos, level, 10);
    }

    private void updatePositionWithRemainingDistance(class_243 formDirection, double targetSpeed, double formDistance, double movementDistance) {
        double remainingDistance = formDistance - this.totalMovedDistance;
        if (remainingDistance > 0.0) {
            class_243 adjustedMovementVector = formDirection.method_1021(remainingDistance / movementDistance * targetSpeed);
            this.newTargetX += adjustedMovementVector.field_1352;
            this.newTargetZ += adjustedMovementVector.field_1350;
            this.targetPos = new class_2338((int)this.newTargetX, this.targetPos.method_10264(), (int)this.newTargetZ);
            this.totalMovedDistance = formDistance;
        }
    }

    private class_2338 adjustYCoordinate(class_2338 pos, class_1937 level, int maxCheckRange) {
        for (int i = 0; i < maxCheckRange; ++i) {
            class_2338 up = pos.method_10086(i);
            if (!level.method_22347(up) || level.method_22347(up.method_10074()) || !this.isPositionSafe(level, up, this.mob)) continue;
            return up;
        }
        return pos;
    }

    private void setEntitySpeed(BaseCombatEntity entity, double speedValue) {
        class_1322 existingModifier;
        class_1324 speedAttr;
        BaseCombatEntity targetEntity = entity;
        class_1297 class_12972 = entity.method_5854();
        if (class_12972 instanceof class_1496) {
            class_1496 horse = (class_1496)class_12972;
            targetEntity = horse;
        }
        if ((speedAttr = targetEntity.method_5996(class_5134.field_23719)) == null) {
            return;
        }
        class_1322 riderModifier = speedAttr.method_6199(RIDER_SPEED_UUID);
        if (riderModifier != null) {
            speedAttr.method_6200(RIDER_SPEED_UUID);
        }
        if ((existingModifier = speedAttr.method_6199(FORMATION_SPEED_MODIFIER_UUID)) != null) {
            speedAttr.method_6200(FORMATION_SPEED_MODIFIER_UUID);
        }
        double baseValue = speedAttr.method_6201();
        double multiplier = speedValue / baseValue - 1.0;
        speedAttr.method_26835(new class_1322(FORMATION_SPEED_MODIFIER_UUID, "Formation movement speed", multiplier, class_1322.class_1323.field_6331));
    }

    @Override
    public void executeNext() {
        this.mob.setShouldExecuteNext(true);
        this.mob.goalFinished();
    }

    public UUID getFormationUUID() {
        return this.FormationUUID;
    }

    @Override
    public void updateEntityReference(BaseCombatEntity newEntity) {
        FormationManager.FormationStatus formationStatus;
        this.mob = newEntity;
        this.mob.setFormationUUID(this.FormationUUID);
        if (this.FormationUUID != null && (formationStatus = FormationManager.getFormationStatus(this.FormationUUID)) != null) {
            formationStatus.getEntities().add(newEntity);
            int currentSize = formationStatus.getEntities().size();
            formationStatus.setFormationSize(currentSize);
        }
    }
}

