/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.navigation;

import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3481;
import net.minecraft.class_7;
import net.minecraft.class_9;

public class LadderAwareNodeEvaluator
extends class_14 {
    public int method_18(class_9[] nodes, class_9 node) {
        class_2350[] directions;
        int count = super.method_18(nodes, node);
        class_2338 currentPos = new class_2338(node.field_40, node.field_39, node.field_38);
        if (!this.shouldUseLadderPathfinding(currentPos)) {
            return count;
        }
        count = this.addVerticalNodes(nodes, count, node, currentPos);
        count = this.addLadderNodesAtLevel(nodes, count, node, currentPos.method_10084());
        count = this.addLadderNodesAtLevel(nodes, count, node, currentPos.method_10074());
        for (class_2350 dir : directions = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            class_2338 adjacentPos = currentPos.method_10093(dir);
            count = this.addLadderNodesAtLevel(nodes, count, node, adjacentPos);
            count = this.addLadderNodesAtLevel(nodes, count, node, adjacentPos.method_10084());
            count = this.addLadderNodesAtLevel(nodes, count, node, adjacentPos.method_10074());
        }
        return Math.min(count, nodes.length - 1);
    }

    private int addVerticalNodes(class_9[] nodes, int currentCount, class_9 centerNode, class_2338 currentPos) {
        int count = currentCount;
        if (this.field_20622.method_8320(currentPos).method_26164(class_3481.field_22414)) {
            class_9 downNode;
            class_9 upNode = this.getVerticalNode(centerNode.field_40, centerNode.field_39 + 1, centerNode.field_38, class_2350.field_11036);
            if (upNode != null && this.method_20536(upNode, centerNode) && count < nodes.length) {
                nodes[count++] = upNode;
            }
            if ((downNode = this.getVerticalNode(centerNode.field_40, centerNode.field_39 - 1, centerNode.field_38, class_2350.field_11033)) != null && this.method_20536(downNode, centerNode) && count < nodes.length) {
                nodes[count++] = downNode;
            }
        }
        return count;
    }

    private int addLadderNodesAtLevel(class_9[] nodes, int currentCount, class_9 centerNode, class_2338 checkPos) {
        class_2338 standingPos;
        class_9 platformNode;
        int count = currentCount;
        if (checkPos.method_10264() < this.field_20622.method_31607() || checkPos.method_10264() >= this.field_20622.method_31600()) {
            return count;
        }
        if (this.field_20622.method_8320(checkPos).method_26164(class_3481.field_22414)) {
            class_9 ladderNode = this.method_13(checkPos.method_10263(), checkPos.method_10264(), checkPos.method_10260());
            if (ladderNode != null && this.method_20536(ladderNode, centerNode) && count < nodes.length) {
                ladderNode.field_41 = class_7.field_7;
                int deltaY = checkPos.method_10264() - centerNode.field_39;
                ladderNode.field_43 = deltaY > 0 ? 0.0f : (deltaY < 0 ? 0.0f : 0.0f);
                nodes[count++] = ladderNode;
            }
            count = this.addAdjacentPlatformNodes(nodes, count, centerNode, checkPos);
        } else if (this.isStandablePlatform(checkPos) && (platformNode = this.method_13((standingPos = checkPos.method_10084()).method_10263(), standingPos.method_10264(), standingPos.method_10260())) != null && this.method_20536(platformNode, centerNode) && count < nodes.length) {
            platformNode.field_41 = class_7.field_7;
            int deltaY = standingPos.method_10264() - centerNode.field_39;
            platformNode.field_43 = deltaY > 0 ? 1.8f : (deltaY < 0 ? 1.5f : 1.2f);
            nodes[count++] = platformNode;
        }
        return count;
    }

    private class_9 getVerticalNode(int x, int y, int z, class_2350 direction) {
        class_9 verticalNode;
        if (y < this.field_20622.method_31607() || y >= this.field_20622.method_31600()) {
            return null;
        }
        class_2338 targetPos = new class_2338(x, y, z);
        if (direction == class_2350.field_11036) {
            class_9 verticalNode2;
            if ((this.field_20622.method_8320(targetPos).method_26164(class_3481.field_22414) || this.field_20622.method_8320(targetPos).method_26215() || this.isStandablePlatform(targetPos)) && (verticalNode2 = this.method_13(x, y, z)) != null) {
                verticalNode2.field_41 = class_7.field_7;
                verticalNode2.field_43 = this.isStandablePlatform(targetPos) ? 1.5f : 1.1f;
                return verticalNode2;
            }
        } else if (direction == class_2350.field_11033 && this.field_20622.method_8320(targetPos).method_26164(class_3481.field_22414) && (verticalNode = this.method_13(x, y, z)) != null) {
            verticalNode.field_41 = class_7.field_7;
            verticalNode.field_43 = 1.0f;
            return verticalNode;
        }
        return null;
    }

    private boolean isStandablePlatform(class_2338 pos) {
        if (!this.field_20622.method_8320(pos).method_26216((class_1922)this.field_20622, pos)) {
            return false;
        }
        class_2338 above1 = pos.method_10084();
        class_2338 above2 = pos.method_10086(2);
        return this.field_20622.method_8320(above1).method_26215() && this.field_20622.method_8320(above2).method_26215();
    }

    private int addAdjacentPlatformNodes(class_9[] nodes, int currentCount, class_9 centerNode, class_2338 ladderPos) {
        class_2350[] directions;
        int count = currentCount;
        for (class_2350 dir : directions = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            class_2338 standingPos;
            class_9 platformNode;
            class_2338 adjacentPos = ladderPos.method_10093(dir);
            if (!this.isStandablePlatform(adjacentPos) || count >= nodes.length || (platformNode = this.method_13((standingPos = adjacentPos.method_10084()).method_10263(), standingPos.method_10264(), standingPos.method_10260())) == null || !this.method_20536(platformNode, centerNode)) continue;
            platformNode.field_41 = class_7.field_7;
            platformNode.field_43 = 1.6f;
            nodes[count++] = platformNode;
        }
        return count;
    }

    protected boolean method_47893(class_2338 blockPos) {
        class_7 blockPathTypes = this.method_63(this.field_33, blockPos);
        if (this.field_20622.method_8320(blockPos).method_26164(class_3481.field_22414)) {
            return true;
        }
        if (this.isStandablePlatform(blockPos)) {
            return true;
        }
        return blockPathTypes != class_7.field_7 && this.field_33.method_5944(blockPathTypes) >= 0.0f;
    }

    public boolean method_20536(class_9 node, class_9 neighbor) {
        int deltaY;
        if (node == null || neighbor == null) {
            return false;
        }
        if ((this.isLadderNode(node) || this.isLadderNode(neighbor)) && (deltaY = Math.abs(node.field_39 - neighbor.field_39)) > 1) {
            return this.hasLadderConnection(node, neighbor);
        }
        return super.method_20536(node, neighbor);
    }

    private boolean isLadderNode(class_9 node) {
        if (node == null) {
            return false;
        }
        class_2338 pos = new class_2338(node.field_40, node.field_39, node.field_38);
        return this.field_20622.method_8320(pos).method_26164(class_3481.field_22414);
    }

    private boolean shouldUseLadderPathfinding(class_2338 currentPos) {
        class_2350[] directions;
        if (this.field_20622.method_8320(currentPos).method_26164(class_3481.field_22414) || this.field_20622.method_8320(currentPos.method_10074()).method_26164(class_3481.field_22414) || this.field_20622.method_8320(currentPos.method_10084()).method_26164(class_3481.field_22414)) {
            return true;
        }
        for (class_2350 dir : directions = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            class_2338 adjacentPos = currentPos.method_10093(dir);
            if (this.field_20622.method_8320(adjacentPos).method_26164(class_3481.field_22414) || this.field_20622.method_8320(adjacentPos.method_10074()).method_26164(class_3481.field_22414) || this.field_20622.method_8320(adjacentPos.method_10084()).method_26164(class_3481.field_22414)) {
                return true;
            }
            class_2338 farPos = currentPos.method_10079(dir, 2);
            if (!this.field_20622.method_8320(farPos).method_26164(class_3481.field_22414) && !this.field_20622.method_8320(farPos.method_10074()).method_26164(class_3481.field_22414) && !this.field_20622.method_8320(farPos.method_10084()).method_26164(class_3481.field_22414)) continue;
            return true;
        }
        return false;
    }

    private boolean hasLadderConnection(class_9 from, class_9 to) {
        if (from == null || to == null) {
            return false;
        }
        if (from.field_40 != to.field_40 || from.field_38 != to.field_38) {
            return false;
        }
        int minY = Math.min(from.field_39, to.field_39);
        int maxY = Math.max(from.field_39, to.field_39);
        for (int y = minY; y <= maxY; ++y) {
            class_2338 checkPos = new class_2338(from.field_40, y, from.field_38);
            if (this.field_20622.method_8320(checkPos).method_26164(class_3481.field_22414)) continue;
            return false;
        }
        return true;
    }

    public class_9 method_21() {
        class_2338 currentPos = this.field_33.method_24515();
        if (this.field_20622.method_8320(currentPos).method_26164(class_3481.field_22414) || this.field_20622.method_8320(currentPos.method_10074()).method_26164(class_3481.field_22414)) {
            if (this.method_47893(currentPos)) {
                return this.method_43415(currentPos);
            }
            class_2338 abovePos = currentPos.method_10084();
            if (this.method_47893(abovePos)) {
                return this.method_43415(abovePos);
            }
            class_2338 belowPos = currentPos.method_10074();
            if (this.method_47893(belowPos)) {
                return this.method_43415(belowPos);
            }
        }
        return super.method_21();
    }
}

