/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.utils;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_1496;
import net.minecraft.class_1603;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.FormMoveGoal;
import ydmsama.hundred_years_war.main.entity.goals.MoveToBlockGoal;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;

public class FormationManager {
    private static Map<UUID, FormationStatus> formations = new ConcurrentHashMap<UUID, FormationStatus>();
    private static class_2338 lastPos;

    public static UUID createNewFormation(List<BaseCombatEntity> entities) {
        UUID formationId = UUID.randomUUID();
        FormationStatus status = new FormationStatus(entities);
        status.setFormationSize(entities.size());
        formations.put(formationId, status);
        return formationId;
    }

    public static FormationStatus getFormationStatus(UUID formationId) {
        if (formationId == null) {
            return null;
        }
        return formations.get(formationId);
    }

    public static void clearFormation(UUID formationId) {
        formations.remove(formationId);
    }

    public static boolean targetReachAll(UUID formationId) {
        return FormationManager.getFormationStatus(formationId).isTargetReached();
    }

    public static void clearTargetReached(UUID formationId) {
        FormationManager.getFormationStatus(formationId).clearTargetReached();
    }

    public static void setFormationSize(UUID formationId, int size) {
        FormationManager.getFormationStatus(formationId).setFormationSize(size);
    }

    public static void markEntityReady(UUID formationId, BaseCombatEntity entity) {
        FormationManager.getFormationStatus(formationId).markEntityReady(entity);
    }

    public static boolean FormationReadyAll(UUID formationId) {
        return FormationManager.getFormationStatus(formationId).isFormationCompleted();
    }

    public static boolean shouldTeleport(UUID formationId) {
        return (double)FormationManager.getFormationStatus((UUID)formationId).formationReadyEntities.size() >= 0.75 * (double)FormationManager.getFormationStatus((UUID)formationId).formationSize;
    }

    public static void move(List<BaseCombatEntity> entities, class_2338 targetPos, int priority, boolean queueMode) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        if (queueMode) {
            for (int i = 0; i < entities.size(); ++i) {
                entities.get(i).setQueueMode(true);
            }
        }
        UUID formationId = FormationManager.createNewFormation(entities);
        FormationManager.moveEntitiesTo(priority, entities, targetPos, formationId);
        for (int i = 0; i < entities.size(); ++i) {
            entities.get(i).setQueueMode(false);
            double homeReturnRadius = Double.max(entities.size(), entities.get(i).getDefaultHomeReturnRadius());
            entities.get(i).setHomeReturnRadius(homeReturnRadius);
        }
        lastPos = targetPos;
    }

    public static void hold(List<BaseCombatEntity> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        for (int i = 0; i < entities.size(); ++i) {
            entities.get(i).setCommandHold(true);
            entities.get(i).setHomePosition(entities.get(i).method_24515());
        }
    }

    public static void formMove(List<BaseCombatEntity> entities, class_2338 targetPos, int priority, boolean queueMode, String formationType) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        UUID formationId = FormationManager.createNewFormation(entities);
        class_2338 startPos = FormationManager.calculateFormationCenter(entities);
        if (lastPos == null) {
            lastPos = startPos;
        }
        if (queueMode) {
            for (int i = 0; i < entities.size(); ++i) {
                entities.get(i).setQueueMode(true);
            }
            startPos = lastPos;
        }
        float yaw = FormationManager.getYawFromPositions(startPos, targetPos);
        class_243 formDirection = FormationManager.calculateDirectionVector(startPos, targetPos);
        FormationManager.getFormationStatus(formationId).setFormDirection(formDirection);
        double formDistance = Math.sqrt(startPos.method_10262((class_2382)targetPos));
        FormationManager.getFormationStatus(formationId).setFormDistance(formDistance);
        List<class_2338> positions = FormationManager.getFormationPositions(startPos, entities.size(), entities.get(0).method_37908(), formationType, yaw);
        FormationManager.moveEntitiesToFormation(entities, positions, priority, formationId);
        for (int i = 0; i < entities.size(); ++i) {
            entities.get(i).setQueueMode(false);
            entities.get(i).setHomeReturnRadius(entities.get(i).getDefaultHomeReturnRadius());
        }
        lastPos = targetPos;
    }

    public static void commandStaffFormMove(class_2338 targetPos, int priority, List<BaseCombatEntity> entities, String formationType) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        UUID formationId = FormationManager.createNewFormation(entities);
        class_2338 startPos = FormationManager.calculateFormationCenter(entities);
        float yaw = FormationManager.getYawFromPositions(startPos, targetPos);
        class_243 formDirection = FormationManager.calculateDirectionVector(startPos, targetPos);
        FormationManager.getFormationStatus(formationId).setFormDirection(formDirection);
        double formDistance = Math.sqrt(startPos.method_10262((class_2382)targetPos));
        FormationManager.getFormationStatus(formationId).setFormDistance(formDistance);
        List<class_2338> positions = FormationManager.getFormationPositions(startPos, entities.size(), entities.get(0).method_37908(), formationType, yaw);
        FormationManager.moveEntitiesToFormation(entities, positions, priority, formationId);
        for (int i = 0; i < entities.size(); ++i) {
            entities.get(i).setQueueMode(false);
            entities.get(i).setHomeReturnRadius(entities.get(i).getDefaultHomeReturnRadius());
        }
    }

    public static class_243 calculateDirectionVector(class_2338 startPos, class_2338 targetPos) {
        double dx = targetPos.method_10263() - startPos.method_10263();
        double dz = targetPos.method_10260() - startPos.method_10260();
        class_243 direction = new class_243(dx, 0.0, dz);
        return direction.method_1029();
    }

    public static class_2338 calculateFormationCenter(List<BaseCombatEntity> entities) {
        if (entities.isEmpty()) {
            return class_2338.field_10980;
        }
        class_243 sumPos = class_243.field_1353;
        for (BaseCombatEntity entity : entities) {
            sumPos = sumPos.method_1031(entity.method_23317(), entity.method_23318(), entity.method_23321());
        }
        class_243 averagePos = sumPos.method_1021(1.0 / (double)entities.size());
        return new class_2338((int)Math.floor(averagePos.method_10216()), (int)Math.floor(averagePos.method_10214()), (int)Math.floor(averagePos.method_10215()));
    }

    public static float getYawFromPositions(class_2338 currentCenterPos, class_2338 targetPos) {
        double deltaX = targetPos.method_10263() - currentCenterPos.method_10263();
        double deltaZ = targetPos.method_10260() - currentCenterPos.method_10260();
        double yawRadians = Math.atan2(deltaZ, deltaX);
        double yawDegrees = Math.toDegrees(yawRadians);
        double minecraftYaw = (yawDegrees - 90.0) % 360.0;
        if (minecraftYaw < 0.0) {
            minecraftYaw += 360.0;
        }
        minecraftYaw = (minecraftYaw % 360.0 + 360.0) % 360.0;
        return (float)minecraftYaw;
    }

    public static List<class_2338> getFormationPositions(class_2338 center, int numUnits, class_1937 level, String formationType, float yaw) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        switch (formationType) {
            case "tight": {
                int spacing = 2;
                int[] dimensions = FormationManager.calculateRectangularDimensions(numUnits, "tight");
                positions.addAll(FormationManager.generateRectangularFormation(center, numUnits, level, spacing, yaw, dimensions[0], dimensions[1]));
                break;
            }
            case "line": {
                int spacing = 2;
                int[] dimensions = FormationManager.calculateRectangularDimensions(numUnits, "line");
                positions.addAll(FormationManager.generateRectangularFormation(center, numUnits, level, spacing, yaw, dimensions[0], dimensions[1]));
                break;
            }
            case "circle": {
                int spacing = 2;
                int emptyRings = FormationManager.computeEmptyRings(numUnits, 0.3);
                positions.addAll(FormationManager.generateSmartHollowCircularFormation(center, numUnits, level, spacing, emptyRings, yaw));
                Collections.reverse(positions);
                break;
            }
            case "wedge": {
                int lateralSpacing = 2;
                int depthSpacing = 4;
                positions.addAll(FormationManager.generateWedgeFormation(center, numUnits, level, lateralSpacing, depthSpacing, yaw));
                break;
            }
            default: {
                int spacing = 4;
                int[] dimensions = FormationManager.calculateRectangularDimensions(numUnits, "loose");
                positions.addAll(FormationManager.generateRectangularFormation(center, numUnits, level, spacing, yaw, dimensions[0], dimensions[1]));
            }
        }
        return positions;
    }

    private static List<class_2338> generateRectangularFormation(class_2338 center, int numUnits, class_1937 level, int spacing, float yaw, int formationHeight, int formationWidth) {
        ArrayList<class_2338> generatedPositions = new ArrayList<class_2338>();
        if (numUnits <= 0) {
            return generatedPositions;
        }
        class_2338 start = center.method_10069(-(formationWidth / 2 * spacing), 0, -(formationHeight / 2 * spacing));
        int counter = 0;
        for (int i = formationHeight - 1; i >= 0; --i) {
            for (int j = formationWidth - 1; j >= 0 && counter < numUnits; ++counter, --j) {
                class_2338 pos = start.method_10069(j * spacing, 0, i * spacing);
                class_2338 rotatedPos = FormationManager.rotatePosition(center, pos, yaw);
                class_2338 adjustedPos = FormationManager.adjustYCoordinate(rotatedPos, level, 10);
                generatedPositions.add(adjustedPos);
            }
            if (counter >= numUnits) break;
        }
        return generatedPositions;
    }

    public static int[] calculateRectangularDimensions(int numUnits, String formationType) {
        int width;
        int height;
        if (numUnits <= 0) {
            return new int[]{0, 0};
        }
        switch (formationType) {
            case "line": {
                height = (int)Math.ceil(Math.sqrt((double)numUnits / 10.0));
                if (height == 0) {
                    height = 1;
                }
                width = (int)Math.ceil((double)numUnits / (double)height);
                break;
            }
            default: {
                height = (int)Math.ceil(Math.sqrt((double)numUnits * 3.0 / 5.0));
                if (height == 0) {
                    height = 1;
                }
                if ((width = (int)Math.ceil((double)numUnits / (double)height)) >= height || numUnits <= 1) break;
                int temp = height;
                height = width;
                width = temp;
            }
        }
        if (height * width < numUnits) {
            if (width >= height) {
                width = (int)Math.ceil((double)numUnits / (double)height);
            } else {
                height = (int)Math.ceil((double)numUnits / (double)width);
            }
        }
        if (numUnits == 1) {
            height = 1;
            width = 1;
        }
        return new int[]{height, width};
    }

    private static int computeEmptyRings(int numUnits, double ratio) {
        if (numUnits <= 3) {
            return 0;
        }
        int unitsPlaced = 0;
        int ring = 0;
        while (unitsPlaced < numUnits) {
            int capacity = (int)Math.floor(Math.PI * 2 * (double)(ring + 1));
            unitsPlaced += capacity;
            ++ring;
        }
        int totalRings = ring;
        int emptyRings = (int)Math.ceil((double)totalRings * ratio);
        return Math.max(1, emptyRings);
    }

    private static List<class_2338> generateCircularFormation(class_2338 center, int numUnits, class_1937 level, int spacing, float yaw) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>(numUnits);
        if (numUnits <= 0) {
            return positions;
        }
        if (numUnits == 1) {
            positions.add(FormationManager.adjustYCoordinate(center, level, 10));
            return positions;
        }
        double yawRad = Math.toRadians(yaw);
        int unitsRemaining = numUnits;
        int ringIndex = 0;
        while (unitsRemaining > 0) {
            double r = spacing * (ringIndex + 1);
            int maxInRing = (int)Math.floor(Math.PI * 2 * r / (double)spacing);
            maxInRing = Math.max(1, maxInRing);
            int unitsThisRing = Math.min(maxInRing, unitsRemaining);
            double angleStep = Math.PI * 2 / (double)unitsThisRing;
            for (int i = 0; i < unitsThisRing; ++i) {
                double theta = (double)i * angleStep + yawRad;
                int dx = (int)Math.round(r * Math.cos(theta));
                int dz = (int)Math.round(r * Math.sin(theta));
                class_2338 rawPos = center.method_10069(dx, 0, dz);
                positions.add(FormationManager.adjustYCoordinate(rawPos, level, 10));
            }
            unitsRemaining -= unitsThisRing;
            ++ringIndex;
        }
        return positions;
    }

    private static List<class_2338> generateSmartHollowCircularFormation(class_2338 center, int numUnits, class_1937 level, int spacing, int emptyRings, float yaw) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>(numUnits);
        if (numUnits <= 0) {
            return positions;
        }
        if (numUnits <= 3 || emptyRings == 0) {
            return FormationManager.generateCircularFormation(center, numUnits, level, spacing, yaw);
        }
        double yawRad = Math.toRadians(yaw);
        int unitsRemaining = numUnits;
        int ringIdx = emptyRings;
        int lastRingStart = -1;
        while (unitsRemaining > 0) {
            double r = spacing * (ringIdx + 1);
            int cap = (int)Math.floor(Math.PI * 2 * r / (double)spacing);
            if (unitsRemaining < (cap = Math.max(1, cap)) && lastRingStart < 0) {
                cap = unitsRemaining;
            }
            if (unitsRemaining < cap) {
                List<class_2338> lastRing = positions.subList(lastRingStart, positions.size());
                int newCount = lastRing.size() + unitsRemaining;
                lastRing.clear();
                double rLast = spacing * ringIdx;
                double angleStep = Math.PI * 2 / (double)newCount;
                for (int i = 0; i < newCount; ++i) {
                    double theta = (double)i * angleStep + yawRad;
                    int dx = (int)Math.round(rLast * Math.cos(theta));
                    int dz = (int)Math.round(rLast * Math.sin(theta));
                    class_2338 raw = center.method_10069(dx, 0, dz);
                    lastRing.add(FormationManager.adjustYCoordinate(raw, level, 10));
                }
                unitsRemaining = 0;
                break;
            }
            lastRingStart = positions.size();
            double angleStep = Math.PI * 2 / (double)cap;
            for (int i = 0; i < cap; ++i) {
                double theta = (double)i * angleStep + yawRad;
                int dx = (int)Math.round(r * Math.cos(theta));
                int dz = (int)Math.round(r * Math.sin(theta));
                class_2338 raw = center.method_10069(dx, 0, dz);
                positions.add(FormationManager.adjustYCoordinate(raw, level, 10));
            }
            unitsRemaining -= cap;
            ++ringIdx;
        }
        return positions;
    }

    private static List<class_2338> generateWedgeFormation(class_2338 center, int numUnits, class_1937 level, int lateralSpacing, int depthSpacing, float yaw) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>(numUnits);
        if (numUnits <= 0) {
            return positions;
        }
        double yawRad = Math.toRadians(yaw);
        class_243 forward = new class_243(Math.sin(yawRad), 0.0, -Math.cos(yawRad)).method_1029();
        class_243 right = new class_243(forward.field_1350, 0.0, -forward.field_1352);
        ArrayList<Integer> rowSizes = new ArrayList<Integer>();
        int unitsLeft = numUnits;
        int row = 1;
        while (unitsLeft > 0) {
            int take = Math.min(row, unitsLeft);
            rowSizes.add(take);
            unitsLeft -= take;
            ++row;
        }
        int totalRows = rowSizes.size();
        double rowsAhead = (double)(totalRows - 1) / 2.0;
        class_243 tipOffset = forward.method_1021((double)(-depthSpacing) * rowsAhead);
        class_2338 tipPos = center.method_10069((int)Math.round(tipOffset.field_1352), 0, (int)Math.round(tipOffset.field_1350));
        for (int rowIdx = 0; rowIdx < totalRows; ++rowIdx) {
            int rowCount = (Integer)rowSizes.get(rowIdx);
            class_243 centerOffset = forward.method_1021((double)(depthSpacing * rowIdx));
            class_2338 rowCenter = tipPos.method_10069((int)Math.round(centerOffset.field_1352), 0, (int)Math.round(centerOffset.field_1350));
            int offsetStep = 0;
            for (int i = 0; i < rowCount; ++i) {
                int lateral = offsetStep * lateralSpacing;
                class_243 sideOffset = right.method_1021((double)lateral);
                class_2338 raw = rowCenter.method_10069((int)Math.round(sideOffset.field_1352), 0, (int)Math.round(sideOffset.field_1350));
                positions.add(FormationManager.adjustYCoordinate(raw, level, 10));
                offsetStep = offsetStep <= 0 ? -offsetStep + 1 : -offsetStep;
            }
        }
        return positions;
    }

    public static class_2338 adjustYCoordinate(class_2338 pos, class_1937 level, int maxOffset) {
        class_2338 newPos;
        int dy;
        for (dy = 0; dy <= maxOffset; ++dy) {
            newPos = pos.method_10086(dy);
            if (!FormationManager.isGroundSuitable(newPos, level)) continue;
            return newPos;
        }
        for (dy = 1; dy <= maxOffset; ++dy) {
            newPos = pos.method_10087(dy);
            if (!FormationManager.isGroundSuitable(newPos, level)) continue;
            return newPos;
        }
        return pos;
    }

    public static boolean isGroundSuitable(class_2338 pos, class_1937 level) {
        class_2680 blockAbove = level.method_8320(pos);
        class_2680 blockBelow = level.method_8320(pos.method_10074());
        boolean canPassThroughAbove = blockAbove.method_26215() || FormationManager.canPassThroughBlock(blockAbove);
        boolean canStandOn = blockBelow.method_26206((class_1922)level, pos.method_10074(), class_2350.field_11036);
        return canPassThroughAbove && canStandOn;
    }

    private static boolean canPassThroughBlock(class_2680 blockState) {
        String blockName = blockState.method_26204().toString();
        return blockName.contains("snow") && !blockState.method_51367();
    }

    private static class_2338 rotatePosition(class_2338 center, class_2338 pos, float yaw) {
        double radians = Math.toRadians(yaw);
        int x = pos.method_10263() - center.method_10263();
        int z = pos.method_10260() - center.method_10260();
        int rotatedX = (int)Math.round((double)x * Math.cos(radians) - (double)z * Math.sin(radians));
        int rotatedZ = (int)Math.round((double)x * Math.sin(radians) + (double)z * Math.cos(radians));
        return center.method_10069(rotatedX, 0, rotatedZ);
    }

    /*
     * Unable to fully structure code
     */
    public static void moveEntitiesToFormation(List<BaseCombatEntity> entities, List<class_2338> positions, int priority, UUID formationUUID) {
        if (entities.size() != positions.size()) {
            return;
        }
        entities.sort(Comparator.comparing((Function<BaseCombatEntity, UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, method_5667(), (Lydmsama/hundred_years_war/main/entity/entities/BaseCombatEntity;)Ljava/util/UUID;)()));
        minSpeed = 1.7976931348623157E308;
        for (BaseCombatEntity entity : entities) {
            if (!(entity instanceof HorseRider)) ** GOTO lbl-1000
            horseRider = (HorseRider)entity;
            if (entity.method_5854() instanceof class_1496) {
                entitySpeed = horseRider.getHorseSpeed();
            } else if ((var12_11 = entity.method_5854()) instanceof class_1496) {
                horse = (class_1496)var12_11;
                entitySpeed = Objects.requireNonNull(horse.method_5996(class_5134.field_23719)).method_6201();
            } else {
                entitySpeed = Objects.requireNonNull(entity.method_5996(class_5134.field_23719)).method_6201();
            }
            if (!(entitySpeed < minSpeed)) continue;
            minSpeed = entitySpeed;
        }
        entities.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$moveEntitiesToFormation$0(ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity ), (Lydmsama/hundred_years_war/main/entity/entities/BaseCombatEntity;Lydmsama/hundred_years_war/main/entity/entities/BaseCombatEntity;)I)());
        for (i = 0; i < entities.size(); ++i) {
            FormationManager.formMoveEntity(entities.get(i), positions.get(i), priority, formationUUID, minSpeed);
        }
    }

    private static void moveEntitiesTo(int priority, List<BaseCombatEntity> entities, class_2338 targetPos, UUID formationUUID) {
        for (BaseCombatEntity entity : entities) {
            MoveToBlockGoal moveToBlockGoal = new MoveToBlockGoal(entity, 1.0, formationUUID);
            moveToBlockGoal.setTargetPos(targetPos);
            if (!entity.getQueueMode()) {
                entity.clearCommandedGoals();
            }
            entity.addCustomGoal(priority, moveToBlockGoal);
        }
    }

    private static void formMoveEntity(BaseCombatEntity entity, class_2338 pos, int priority, UUID formationId, double minSpeed) {
        FormMoveGoal formMoveGoal = new FormMoveGoal(entity, 1.0, formationId, minSpeed);
        formMoveGoal.setTargetPos(pos);
        entity.setHomePosition(pos);
        if (!entity.getQueueMode()) {
            entity.clearCommandedGoals();
        }
        entity.addCustomGoal(priority, formMoveGoal);
    }

    private static /* synthetic */ int lambda$moveEntitiesToFormation$0(BaseCombatEntity e1, BaseCombatEntity e2) {
        int e1Key = e1 instanceof SiegeUnit ? 5 : (e1 instanceof class_1603 ? 1 : 0);
        int e2Key = e2 instanceof SiegeUnit ? 5 : (e2 instanceof class_1603 ? 1 : 0);
        return Integer.compare(e1Key, e2Key);
    }

    public static class FormationStatus {
        private Set<BaseCombatEntity> entities;
        private Set<BaseCombatEntity> formationReadyEntities = Collections.newSetFromMap(new ConcurrentHashMap());
        private Set<BaseCombatEntity> targetReachEntities = Collections.newSetFromMap(new ConcurrentHashMap());
        private int formationSize = 0;
        private boolean formationCompleted = false;
        private boolean targetReached = false;
        private class_243 formDirection;
        private double formDistance;

        public FormationStatus(List<BaseCombatEntity> entities) {
            this.entities = ConcurrentHashMap.newKeySet();
            this.entities.addAll(entities);
        }

        public Set<BaseCombatEntity> getFormationReadyEntities() {
            return this.formationReadyEntities;
        }

        public Set<BaseCombatEntity> getTargetReachedEntities() {
            return this.targetReachEntities;
        }

        public void markTargetReached(BaseCombatEntity entity) {
            this.targetReachEntities.add(entity);
            this.checkTargetReached();
        }

        public boolean isTargetReached() {
            return this.targetReachEntities.size() == this.formationSize;
        }

        private void checkTargetReached() {
            if (this.targetReachEntities.size() == this.formationSize) {
                this.targetReached = true;
            }
        }

        public void clearTargetReached() {
            this.targetReachEntities.clear();
            this.targetReached = false;
        }

        public void setFormationSize(int size) {
            this.formationSize = size;
            this.formationReadyEntities.clear();
            this.formationCompleted = false;
        }

        public void removeEntityFromFormation(BaseCombatEntity entity) {
            this.entities.remove(entity);
            --this.formationSize;
        }

        public void markEntityReady(BaseCombatEntity entity) {
            this.formationReadyEntities.add(entity);
            this.checkFormationReady();
        }

        private void checkFormationReady() {
            this.adjustFormationSizeToAliveEntities();
            if (this.formationReadyEntities.size() == this.formationSize) {
                this.formationCompleted = true;
            }
        }

        private void adjustFormationSizeToAliveEntities() {
            Iterator<BaseCombatEntity> iterator = this.entities.iterator();
            int aliveEntitiesCount = 0;
            while (iterator.hasNext()) {
                BaseCombatEntity entity = iterator.next();
                if (entity != null && entity.method_5805()) {
                    ++aliveEntitiesCount;
                    continue;
                }
                iterator.remove();
            }
            this.formationSize = aliveEntitiesCount;
        }

        public boolean isFormationCompleted() {
            this.checkFormationReady();
            return this.formationCompleted;
        }

        public void clearFormation() {
            this.formationReadyEntities.clear();
            this.formationCompleted = false;
        }

        public int getFormationSize() {
            return this.formationSize;
        }

        public void setFormationCompleted(boolean b) {
            this.formationCompleted = b;
        }

        public void setFormDirection(class_243 formDirection) {
            this.formDirection = formDirection;
        }

        public class_243 getFormDirection() {
            return this.formDirection;
        }

        public double getFormDistance() {
            return this.formDistance;
        }

        public void setFormDistance(double formDistance) {
            this.formDistance = formDistance;
        }

        public Set<BaseCombatEntity> getEntities() {
            return this.entities;
        }

        public void setEntities(Set<BaseCombatEntity> entities) {
            this.entities = entities;
        }
    }
}

