/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.PathingTask;

public class PathingTaskManager {
    private Queue<PathingTask> taskQueue = new LinkedList<PathingTask>();
    private int maxTasksPerTick;

    public PathingTaskManager(int maxTasksPerTick) {
        this.maxTasksPerTick = maxTasksPerTick;
    }

    public void addTask(PathingTask task) {
        ((LinkedList)this.taskQueue).offerFirst(task);
    }

    public void executeTasks() {
        int tasksThisTick = 0;
        while (!this.taskQueue.isEmpty() && tasksThisTick < this.maxTasksPerTick) {
            PathingTask task = this.taskQueue.poll();
            if (task == null) continue;
            task.execute();
            ++tasksThisTick;
        }
    }

    public void clearTasks() {
        this.taskQueue.clear();
    }

    public void clearTasksForEntity(BaseCombatEntity entity) {
        this.taskQueue.removeIf(task -> task.getEntity().equals(entity));
    }

    public void clearTasksForEntities(Collection<BaseCombatEntity> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        HashSet<BaseCombatEntity> entitySet = new HashSet<BaseCombatEntity>(entities);
        this.taskQueue.removeIf(task -> entitySet.contains(task.getEntity()));
    }
}

