/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.item;

import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.RecruitBalanceConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.recruitment.PlayerRecruitmentData;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentConfigManager;
import ydmsama.hundred_years_war.main.recruitment.data.RecruitmentConfig;

public class ConquerorsStaffItem
extends class_1792 {
    public ConquerorsStaffItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public int method_7881(class_1799 stack) {
        return 20;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        player.method_6019(hand);
        return class_1271.method_22427((Object)player.method_5998(hand));
    }

    @NotNull
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 entityLiving) {
        if (!(entityLiving instanceof class_1657)) {
            return stack;
        }
        class_1657 player = (class_1657)entityLiving;
        if (!world.field_9236) {
            this.spawnArmy(world, player);
        }
        return stack;
    }

    private void spawnArmy(class_1937 world, class_1657 player) {
        PlayerRecruitmentData.RecruitmentSelection selection = PlayerRecruitmentData.getPlayerSelection(player);
        RecruitmentConfig.ArmyLevelConfig armyConfig = RecruitmentConfigManager.getArmyLevelConfig(selection.getCategoryId(), selection.getUnitTypeId(), selection.getLevel());
        if (armyConfig == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.army_config_not_found"), true);
            return;
        }
        if (!RecruitmentConfigManager.canPlayerRecruit(player, selection.getCategoryId(), selection.getUnitTypeId(), selection.getLevel())) {
            int requiredExp;
            int playerExp = this.getTotalExperience(player);
            if (playerExp < (requiredExp = armyConfig.getExpCost())) {
                player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.not_enough_exp_detail", (Object[])new Object[]{requiredExp, playerExp}), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.cannot_recruit_army"), true);
            }
            return;
        }
        for (RecruitmentConfig.UnitEntry unitEntry : armyConfig.getUnits()) {
            int count = unitEntry.getCountRange().getRandomCount();
            class_2960 entityRL = new class_2960(unitEntry.getEntityType());
            class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityRL);
            for (int i = 0; i < count; ++i) {
                class_1297 entity;
                class_243 spawnPos = this.findSafeSpawnPosition(world, player.method_24515(), 5, 5);
                if (spawnPos == null) {
                    spawnPos = player.method_24515().method_46558();
                }
                if (!((entity = entityType.method_5883(world)) instanceof BaseCombatSupport)) continue;
                BaseCombatSupport baseCombatSupport = (BaseCombatSupport)entity;
                if (!player.method_7337()) {
                    baseCombatSupport.method_6732(player.method_5667());
                }
                baseCombatSupport.setEquipment(unitEntry.getEquipmentLevel());
                baseCombatSupport.asLivingEntity().method_5814(spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350);
                baseCombatSupport.setHomePosition(new class_2338((int)spawnPos.field_1352, (int)spawnPos.field_1351, (int)spawnPos.field_1350));
                if (entity instanceof BaseCombatEntity) {
                    BaseCombatEntity baseCombatEntity = (BaseCombatEntity)entity;
                    if (RecruitBalanceConfig.ENABLE_RECRUIT_BALANCE && !player.method_7337() && !player.method_5687(2)) {
                        baseCombatEntity.setSummonWeaknessTimer(RecruitBalanceConfig.SUMMON_DEBUFF_DURATION);
                        baseCombatEntity.method_6092(new class_1293(class_1294.field_5909, RecruitBalanceConfig.SUMMON_DEBUFF_DURATION, RecruitBalanceConfig.SLOWNESS_LEVEL - 1, false, true, true));
                        baseCombatEntity.method_6092(new class_1293(class_1294.field_5911, RecruitBalanceConfig.SUMMON_DEBUFF_DURATION, RecruitBalanceConfig.WEAKNESS_LEVEL - 1, false, true, true));
                    }
                }
                world.method_8649((class_1297)baseCombatSupport.asLivingEntity());
                this.spawnParticles(world, entity.method_23317(), entity.method_23318(), entity.method_23321());
            }
        }
        this.removeExperience(player, armyConfig.getExpCost());
        player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.army_summoned", (Object[])new Object[]{class_2561.method_43471((String)armyConfig.getTranslationKey())}), true);
    }

    private class_243 findSafeSpawnPosition(class_1937 world, class_2338 centerPos, int range, int heightLimit) {
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            class_2338 pos;
            int yOffset;
            int offsetX = random.nextInt(range * 2 + 1) - range;
            int offsetZ = random.nextInt(range * 2 + 1) - range;
            int newX = centerPos.method_10263() + offsetX;
            int newZ = centerPos.method_10260() + offsetZ;
            for (yOffset = 1; yOffset <= heightLimit; ++yOffset) {
                pos = new class_2338(newX, centerPos.method_10264() + yOffset, newZ);
                if (!this.isSafeSpawnLocation(world, pos)) continue;
                return new class_243((double)newX + 0.5, (double)pos.method_10264(), (double)newZ + 0.5);
            }
            for (yOffset = 0; yOffset <= heightLimit; ++yOffset) {
                pos = new class_2338(newX, centerPos.method_10264() - yOffset, newZ);
                if (!this.isSafeSpawnLocation(world, pos)) continue;
                return new class_243((double)newX + 0.5, (double)pos.method_10264(), (double)newZ + 0.5);
            }
        }
        return null;
    }

    private boolean isSafeSpawnLocation(class_1937 world, class_2338 pos) {
        class_2680 blockStateBelow = world.method_8320(pos.method_10074());
        if (!blockStateBelow.method_51367()) {
            return false;
        }
        class_2680 blockStateAtPos = world.method_8320(pos);
        class_2680 blockStateAbove = world.method_8320(pos.method_10084());
        boolean canPassThroughAtPos = blockStateAtPos.method_26215() || this.canPassThroughBlock(blockStateAtPos);
        boolean canPassThroughAbove = blockStateAbove.method_26215() || this.canPassThroughBlock(blockStateAbove);
        return canPassThroughAtPos && canPassThroughAbove;
    }

    private boolean canPassThroughBlock(class_2680 blockState) {
        String blockName = blockState.method_26204().toString();
        return blockName.contains("snow") && !blockState.method_51367();
    }

    private void spawnParticles(class_1937 world, double x, double y, double z) {
        int particleCount = 40;
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (world.field_9229.method_43058() - 0.5) * 1.0;
                double offsetY = world.field_9229.method_43058() * 0.5 + 0.5;
                double offsetZ = (world.field_9229.method_43058() - 0.5) * 1.0;
                serverLevel.method_14199((class_2394)class_2398.field_11204, x, y + 0.5, z, 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    private int getTotalExperienceForLevel(int level) {
        if (level < 0) {
            return 0;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    private int getTotalExperience(class_1657 player) {
        int currentExp = (int)(player.field_7510 * (float)player.method_7349()) + this.getTotalExperienceForLevel(player.field_7520);
        return currentExp;
    }

    private void removeExperience(class_1657 player, int amount) {
        int currentExp = (int)(player.field_7510 * (float)player.method_7349()) + this.getTotalExperienceForLevel(player.field_7520);
        int newExp = Math.max(0, currentExp - amount);
        player.field_7520 = 0;
        player.field_7510 = 0.0f;
        player.method_7255(newExp);
    }
}

