/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.HoldGoal;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class CommandPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "command_packet");
    private final String command;
    private final boolean queueMode;

    public CommandPacket(String command, boolean queueMode) {
        this.command = command;
        this.queueMode = queueMode;
    }

    public CommandPacket(class_2540 buf) {
        this.command = buf.method_19772();
        this.queueMode = buf.readBoolean();
    }

    public void encode(class_2540 buf) {
        buf.method_10814(this.command);
        buf.writeBoolean(this.queueMode);
    }

    public static CommandPacket decode(class_2540 buf) {
        return new CommandPacket(buf);
    }

    public static void handle(class_3222 player, CommandPacket packet) {
        if (packet.command.equals("hold")) {
            SelectionSystem.getSelection(player).getEntities().forEach(entity -> {
                if (!packet.queueMode) {
                    entity.clearCommandedGoals();
                    entity.setHomePosition(entity.method_24515());
                }
                entity.clearPatrolPoints();
                entity.addCustomGoal(1, new HoldGoal((BaseCombatEntity)entity));
            });
        }
        if (packet.command.equals("cancel")) {
            List<BaseCombatEntity> entities = SelectionSystem.getSelection(player).getEntities();
            PathingTaskManagerRegistry.getInstance().clearTasksForEntities(entities);
            entities.forEach(entity -> {
                entity.clearCommandedGoals();
                entity.setHomePosition(entity.method_24515());
                entity.clearPatrolPoints();
            });
        }
    }
}

