/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.MoveToBlockGoal;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;

public class CommandStaffMovePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "command_staff_move_packet");
    private final UUID staffUUID;
    private final class_2338 targetPos;
    private final int priority;
    private final boolean formationMode;
    private final String formationType;

    public CommandStaffMovePacket(UUID staffUUID, class_2338 targetPos, int priority, boolean formationMode, String formationType) {
        this.staffUUID = staffUUID;
        this.targetPos = targetPos;
        this.priority = priority;
        this.formationMode = formationMode;
        this.formationType = formationType;
    }

    public CommandStaffMovePacket(class_2540 buf) {
        this.staffUUID = buf.method_10790();
        this.targetPos = buf.method_10811();
        this.priority = buf.readInt();
        this.formationMode = buf.readBoolean();
        this.formationType = buf.method_19772();
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.staffUUID);
        buf.method_10807(this.targetPos);
        buf.writeInt(this.priority);
        buf.writeBoolean(this.formationMode);
        buf.method_10814(this.formationType);
    }

    public static CommandStaffMovePacket decode(class_2540 buf) {
        return new CommandStaffMovePacket(buf);
    }

    public static void handle(class_3222 player, CommandStaffMovePacket packet) {
        class_3218 world = (class_3218)((EntityAccessor)player).getLevel();
        class_1799 itemStack = CommandStaffMovePacket.findCommandStaffItem(player, packet.staffUUID);
        PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
        if (!itemStack.method_7960()) {
            class_2487 nbt = itemStack.method_7948();
            if (packet.priority == 1) {
                nbt.method_10551("AttackTargetEntity");
                nbt.method_10551("AttackMoveBlockPos");
                posTag = new class_2487();
                posTag.method_10569("X", packet.targetPos.method_10263());
                posTag.method_10569("Y", packet.targetPos.method_10264());
                posTag.method_10569("Z", packet.targetPos.method_10260());
                nbt.method_10566("TargetBlockPos", (class_2520)posTag);
            } else if (packet.priority == 3) {
                nbt.method_10551("TargetBlockPos");
                nbt.method_10551("AttackTargetEntity");
                posTag = new class_2487();
                posTag.method_10569("X", packet.targetPos.method_10263());
                posTag.method_10569("Y", packet.targetPos.method_10264());
                posTag.method_10569("Z", packet.targetPos.method_10260());
                nbt.method_10566("AttackMoveBlockPos", (class_2520)posTag);
            }
            itemStack.method_7980(nbt);
            if (nbt.method_10573("TeamEntityUUIDs", 9)) {
                class_2499 uuidList = nbt.method_10554("TeamEntityUUIDs", 8);
                ArrayList<BaseCombatEntity> teamEntities = new ArrayList<BaseCombatEntity>();
                for (int i = 0; i < uuidList.size(); ++i) {
                    String uuidString = uuidList.method_10608(i);
                    try {
                        UUID entityUUID = UUID.fromString(uuidString);
                        class_1297 entity = world.method_14190(entityUUID);
                        if (!(entity instanceof BaseCombatEntity)) continue;
                        BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                        teamEntities.add(combatEntity);
                        continue;
                    }
                    catch (Exception entityUUID) {
                        // empty catch block
                    }
                }
                if (!teamEntities.isEmpty()) {
                    registry.clearTasksForEntities(teamEntities);
                    if (packet.formationMode) {
                        FormationManager.commandStaffFormMove(packet.targetPos, packet.priority, teamEntities, packet.formationType);
                    } else {
                        UUID formationUUID = UUID.randomUUID();
                        for (BaseCombatEntity combatEntity : teamEntities) {
                            combatEntity.setHywTarget(null);
                            double homeReturnRadius = Double.max(0.5 * (double)teamEntities.size(), combatEntity.getDefaultHomeReturnRadius());
                            combatEntity.setHomeReturnRadius(homeReturnRadius);
                            MoveToBlockGoal moveGoal = new MoveToBlockGoal(combatEntity, 1.0, formationUUID);
                            moveGoal.setTargetPos(packet.targetPos);
                            combatEntity.clearCommandedGoals();
                            combatEntity.addCustomGoal(packet.priority, moveGoal);
                        }
                    }
                }
            }
        }
    }

    private static class_1799 findCommandStaffItem(class_3222 player, UUID staffUUID) {
        class_2487 tag;
        class_1799 mainHandItem = player.method_6047();
        if (!mainHandItem.method_7960() && mainHandItem.method_7909() instanceof CommandStaffItem && (tag = mainHandItem.method_7969()) != null && tag.method_25928("ItemUUID") && tag.method_25926("ItemUUID").equals(staffUUID)) {
            return mainHandItem;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_2487 tag2;
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !(stack.method_7909() instanceof CommandStaffItem) || (tag2 = stack.method_7969()) == null || !tag2.method_25928("ItemUUID") || !tag2.method_25926("ItemUUID").equals(staffUUID)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }
}

