/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.network.packets.RelationRequestPacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class RelationUpdatePacket {
    public static final class_2960 RELATION_UPDATE_PACKET_ID = new class_2960("hundred_years_war", "relation_update_packet");
    private final Map<UUID, RelationSystem.RelationType> relationUpdates = new HashMap<UUID, RelationSystem.RelationType>();

    public void addRelationUpdate(UUID targetUUID, RelationSystem.RelationType relationType) {
        this.relationUpdates.put(targetUUID, relationType);
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.relationUpdates.size());
        for (Map.Entry<UUID, RelationSystem.RelationType> entry : this.relationUpdates.entrySet()) {
            buf.method_10797(entry.getKey());
            buf.writeInt(entry.getValue().ordinal());
        }
    }

    public static RelationUpdatePacket decode(class_2540 buf) {
        RelationUpdatePacket packet = new RelationUpdatePacket();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            UUID targetUUID = buf.method_10790();
            RelationSystem.RelationType relationType = RelationSystem.RelationType.values()[buf.readInt()];
            packet.addRelationUpdate(targetUUID, relationType);
        }
        return packet;
    }

    public static void handleUpdate(class_3222 player, RelationUpdatePacket packet) {
        UUID playerUUID = player.method_5667();
        for (Map.Entry<UUID, RelationSystem.RelationType> entry : packet.relationUpdates.entrySet()) {
            UUID targetUUID = entry.getKey();
            RelationSystem.RelationType relationType = entry.getValue();
            RelationSystem.setRelation(playerUUID, targetUUID, relationType);
            TeamRelationData targetTeamData = RelationSystem.getTeamRelationData(targetUUID);
            if (targetTeamData == null) continue;
            Set<UUID> teamMembers = targetTeamData.getAllMembers().keySet();
            for (UUID memberUUID : teamMembers) {
                RelationSystem.setRelation(playerUUID, memberUUID, relationType);
            }
        }
        RelationRequestPacket.handle(player);
    }
}

