/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class TeamListResponsePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_list_response");
    private final Map<UUID, TeamInfo> teams = new HashMap<UUID, TeamInfo>();

    public TeamListResponsePacket() {
    }

    public TeamListResponsePacket(class_2540 buf) {
        int teamCount = buf.readInt();
        for (int i = 0; i < teamCount; ++i) {
            UUID teamUUID = buf.method_10790();
            String teamName = buf.method_19772();
            int memberCount = buf.readInt();
            String ownerName = buf.method_19772();
            RelationSystem.RelationType relation = RelationSystem.RelationType.valueOf(buf.method_19772());
            this.teams.put(teamUUID, new TeamInfo(teamName, memberCount, ownerName, relation));
        }
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.teams.size());
        for (Map.Entry<UUID, TeamInfo> entry : this.teams.entrySet()) {
            buf.method_10797(entry.getKey());
            buf.method_10814(entry.getValue().getTeamName());
            buf.writeInt(entry.getValue().getMemberCount());
            buf.method_10814(entry.getValue().getOwnerName());
            buf.method_10814(entry.getValue().getRelation().name());
        }
    }

    public static TeamListResponsePacket decode(class_2540 buf) {
        return new TeamListResponsePacket(buf);
    }

    public void addTeam(UUID teamUUID, String teamName, int memberCount, String ownerName, RelationSystem.RelationType relation) {
        this.teams.put(teamUUID, new TeamInfo(teamName, memberCount, ownerName, relation));
    }

    public Map<UUID, TeamInfo> getTeams() {
        return this.teams;
    }

    public static class TeamInfo {
        private final String teamName;
        private final int memberCount;
        private final String ownerName;
        private final RelationSystem.RelationType relation;

        public TeamInfo(String teamName, int memberCount, String ownerName, RelationSystem.RelationType relation) {
            this.teamName = teamName;
            this.memberCount = memberCount;
            this.ownerName = ownerName;
            this.relation = relation;
        }

        public String getTeamName() {
            return this.teamName;
        }

        public int getMemberCount() {
            return this.memberCount;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public RelationSystem.RelationType getRelation() {
            return this.relation;
        }
    }
}

