/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.selection;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class SelectionSystem {
    private static final Map<class_3222, Selection> selections = new ConcurrentHashMap<class_3222, Selection>();
    private static final Map<UUID, List<Squad>> squads = new ConcurrentHashMap<UUID, List<Squad>>();

    public static void saveSquads(Path savePath) throws IOException {
        class_2487 nbt = new class_2487();
        class_2499 squadList = new class_2499();
        for (Map.Entry<UUID, List<Squad>> entry : squads.entrySet()) {
            UUID playerUUID = entry.getKey();
            List<Squad> playerSquads = entry.getValue();
            class_2487 playerData = new class_2487();
            playerData.method_25927("PlayerUUID", playerUUID);
            class_2499 squadsTag = new class_2499();
            for (Squad squad : playerSquads) {
                if (squad == null) continue;
                class_2487 squadTag = new class_2487();
                class_2499 entityUUIDsTag = new class_2499();
                for (UUID entityUUID : squad.getEntityUUIDs()) {
                    entityUUIDsTag.add((Object)class_2519.method_23256((String)entityUUID.toString()));
                }
                squadTag.method_10566("EntityUUIDs", (class_2520)entityUUIDsTag);
                squadsTag.add((Object)squadTag);
            }
            playerData.method_10566("Squads", (class_2520)squadsTag);
            squadList.add((Object)playerData);
        }
        nbt.method_10566("Squads", (class_2520)squadList);
        class_2507.method_30614((class_2487)nbt, (File)savePath.toFile());
    }

    public static void loadSquads(Path savePath) throws IOException {
        if (Files.exists(savePath, new LinkOption[0])) {
            try {
                class_2487 nbt = class_2507.method_30613((File)savePath.toFile());
                class_2499 squadList = nbt.method_10554("Squads", 10);
                squads.clear();
                for (int i = 0; i < squadList.size(); ++i) {
                    class_2487 playerData = squadList.method_10602(i);
                    UUID playerUUID = playerData.method_25926("PlayerUUID");
                    class_2499 squadsTag = playerData.method_10554("Squads", 10);
                    ArrayList<Squad> playerSquads = new ArrayList<Squad>();
                    for (int j = 0; j < squadsTag.size(); ++j) {
                        class_2487 squadTag = squadsTag.method_10602(j);
                        class_2499 entityUUIDsTag = squadTag.method_10554("EntityUUIDs", 8);
                        ArrayList<UUID> entityUUIDs = new ArrayList<UUID>();
                        for (int k = 0; k < entityUUIDsTag.size(); ++k) {
                            entityUUIDs.add(UUID.fromString(entityUUIDsTag.method_10608(k)));
                        }
                        playerSquads.add(new Squad(entityUUIDs));
                    }
                    squads.put(playerUUID, playerSquads);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Selection getSelection(class_3222 player) {
        return selections.computeIfAbsent(player, k -> new Selection(new ArrayList<BaseCombatEntity>()));
    }

    public static Map<class_3222, Selection> getSelections() {
        return selections;
    }

    public static Map<UUID, List<Squad>> getSquads() {
        return squads;
    }

    public static void addEntitiesToSelection(class_3222 player, List<UUID> entityUUIDs) {
        Selection selection = selections.getOrDefault(player, new Selection(new ArrayList<BaseCombatEntity>()));
        selection.clear();
        for (UUID uuid : entityUUIDs) {
            class_1297 entity = SelectionSystem.getEntityByUUIDWithinRadius(player, uuid, 200);
            if (!(entity instanceof BaseCombatEntity) || !ServerRelationHelper.hasControlOver((class_1657)player, entity) && !player.method_7337()) continue;
            selection.addEntity((BaseCombatEntity)entity);
        }
        selections.put(player, selection);
    }

    public static class_1297 getEntityByUUIDWithinRadius(class_3222 player, UUID uuid, int radius) {
        class_243 playerPos = player.method_19538();
        class_238 selectionBox = new class_238(playerPos.field_1352 - (double)radius, playerPos.field_1351 - (double)radius, playerPos.field_1350 - (double)radius, playerPos.field_1352 + (double)radius, playerPos.field_1351 + (double)radius, playerPos.field_1350 + (double)radius);
        return ((EntityAccessor)player).getLevel().method_8390(class_1297.class, selectionBox, entity -> entity.method_5667().equals(uuid)).stream().findFirst().orElse(null);
    }

    public static void clearEntityFromAllSelections(BaseCombatEntity entity) {
        for (Selection selection : selections.values()) {
            selection.removeEntity(entity);
        }
    }

    public static class Squad {
        private List<UUID> entityUUIDs;

        public Squad(List<UUID> entityUUIDs) {
            this.entityUUIDs = entityUUIDs;
        }

        public List<UUID> getEntityUUIDs() {
            return this.entityUUIDs;
        }

        public void setEntityUUIDs(List<UUID> entityUUIDs) {
            this.entityUUIDs = entityUUIDs;
        }
    }

    public static class Selection {
        private List<BaseCombatEntity> entities;

        public Selection(List<BaseCombatEntity> entities) {
            this.entities = new ArrayList<BaseCombatEntity>(entities);
        }

        public List<BaseCombatEntity> getEntities() {
            return new ArrayList<BaseCombatEntity>(this.entities);
        }

        public void refreshEntities() {
            this.entities = this.entities.stream().filter(class_1309::method_5805).collect(Collectors.toList());
        }

        public void addEntity(BaseCombatEntity entity) {
            if (entity != null && !this.entities.contains(entity)) {
                this.entities.add(entity);
            }
        }

        public void clear() {
            this.entities.clear();
        }

        public List<UUID> getEntityUUIDs() {
            return this.entities.stream().map(class_1297::method_5667).collect(Collectors.toList());
        }

        public void removeEntity(BaseCombatEntity entity) {
            this.entities.remove(entity);
        }
    }
}

