/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3218;
import ydmsama.hundred_years_war.main.blocks.BaseStructureCoreBlockEntity;
import ydmsama.hundred_years_war.main.structure.ConstructionTask;

public class ConstructionManager {
    private static final List<ConstructionTask> tasks = Collections.synchronizedList(new ArrayList());
    private static final List<BaseStructureCoreBlockEntity> blocksToRestore = Collections.synchronizedList(new ArrayList());

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3218 level : server.method_3738()) {
                ConstructionManager.tick(level);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            tasks.clear();
            blocksToRestore.clear();
        });
    }

    public static void addTask(ConstructionTask task) {
        tasks.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(class_3218 serverLevel) {
        List<Object> list = tasks;
        synchronized (list) {
            Iterator<ConstructionTask> iterator = tasks.iterator();
            while (iterator.hasNext()) {
                ConstructionTask task = iterator.next();
                task.tick();
                if (!task.isComplete()) continue;
                iterator.remove();
            }
        }
        list = blocksToRestore;
        synchronized (list) {
            Iterator<BaseStructureCoreBlockEntity> blockIterator = blocksToRestore.iterator();
            while (blockIterator.hasNext()) {
                BaseStructureCoreBlockEntity blockEntity = blockIterator.next();
                blockEntity.restoreTask(serverLevel);
                blockIterator.remove();
            }
        }
    }

    public static void addBlockEntityToRestore(BaseStructureCoreBlockEntity blockEntity) {
        blocksToRestore.add(blockEntity);
    }
}

