/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.main.entity.goals.PrioritizedGoal;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class PuppetStateHandler {
    private static final Map<UUID, PlayerPuppetState> savedPlayerStates = new ConcurrentHashMap<UUID, PlayerPuppetState>();
    private static final Map<UUID, PersistentPlayerState> persistentPlayerStates = new ConcurrentHashMap<UUID, PersistentPlayerState>();

    public static void savePuppetState(class_3222 player, IPuppet puppet) {
        if (puppet == null) {
            return;
        }
        class_1297 puppetEntity = (class_1297)puppet;
        UUID playerUUID = player.method_5667();
        UUID puppetUUID = puppetEntity.method_5667();
        boolean wasSelected = false;
        SelectionSystem.Selection currentSelection = SelectionSystem.getSelection(player);
        if (currentSelection != null) {
            List<BaseCombatEntity> selectedEntities = currentSelection.getEntities();
            wasSelected = selectedEntities.stream().anyMatch(entity -> entity.method_5667().equals(puppetUUID));
        }
        LinkedList<PrioritizedGoal> goalQueue = new LinkedList<PrioritizedGoal>();
        if (puppetEntity instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)puppetEntity;
            goalQueue.addAll(baseCombatEntity.getGoalQueue());
        }
        class_1309 followTarget = null;
        ArrayList<class_2338> patrolPoints = new ArrayList<class_2338>();
        if (puppetEntity instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)puppetEntity;
            followTarget = baseCombatEntity.getFollowTarget();
            patrolPoints = new ArrayList<class_2338>(baseCombatEntity.getPatrolPoints());
        }
        if (wasSelected || !goalQueue.isEmpty() || followTarget != null || !patrolPoints.isEmpty()) {
            PlayerPuppetState state = new PlayerPuppetState(wasSelected, goalQueue, followTarget, patrolPoints);
            savedPlayerStates.put(playerUUID, state);
        }
    }

    public static void restorePuppetState(class_3222 player, IPuppet newPuppet) {
        PersistentPlayerState persistentState;
        if (newPuppet == null) {
            return;
        }
        UUID playerUUID = player.method_5667();
        class_1297 newPuppetEntity = (class_1297)newPuppet;
        PlayerPuppetState savedState = savedPlayerStates.remove(playerUUID);
        if (savedState != null) {
            SelectionSystem.Selection currentSelection;
            BaseCombatEntity baseCombatEntity;
            if (newPuppetEntity instanceof BaseCombatEntity) {
                baseCombatEntity = (BaseCombatEntity)newPuppetEntity;
                if (savedState.followTarget != null && !savedState.followTarget.method_31481()) {
                    baseCombatEntity.setFollowTarget(savedState.followTarget);
                }
                if (!savedState.patrolPoints.isEmpty()) {
                    baseCombatEntity.clearPatrolPoints();
                    List<class_2338> patrolPoints = baseCombatEntity.getPatrolPoints();
                    for (class_2338 pos : savedState.patrolPoints) {
                        patrolPoints.add(pos);
                    }
                }
            }
            if (savedState.wasSelected && (currentSelection = SelectionSystem.getSelection(player)) != null && newPuppetEntity instanceof BaseCombatEntity) {
                BaseCombatEntity baseCombatEntity2 = (BaseCombatEntity)newPuppetEntity;
                currentSelection.addEntity(baseCombatEntity2);
            }
            if (!savedState.goalQueue.isEmpty() && newPuppetEntity instanceof BaseCombatEntity) {
                baseCombatEntity = (BaseCombatEntity)newPuppetEntity;
                PuppetStateHandler.restoreGoalQueue(baseCombatEntity, savedState.goalQueue);
            }
        }
        if ((persistentState = persistentPlayerStates.get(playerUUID)) != null) {
            PuppetStateHandler.restoreSquadState(player, newPuppetEntity, persistentState.squadIndices);
        }
    }

    private static void restoreSquadState(class_3222 player, class_1297 newPuppetEntity, Set<Integer> squadIndices) {
        if (squadIndices.isEmpty() || !(newPuppetEntity instanceof BaseCombatEntity)) {
            return;
        }
        UUID playerUUID = player.method_5667();
        List playerSquads = SelectionSystem.getSquads().computeIfAbsent(playerUUID, k -> new ArrayList());
        for (Integer squadIndex : squadIndices) {
            ArrayList<Object> entityUUIDs;
            while (playerSquads.size() <= squadIndex) {
                playerSquads.add(null);
            }
            SelectionSystem.Squad squad = (SelectionSystem.Squad)playerSquads.get(squadIndex);
            if (squad == null) {
                entityUUIDs = new ArrayList<UUID>();
                entityUUIDs.add(newPuppetEntity.method_5667());
                squad = new SelectionSystem.Squad(entityUUIDs);
                playerSquads.set(squadIndex, squad);
                continue;
            }
            entityUUIDs = new ArrayList<UUID>(squad.getEntityUUIDs());
            if (entityUUIDs.contains(newPuppetEntity.method_5667())) continue;
            entityUUIDs.add(newPuppetEntity.method_5667());
            SelectionSystem.Squad updatedSquad = new SelectionSystem.Squad(entityUUIDs);
            playerSquads.set(squadIndex, updatedSquad);
        }
        SelectionSystem.getSquads().put(playerUUID, playerSquads);
    }

    private static void restoreGoalQueue(BaseCombatEntity baseCombatEntity, Queue<PrioritizedGoal> savedGoalQueue) {
        if (savedGoalQueue == null || savedGoalQueue.isEmpty()) {
            return;
        }
        baseCombatEntity.clearGoalQueue();
        LinkedList<PrioritizedGoal> updatedGoalQueue = new LinkedList<PrioritizedGoal>();
        for (PrioritizedGoal prioritizedGoal : savedGoalQueue) {
            class_1352 class_13522 = prioritizedGoal.goal;
            if (class_13522 instanceof CommandedGoal) {
                CommandedGoal commandedGoal = (CommandedGoal)class_13522;
                commandedGoal.updateEntityReference(baseCombatEntity);
            }
            updatedGoalQueue.add(prioritizedGoal);
        }
        baseCombatEntity.setGoalQueue(updatedGoalQueue);
        baseCombatEntity.executeNextGoal();
    }

    public static void clearPlayerState(UUID playerUUID) {
        savedPlayerStates.remove(playerUUID);
    }

    public static void clearAllTemporaryStates() {
        savedPlayerStates.clear();
    }

    public static void clearAllStates() {
        savedPlayerStates.clear();
        persistentPlayerStates.clear();
    }

    public static boolean hasSavedState(UUID playerUUID) {
        return savedPlayerStates.containsKey(playerUUID) || persistentPlayerStates.containsKey(playerUUID);
    }

    public static void savePersistentStates(Path savePath) throws IOException {
        class_2487 nbt = new class_2487();
        class_2499 stateList = new class_2499();
        for (Map.Entry<UUID, PersistentPlayerState> entry : persistentPlayerStates.entrySet()) {
            UUID playerUUID = entry.getKey();
            PersistentPlayerState state = entry.getValue();
            class_2487 playerData = new class_2487();
            playerData.method_25927("PlayerUUID", playerUUID);
            class_2499 squadIndicesTag = new class_2499();
            for (Integer squadIndex : state.squadIndices) {
                squadIndicesTag.add((Object)class_2519.method_23256((String)squadIndex.toString()));
            }
            playerData.method_10566("SquadIndices", (class_2520)squadIndicesTag);
            stateList.add((Object)playerData);
        }
        nbt.method_10566("PlayerPuppetStates", (class_2520)stateList);
        class_2507.method_30614((class_2487)nbt, (File)savePath.toFile());
    }

    public static void loadPersistentStates(Path savePath) throws IOException {
        if (!Files.exists(savePath, new LinkOption[0])) {
            return;
        }
        try {
            class_2487 nbt = class_2507.method_30613((File)savePath.toFile());
            class_2499 stateList = nbt.method_10554("PlayerPuppetStates", 10);
            persistentPlayerStates.clear();
            for (int i = 0; i < stateList.size(); ++i) {
                class_2487 playerData = stateList.method_10602(i);
                UUID playerUUID = playerData.method_25926("PlayerUUID");
                HashSet<Integer> squadIndices = new HashSet<Integer>();
                class_2499 squadIndicesTag = playerData.method_10554("SquadIndices", 8);
                for (int j = 0; j < squadIndicesTag.size(); ++j) {
                    squadIndices.add(Integer.parseInt(squadIndicesTag.method_10608(j)));
                }
                PersistentPlayerState state = new PersistentPlayerState(squadIndices);
                persistentPlayerStates.put(playerUUID, state);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updatePuppetSquadState(UUID playerUUID, int squadIndex, List<UUID> entityUUIDs) {
        PersistentPlayerState currentState = persistentPlayerStates.get(playerUUID);
        HashSet<Integer> squadIndices = currentState != null ? new HashSet<Integer>(currentState.squadIndices) : new HashSet();
        squadIndices.add(squadIndex);
        PersistentPlayerState newState = new PersistentPlayerState(squadIndices);
        persistentPlayerStates.put(playerUUID, newState);
    }

    public static void removePuppetFromSquad(UUID playerUUID, int squadIndex) {
        PersistentPlayerState currentState = persistentPlayerStates.get(playerUUID);
        if (currentState != null) {
            HashSet<Integer> squadIndices = new HashSet<Integer>(currentState.squadIndices);
            squadIndices.remove(squadIndex);
            if (squadIndices.isEmpty()) {
                persistentPlayerStates.remove(playerUUID);
            } else {
                PersistentPlayerState newState = new PersistentPlayerState(squadIndices);
                persistentPlayerStates.put(playerUUID, newState);
            }
        }
    }

    public static void clearPuppetSquadState(UUID playerUUID, int squadIndex) {
        PuppetStateHandler.removePuppetFromSquad(playerUUID, squadIndex);
    }

    public static boolean isPuppetInSquad(UUID playerUUID, int squadIndex) {
        PersistentPlayerState state = persistentPlayerStates.get(playerUUID);
        return state != null && state.squadIndices.contains(squadIndex);
    }

    private static class PlayerPuppetState {
        public final boolean wasSelected;
        public final Queue<PrioritizedGoal> goalQueue;
        public final class_1309 followTarget;
        public final List<class_2338> patrolPoints;

        public PlayerPuppetState(boolean wasSelected, Queue<PrioritizedGoal> goalQueue, class_1309 followTarget, List<class_2338> patrolPoints) {
            this.wasSelected = wasSelected;
            this.goalQueue = new LinkedList<PrioritizedGoal>(goalQueue);
            this.followTarget = followTarget;
            this.patrolPoints = new ArrayList<class_2338>(patrolPoints);
        }
    }

    private static class PersistentPlayerState {
        public final Set<Integer> squadIndices;

        public PersistentPlayerState(Set<Integer> squadIndices) {
            this.squadIndices = new HashSet<Integer>(squadIndices);
        }
    }
}

