/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import ydmsama.hundred_years_war.main.network.packets.RelationSyncPacket;
import ydmsama.hundred_years_war.main.utils.PlayerRelationData;
import ydmsama.hundred_years_war.main.utils.RelationData;
import ydmsama.hundred_years_war.main.utils.ServerManager;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class RelationSystem {
    private static Map<UUID, Map<UUID, RelationType>> Relations = new HashMap<UUID, Map<UUID, RelationType>>();
    private static Map<UUID, RelationData> RelationDataMap = new HashMap<UUID, RelationData>();
    private static boolean testDataInitialized = false;
    private static boolean savedTestDataFlag = false;
    private static final Map<UUID, TeamRelationData> TeamDataMap = new HashMap<UUID, TeamRelationData>();
    private static final Map<UUID, Map<UUID, DamageRecord>> damageRecords = new HashMap<UUID, Map<UUID, DamageRecord>>();
    private static final Map<UUID, Map<UUID, Long>> hostileToNeutralSwitchTime = new HashMap<UUID, Map<UUID, Long>>();
    private static final long RELATION_IMMUNITY_TIME = 30000L;

    public static int recordDamage(UUID attackerUuid, UUID victimUuid) {
        DamageRecord record;
        Long switchTime;
        Map<UUID, Long> switchTimeMap = hostileToNeutralSwitchTime.get(victimUuid);
        if (switchTimeMap != null && (switchTime = switchTimeMap.get(attackerUuid)) != null) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - switchTime < 30000L) {
                System.out.println(victimUuid + " \u5bf9 " + attackerUuid + " \u5904\u4e8e\u5173\u7cfb\u8c41\u514d\u671f\u5185\uff0c\u5ffd\u7565\u4f24\u5bb3\u8bb0\u5f55");
                return 0;
            }
            switchTimeMap.remove(attackerUuid);
        }
        damageRecords.computeIfAbsent(victimUuid, k -> new HashMap());
        Map<UUID, DamageRecord> victimRecords = damageRecords.get(victimUuid);
        if (victimRecords.containsKey(attackerUuid)) {
            record = victimRecords.get(attackerUuid);
            record.recordDamage();
        } else {
            record = new DamageRecord();
            victimRecords.put(attackerUuid, record);
        }
        return record.getDamageCount();
    }

    public static void cleanupExpiredDamageRecords() {
        long currentTime = System.currentTimeMillis();
        ArrayList<UUID> emptyRecords = new ArrayList<UUID>();
        for (Map.Entry<UUID, Map<UUID, DamageRecord>> entry : damageRecords.entrySet()) {
            UUID victimUuid = entry.getKey();
            Map<UUID, DamageRecord> victimRecords = entry.getValue();
            Iterator<Map.Entry<UUID, DamageRecord>> iterator = victimRecords.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, DamageRecord> recordEntry = iterator.next();
                if (!recordEntry.getValue().isExpired()) continue;
                iterator.remove();
            }
            if (!victimRecords.isEmpty()) continue;
            emptyRecords.add(victimUuid);
        }
        for (UUID victimUuid : emptyRecords) {
            damageRecords.remove(victimUuid);
        }
        RelationSystem.cleanupExpiredImmunityRecords();
    }

    public static void cleanupExpiredImmunityRecords() {
        long currentTime = System.currentTimeMillis();
        ArrayList<UUID> emptyMaps = new ArrayList<UUID>();
        for (Map.Entry<UUID, Map<UUID, Long>> entry : hostileToNeutralSwitchTime.entrySet()) {
            UUID uuid1 = entry.getKey();
            Map<UUID, Long> switchTimeMap = entry.getValue();
            Iterator<Map.Entry<UUID, Long>> iterator = switchTimeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, Long> timeEntry = iterator.next();
                UUID uuid2 = timeEntry.getKey();
                long switchTime = timeEntry.getValue();
                if (currentTime - switchTime <= 30000L) continue;
                iterator.remove();
                System.out.println(uuid1 + " \u5bf9 " + uuid2 + " \u7684\u5173\u7cfb\u8c41\u514d\u671f\u5df2\u7ed3\u675f");
            }
            if (!switchTimeMap.isEmpty()) continue;
            emptyMaps.add(uuid1);
        }
        for (UUID uuid : emptyMaps) {
            hostileToNeutralSwitchTime.remove(uuid);
        }
    }

    public static DamageRecord getDamageRecord(UUID attackerUuid, UUID victimUuid) {
        Map<UUID, DamageRecord> victimRecords = damageRecords.get(victimUuid);
        if (victimRecords != null) {
            return victimRecords.get(attackerUuid);
        }
        return null;
    }

    public static void removeDamageRecord(UUID attackerUuid, UUID victimUuid) {
        Map<UUID, DamageRecord> victimRecords = damageRecords.get(victimUuid);
        if (victimRecords != null) {
            victimRecords.remove(attackerUuid);
        }
    }

    public static TeamRelationData createTeam(String teamName, UUID ownerUuid) {
        UUID teamUuid = UUID.randomUUID();
        TeamRelationData teamData = new TeamRelationData(teamUuid, teamName);
        teamData.addMember(ownerUuid, TeamRelationData.MemberType.OWNER);
        RelationDataMap.put(teamUuid, teamData);
        TeamDataMap.put(teamUuid, teamData);
        RelationSystem.setRelation(ownerUuid, teamUuid, RelationType.FRIENDLY);
        return teamData;
    }

    public static boolean joinTeam(UUID playerUuid, UUID teamUuid, TeamRelationData.MemberType memberType) {
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUuid);
        if (teamData == null) {
            return false;
        }
        teamData.addMember(playerUuid, memberType);
        RelationSystem.setRelation(playerUuid, teamUuid, RelationType.FRIENDLY);
        for (UUID memberUuid : teamData.getAllMembers().keySet()) {
            if (memberUuid.equals(playerUuid)) continue;
            RelationSystem.setRelation(playerUuid, memberUuid, RelationType.FRIENDLY);
            RelationSystem.setRelation(memberUuid, playerUuid, RelationType.FRIENDLY);
        }
        Map teamRelations = Relations.getOrDefault(teamUuid, new HashMap());
        for (Map.Entry relation : teamRelations.entrySet()) {
            UUID targetUuid = (UUID)relation.getKey();
            RelationType relationType = (RelationType)((Object)relation.getValue());
            if (targetUuid.equals(teamUuid) || teamData.isMember(targetUuid)) continue;
            RelationSystem.setRelation(playerUuid, targetUuid, relationType);
            TeamRelationData targetTeamData = RelationSystem.getTeamRelationData(targetUuid);
            if (targetTeamData == null) continue;
            for (UUID targetTeamMemberUuid : targetTeamData.getAllMembers().keySet()) {
                RelationSystem.setRelation(playerUuid, targetTeamMemberUuid, relationType);
            }
        }
        return true;
    }

    public static boolean leaveTeam(UUID playerUuid, UUID teamUuid) {
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUuid);
        if (teamData == null) {
            return false;
        }
        if (!teamData.isMember(playerUuid)) {
            return false;
        }
        TeamRelationData.MemberType memberType = teamData.getMemberType(playerUuid);
        if (memberType == TeamRelationData.MemberType.OWNER) {
            int memberCount = teamData.getAllMembers().size();
            if (memberCount == 1) {
                return RelationSystem.disbandTeam(teamUuid, playerUuid);
            }
            List<UUID> admins = teamData.getMembersByType(TeamRelationData.MemberType.ADMIN);
            admins.remove(playerUuid);
            UUID newOwnerUuid = null;
            if (!admins.isEmpty()) {
                newOwnerUuid = admins.get(new Random().nextInt(admins.size()));
            } else {
                List<UUID> members = teamData.getMembersByType(TeamRelationData.MemberType.MEMBER);
                if (!members.isEmpty()) {
                    newOwnerUuid = members.get(new Random().nextInt(members.size()));
                }
            }
            if (newOwnerUuid != null) {
                teamData.updateMemberType(newOwnerUuid, TeamRelationData.MemberType.OWNER);
                teamData.removeMember(playerUuid);
                RelationSystem.setRelation(playerUuid, teamUuid, RelationType.NEUTRAL);
                return true;
            }
        }
        teamData.removeMember(playerUuid);
        RelationSystem.setRelation(playerUuid, teamUuid, RelationType.NEUTRAL);
        return true;
    }

    public static boolean disbandTeam(UUID teamUuid, UUID requesterUuid) {
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUuid);
        if (teamData == null) {
            return false;
        }
        if (teamData.getMemberType(requesterUuid) != TeamRelationData.MemberType.OWNER) {
            return false;
        }
        ArrayList<UUID> allMembers = new ArrayList<UUID>(teamData.getAllMembers().keySet());
        for (UUID uUID : allMembers) {
            RelationSystem.setRelation(uUID, teamUuid, RelationType.NEUTRAL);
        }
        RelationDataMap.remove(teamUuid);
        TeamDataMap.remove(teamUuid);
        Relations.remove(teamUuid);
        for (Map map : Relations.values()) {
            map.remove(teamUuid);
        }
        return true;
    }

    public static TeamRelationData getTeamRelationData(UUID teamUuid) {
        RelationData data = RelationDataMap.get(teamUuid);
        if (data instanceof TeamRelationData) {
            return (TeamRelationData)data;
        }
        return null;
    }

    public static TeamRelationData getOrCreateTeamRelationData(UUID teamUuid, String teamName) {
        RelationData data = RelationDataMap.get(teamUuid);
        if (data == null) {
            TeamRelationData teamData = new TeamRelationData(teamUuid, teamName);
            RelationDataMap.put(teamUuid, teamData);
            TeamDataMap.put(teamUuid, teamData);
            return teamData;
        }
        if (data instanceof TeamRelationData) {
            TeamRelationData teamData = (TeamRelationData)data;
            if (!teamData.getTeamName().equals(teamName)) {
                teamData.setTeamName(teamName);
                System.out.println("RelationSystem: \u66f4\u65b0\u56e2\u961f " + teamUuid + " \u7684\u540d\u79f0: " + teamName);
            }
            return teamData;
        }
        TeamRelationData teamData = new TeamRelationData(teamUuid, teamName);
        RelationDataMap.put(teamUuid, teamData);
        TeamDataMap.put(teamUuid, teamData);
        return teamData;
    }

    public static List<UUID> getPlayerTeams(UUID playerUuid) {
        ArrayList<UUID> teams = new ArrayList<UUID>();
        for (TeamRelationData teamData : TeamDataMap.values()) {
            if (!teamData.isMember(playerUuid)) continue;
            teams.add(teamData.getUUID());
        }
        return teams;
    }

    public static Map<UUID, TeamRelationData> getAllTeams() {
        return new HashMap<UUID, TeamRelationData>(TeamDataMap);
    }

    public static void initializeTestData() {
        int i;
        if (testDataInitialized) {
            return;
        }
        String[] testNames = new String[]{"AlphaKnight", "BetaArcher", "GammaWizard", "DeltaMiner", "EpsilonHealer", "ZetaTank", "EtaThief", "ThetaScout", "IotaBard", "KappaDruid"};
        UUID[] testUUIDs = new UUID[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            testUUIDs[i2] = UUID.randomUUID();
            RelationDataMap.put(testUUIDs[i2], new PlayerRelationData(testUUIDs[i2], testNames[i2]));
        }
        ArrayList<Integer> freeMembers = new ArrayList<Integer>();
        ArrayList<Integer> freeApplicants = new ArrayList<Integer>();
        for (int i3 = 0; i3 < 10; ++i3) {
            freeMembers.add(i3);
            freeApplicants.add(i3);
        }
        Collections.shuffle(freeMembers);
        Collections.shuffle(freeApplicants);
        Random random = new Random();
        String[] teamNames = new String[]{"Red Dragons", "Blue Eagles", "Green Wolves", "Yellow Tigers", "Purple Serpents"};
        UUID[] teamUUIDs = new UUID[5];
        for (int i4 = 0; i4 < 5; ++i4) {
            teamUUIDs[i4] = UUID.randomUUID();
            TeamRelationData team = new TeamRelationData(teamUUIDs[i4], teamNames[i4]);
            RelationDataMap.put(teamUUIDs[i4], team);
            TeamDataMap.put(teamUUIDs[i4], team);
            if (freeMembers.isEmpty()) break;
            int ownerIdx = (Integer)freeMembers.remove(0);
            team.addMember(testUUIDs[ownerIdx], TeamRelationData.MemberType.OWNER);
            int extraMembers = Math.min(random.nextInt(3), freeMembers.size());
            for (int j = 0; j < extraMembers; ++j) {
                int idx = (Integer)freeMembers.remove(0);
                team.addMember(testUUIDs[idx], random.nextBoolean() ? TeamRelationData.MemberType.ADMIN : TeamRelationData.MemberType.MEMBER);
            }
            int applicants = Math.min(random.nextInt(3), freeApplicants.size());
            for (int j = 0; j < applicants; ++j) {
                int idx = (Integer)freeApplicants.remove(0);
                team.addApplication(testUUIDs[idx]);
            }
        }
        for (UUID a : RelationDataMap.keySet()) {
            for (UUID b : RelationDataMap.keySet()) {
                RelationType rt;
                if (a.equals(b) || (rt = RelationType.values()[random.nextInt(3)]) == RelationType.NEUTRAL) continue;
                Relations.computeIfAbsent(a, k -> new HashMap()).put(b, rt);
            }
        }
        UUID playerTeamUUID = UUID.randomUUID();
        TeamRelationData playerTeam = new TeamRelationData(playerTeamUUID, "Player's Elite Squad");
        RelationDataMap.put(playerTeamUUID, playerTeam);
        TeamDataMap.put(playerTeamUUID, playerTeam);
        for (i = 0; i < 10; ++i) {
            UUID member = UUID.randomUUID();
            RelationDataMap.put(member, new PlayerRelationData(member, "Member" + (i + 1)));
            playerTeam.addMember(member, i < 7 ? TeamRelationData.MemberType.MEMBER : TeamRelationData.MemberType.ADMIN);
        }
        for (i = 0; i < 10; ++i) {
            UUID applicant = UUID.randomUUID();
            RelationDataMap.put(applicant, new PlayerRelationData(applicant, "Applicant" + (i + 1)));
            playerTeam.addApplication(applicant);
        }
        testDataInitialized = true;
        System.out.println("RelationSystem: \u5df2\u5b89\u5168\u521d\u59cb\u5316\u6d4b\u8bd5\u6570\u636e");
    }

    public static RelationData getRelationData(UUID uuid) {
        return RelationDataMap.get(uuid);
    }

    public static PlayerRelationData getOrCreatePlayerRelationData(UUID uuid, String playerName) {
        RelationData data = RelationDataMap.get(uuid);
        if (data == null) {
            PlayerRelationData playerData = new PlayerRelationData(uuid, playerName);
            RelationDataMap.put(uuid, playerData);
            return playerData;
        }
        if (data instanceof PlayerRelationData) {
            PlayerRelationData playerData = (PlayerRelationData)data;
            if (!playerData.getPlayerName().equals(playerName)) {
                playerData.setPlayerName(playerName);
                System.out.println("RelationSystem: \u66f4\u65b0\u73a9\u5bb6 " + uuid + " \u7684\u540d\u79f0: " + playerName);
            }
            return playerData;
        }
        PlayerRelationData playerData = new PlayerRelationData(uuid, playerName);
        RelationDataMap.put(uuid, playerData);
        return playerData;
    }

    public static RelationType getRelation(UUID uuid1, UUID uuid2) {
        if (uuid1.equals(uuid2)) {
            return RelationType.CONTROL;
        }
        Map<UUID, RelationType> relations = Relations.get(uuid1);
        if (relations != null && relations.containsKey(uuid2)) {
            return relations.get(uuid2);
        }
        return RelationType.NEUTRAL;
    }

    public static void setRelation(UUID uuid1, UUID uuid2, RelationType relation) {
        if (uuid1.equals(uuid2)) {
            return;
        }
        RelationSystem.ensureRelationDataExists(uuid1);
        RelationSystem.ensureRelationDataExists(uuid2);
        RelationType oldRelation = RelationSystem.getRelation(uuid1, uuid2);
        if (oldRelation == RelationType.HOSTILE && relation == RelationType.NEUTRAL) {
            hostileToNeutralSwitchTime.computeIfAbsent(uuid1, k -> new HashMap()).put(uuid2, System.currentTimeMillis());
            System.out.println(uuid1 + " \u5bf9 " + uuid2 + " \u7684\u5173\u7cfb\u4ece\u654c\u5bf9\u53d8\u4e3a\u4e2d\u7acb\uff0c\u8c41\u514d\u671f\u5f00\u59cb");
        }
        if (relation == RelationType.NEUTRAL) {
            Map<UUID, RelationType> relations = Relations.get(uuid1);
            if (relations != null) {
                relations.remove(uuid2);
                if (relations.isEmpty()) {
                    Relations.remove(uuid1);
                }
            }
        } else {
            Relations.computeIfAbsent(uuid1, k -> new HashMap()).put(uuid2, relation);
            if (relation == RelationType.HOSTILE) {
                Map<UUID, Long> reverseSwitchTimeMap;
                Relations.computeIfAbsent(uuid2, k -> new HashMap()).put(uuid1, RelationType.HOSTILE);
                Map<UUID, Long> switchTimeMap = hostileToNeutralSwitchTime.get(uuid1);
                if (switchTimeMap != null) {
                    switchTimeMap.remove(uuid2);
                }
                if ((reverseSwitchTimeMap = hostileToNeutralSwitchTime.get(uuid2)) != null) {
                    reverseSwitchTimeMap.remove(uuid1);
                }
            }
        }
        RelationSystem.syncRelationsToClient(uuid1);
        RelationSystem.syncRelationsToClient(uuid2);
    }

    private static void ensureRelationDataExists(UUID uuid) {
        if (!RelationDataMap.containsKey(uuid)) {
            RelationDataMap.put(uuid, new PlayerRelationData(uuid, "Unknown"));
        }
    }

    public static void saveRelations(Path savePath) throws IOException {
        RelationSystem.cleanupInvalidRelations();
        RelationSystem.cleanupExpiredDamageRecords();
        RelationSystem.cleanupExpiredImmunityRecords();
        class_2487 rootTag = new class_2487();
        class_2499 relationsList = new class_2499();
        class_2499 dataList = new class_2499();
        rootTag.method_10556("TestDataInitialized", testDataInitialized);
        for (Map.Entry<UUID, RelationData> entry : RelationDataMap.entrySet()) {
            class_2487 class_24872 = entry.getValue().saveToNbt();
            class_24872.method_10582("DataType", entry.getValue().getClass().getSimpleName());
            dataList.add((Object)class_24872);
        }
        for (Map.Entry<UUID, Object> entry : Relations.entrySet()) {
            UUID uUID = entry.getKey();
            Map relations = (Map)entry.getValue();
            for (Map.Entry entry2 : relations.entrySet()) {
                UUID uUID2 = (UUID)entry2.getKey();
                RelationType relation = (RelationType)((Object)entry2.getValue());
                if (relation == RelationType.NEUTRAL) continue;
                class_2487 relationTag = new class_2487();
                relationTag.method_10582("uuid1", uUID.toString());
                relationTag.method_10582("uuid2", uUID2.toString());
                relationTag.method_10582("Relation", relation.name());
                relationsList.add((Object)relationTag);
            }
        }
        rootTag.method_10566("Relations", (class_2520)relationsList);
        rootTag.method_10566("RelationData", (class_2520)dataList);
        class_2499 damageRecordsList = new class_2499();
        for (Map.Entry<UUID, Map<UUID, DamageRecord>> entry : damageRecords.entrySet()) {
            UUID victimUuid = entry.getKey();
            Map<UUID, DamageRecord> records = entry.getValue();
            for (Map.Entry<UUID, DamageRecord> entry3 : records.entrySet()) {
                UUID attackerUuid = entry3.getKey();
                DamageRecord record = entry3.getValue();
                if (record.isExpired()) continue;
                class_2487 recordTag = new class_2487();
                recordTag.method_10582("victimUuid", victimUuid.toString());
                recordTag.method_10582("attackerUuid", attackerUuid.toString());
                recordTag.method_10569("damageCount", record.getDamageCount());
                recordTag.method_10544("lastDamageTime", record.getLastDamageTime());
                damageRecordsList.add((Object)recordTag);
            }
        }
        rootTag.method_10566("DamageRecords", (class_2520)damageRecordsList);
        class_2499 class_24992 = new class_2499();
        for (Map.Entry<UUID, Map<UUID, Long>> entry : hostileToNeutralSwitchTime.entrySet()) {
            UUID uuid1 = entry.getKey();
            Map<UUID, Long> map = entry.getValue();
            for (Map.Entry<UUID, Long> timeEntry : map.entrySet()) {
                UUID uuid2 = timeEntry.getKey();
                long switchTime = timeEntry.getValue();
                if (System.currentTimeMillis() - switchTime > 30000L) continue;
                class_2487 immunityTag = new class_2487();
                immunityTag.method_10582("uuid1", uuid1.toString());
                immunityTag.method_10582("uuid2", uuid2.toString());
                immunityTag.method_10544("switchTime", switchTime);
                class_24992.add((Object)immunityTag);
            }
        }
        rootTag.method_10566("ImmunityRecords", (class_2520)class_24992);
        class_2507.method_30614((class_2487)rootTag, (File)savePath.toFile());
        System.out.println("RelationSystem: \u6210\u529f\u4fdd\u5b58 " + RelationDataMap.size() + " \u4e2a\u5bf9\u8c61\u7684\u5173\u7cfb\u6570\u636e");
    }

    public static void loadRelations(Path savePath) {
        Relations.clear();
        RelationDataMap.clear();
        TeamDataMap.clear();
        damageRecords.clear();
        hostileToNeutralSwitchTime.clear();
        testDataInitialized = false;
        savedTestDataFlag = false;
        if (Files.exists(savePath, new LinkOption[0])) {
            try {
                class_2487 rootTag = class_2507.method_30613((File)savePath.toFile());
                if (rootTag.method_10545("TestDataInitialized")) {
                    testDataInitialized = savedTestDataFlag = rootTag.method_10577("TestDataInitialized");
                }
                if (rootTag.method_10545("RelationData")) {
                    class_2499 dataList = rootTag.method_10554("RelationData", 10);
                    HashMap<UUID, PlayerRelationData> tempPlayerDataMap = new HashMap<UUID, PlayerRelationData>();
                    HashMap<UUID, TeamRelationData> tempTeamDataMap = new HashMap<UUID, TeamRelationData>();
                    for (int i = 0; i < dataList.size(); ++i) {
                        class_2487 dataTag = dataList.method_10602(i);
                        String dataType = dataTag.method_10558("DataType");
                        UUID uuid = UUID.fromString(dataTag.method_10558("UUID"));
                        if ("PlayerRelationData".equals(dataType)) {
                            String playerName = dataTag.method_10558("PlayerName");
                            if (!tempPlayerDataMap.containsKey(uuid)) {
                                PlayerRelationData playerData = new PlayerRelationData(uuid, playerName);
                                playerData.loadFromNbt(dataTag);
                                tempPlayerDataMap.put(uuid, playerData);
                                continue;
                            }
                            System.out.println("RelationSystem: \u68c0\u6d4b\u5230\u91cd\u590d\u7684\u73a9\u5bb6UUID: " + uuid + ", \u5df2\u5b58\u5728\u540d\u79f0: " + ((PlayerRelationData)tempPlayerDataMap.get(uuid)).getPlayerName() + ", \u5ffd\u7565\u540d\u79f0: " + playerName);
                            continue;
                        }
                        if (!"TeamRelationData".equals(dataType)) continue;
                        String teamName = dataTag.method_10558("TeamName");
                        if (!tempTeamDataMap.containsKey(uuid)) {
                            TeamRelationData teamData = new TeamRelationData(uuid, teamName);
                            teamData.loadFromNbt(dataTag);
                            tempTeamDataMap.put(uuid, teamData);
                            continue;
                        }
                        System.out.println("RelationSystem: \u68c0\u6d4b\u5230\u91cd\u590d\u7684\u56e2\u961fUUID: " + uuid + ", \u5df2\u5b58\u5728\u540d\u79f0: " + ((TeamRelationData)tempTeamDataMap.get(uuid)).getTeamName() + ", \u5ffd\u7565\u540d\u79f0: " + teamName);
                    }
                    for (PlayerRelationData playerData : tempPlayerDataMap.values()) {
                        RelationDataMap.put(playerData.getUUID(), playerData);
                    }
                    for (TeamRelationData teamData : tempTeamDataMap.values()) {
                        RelationDataMap.put(teamData.getUUID(), teamData);
                        TeamDataMap.put(teamData.getUUID(), teamData);
                    }
                }
                class_2499 relationsList = rootTag.method_10554("Relations", 10);
                for (int i = 0; i < relationsList.size(); ++i) {
                    class_2487 relationTag = relationsList.method_10602(i);
                    UUID uuid1 = UUID.fromString(relationTag.method_10558("uuid1"));
                    UUID uuid2 = UUID.fromString(relationTag.method_10558("uuid2"));
                    RelationType relation = RelationType.valueOf(relationTag.method_10558("Relation"));
                    RelationSystem.ensureRelationDataExists(uuid1);
                    RelationSystem.ensureRelationDataExists(uuid2);
                    if (relation == RelationType.NEUTRAL) continue;
                    Relations.computeIfAbsent(uuid1, k -> new HashMap()).put(uuid2, relation);
                }
                RelationSystem.cleanupInvalidRelations();
                if (rootTag.method_10545("DamageRecords")) {
                    class_2499 damageRecordsList = rootTag.method_10554("DamageRecords", 10);
                    for (int i = 0; i < damageRecordsList.size(); ++i) {
                        long lastDamageTime;
                        class_2487 recordTag = damageRecordsList.method_10602(i);
                        UUID victimUuid = UUID.fromString(recordTag.method_10558("victimUuid"));
                        UUID attackerUuid = UUID.fromString(recordTag.method_10558("attackerUuid"));
                        int damageCount = recordTag.method_10550("damageCount");
                        DamageRecord record = DamageRecord.fromNbt(damageCount, lastDamageTime = recordTag.method_10537("lastDamageTime"));
                        if (record.isExpired()) continue;
                        damageRecords.computeIfAbsent(victimUuid, k -> new HashMap()).put(attackerUuid, record);
                    }
                    System.out.println("RelationSystem: \u6210\u529f\u52a0\u8f7d\u4f24\u5bb3\u8bb0\u5f55\u6570\u636e");
                }
                if (rootTag.method_10545("ImmunityRecords")) {
                    class_2499 immunityRecordsList = rootTag.method_10554("ImmunityRecords", 10);
                    for (int i = 0; i < immunityRecordsList.size(); ++i) {
                        class_2487 immunityTag = immunityRecordsList.method_10602(i);
                        UUID uuid1 = UUID.fromString(immunityTag.method_10558("uuid1"));
                        UUID uuid2 = UUID.fromString(immunityTag.method_10558("uuid2"));
                        long switchTime = immunityTag.method_10537("switchTime");
                        if (System.currentTimeMillis() - switchTime > 30000L) continue;
                        hostileToNeutralSwitchTime.computeIfAbsent(uuid1, k -> new HashMap()).put(uuid2, switchTime);
                    }
                    System.out.println("RelationSystem: \u6210\u529f\u52a0\u8f7d\u8c41\u514d\u671f\u8bb0\u5f55\u6570\u636e");
                }
                System.out.println("RelationSystem: \u6210\u529f\u52a0\u8f7d " + RelationDataMap.size() + " \u4e2a\u5bf9\u8c61\u7684\u5173\u7cfb\u6570\u636e");
            }
            catch (IOException e) {
                System.err.println("RelationSystem: \u52a0\u8f7d\u5173\u7cfb\u6570\u636e\u5931\u8d25: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("RelationSystem: \u5173\u7cfb\u6570\u636e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u65b0\u7684\u5173\u7cfb\u6570\u636e");
        }
        if (!savedTestDataFlag) {
            savedTestDataFlag = true;
            testDataInitialized = true;
        }
    }

    private static void cleanupInvalidRelations() {
        ArrayList<UUID> allExistingUUIDs = new ArrayList<UUID>(RelationDataMap.keySet());
        for (UUID uuid : allExistingUUIDs) {
            Map<UUID, RelationType> relations = Relations.get(uuid);
            if (relations == null) continue;
            ArrayList<UUID> toRemove = new ArrayList<UUID>();
            for (UUID targetUUID : relations.keySet()) {
                if (RelationDataMap.containsKey(targetUUID)) continue;
                toRemove.add(targetUUID);
            }
            for (UUID invalidUUID : toRemove) {
                relations.remove(invalidUUID);
                System.out.println("RelationSystem: \u6e05\u7406\u65e0\u6548\u5173\u7cfb: " + uuid + " -> " + invalidUUID);
            }
        }
    }

    public static Map<UUID, RelationType> getAllRelations(UUID uuid) {
        Map<UUID, RelationType> relations = Relations.get(uuid);
        if (relations != null) {
            return new HashMap<UUID, RelationType>(relations);
        }
        return new HashMap<UUID, RelationType>();
    }

    public static Map<UUID, RelationType> getRelationsByType(UUID uuid, RelationType type) {
        HashMap<UUID, RelationType> result = new HashMap<UUID, RelationType>();
        Map<UUID, RelationType> relations = Relations.get(uuid);
        if (relations != null) {
            for (Map.Entry<UUID, RelationType> entry : relations.entrySet()) {
                if (entry.getValue() != type) continue;
                result.put(entry.getKey(), type);
            }
        }
        return result;
    }

    public static void setRelations(UUID uuid, Iterable<UUID> targets, RelationType relation) {
        for (UUID target : targets) {
            RelationSystem.setRelation(uuid, target, relation);
        }
    }

    public static boolean hasMutualRelation(UUID uuid1, UUID uuid2) {
        RelationType relation2;
        RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        return relation1 == (relation2 = RelationSystem.getRelation(uuid2, uuid1)) && relation1 != RelationType.NEUTRAL;
    }

    public static boolean hasMutualRelation(UUID uuid1, UUID uuid2, RelationType relation) {
        return RelationSystem.getRelation(uuid1, uuid2) == relation && RelationSystem.getRelation(uuid2, uuid1) == relation;
    }

    public static void syncRelationsToClient(UUID uuid) {
        class_3222 player;
        MinecraftServer server = ServerManager.getServer();
        if (server != null && (player = server.method_3760().method_14602(uuid)) != null) {
            RelationSyncPacket.sendToClient(player);
        }
    }

    public static PlayerRelationData addPlayerAndEnsureRelations(UUID uuid, String playerName) {
        PlayerRelationData data = RelationSystem.getOrCreatePlayerRelationData(uuid, playerName);
        RelationSystem.syncRelationsToClient(uuid);
        return data;
    }

    public static Map<UUID, RelationData> getAllRelationData() {
        return new HashMap<UUID, RelationData>(RelationDataMap);
    }

    public static UUID getPlayerTeamUUID(UUID playerUUID) {
        for (UUID teamUUID : RelationSystem.getAllTeams().keySet()) {
            TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
            if (teamData == null || !teamData.isMember(playerUUID)) continue;
            return teamUUID;
        }
        return null;
    }

    public static RelationType getPlayerRelationWithTeam(UUID playerUUID, UUID teamUUID) {
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData != null && teamData.isMember(playerUUID)) {
            return RelationType.FRIENDLY;
        }
        return RelationSystem.getRelation(playerUUID, teamUUID);
    }

    public static class DamageRecord {
        private int damageCount;
        private long lastDamageTime;
        private static final long EXPIRE_TIME = 30000L;

        public DamageRecord() {
            this.damageCount = 1;
            this.lastDamageTime = System.currentTimeMillis();
        }

        private DamageRecord(boolean forLoading) {
            if (forLoading) {
                this.damageCount = 0;
                this.lastDamageTime = 0L;
            } else {
                this.damageCount = 1;
                this.lastDamageTime = System.currentTimeMillis();
            }
        }

        public void recordDamage() {
            ++this.damageCount;
            this.lastDamageTime = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.lastDamageTime > 30000L;
        }

        public int getDamageCount() {
            return this.damageCount;
        }

        public void setDamageCount(int count) {
            this.damageCount = count;
        }

        public long getLastDamageTime() {
            return this.lastDamageTime;
        }

        public void setLastDamageTime(long time) {
            this.lastDamageTime = time;
        }

        public static DamageRecord fromNbt(int damageCount, long lastDamageTime) {
            DamageRecord record = new DamageRecord(true);
            record.setDamageCount(damageCount);
            record.setLastDamageTime(lastDamageTime);
            return record;
        }
    }

    public static enum RelationType {
        HOSTILE,
        NEUTRAL,
        FRIENDLY,
        CONTROL;

    }
}

