/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class ServerRelationHelper {
    public static boolean isEnemyRelation(class_1297 entity1, class_1297 entity2) {
        if (!(entity1 instanceof class_1309) || !(entity2 instanceof class_1309)) {
            return false;
        }
        UUID uuid1 = null;
        if (entity1 instanceof class_1657) {
            uuid1 = entity1.method_5667();
        } else if (entity1 instanceof BaseCombatSupport) {
            uuid1 = ((BaseCombatSupport)entity1).method_6139();
        }
        UUID uuid2 = null;
        if (entity2 instanceof class_1657) {
            uuid2 = entity2.method_5667();
        } else if (entity2 instanceof BaseCombatSupport) {
            uuid2 = ((BaseCombatSupport)entity2).method_6139();
        }
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return true;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        RelationSystem.RelationType relation2 = RelationSystem.getRelation(uuid2, uuid1);
        return relation1 == RelationSystem.RelationType.HOSTILE || relation2 == RelationSystem.RelationType.HOSTILE;
    }

    public static boolean hasControlOver(class_1657 player, class_1297 entity) {
        if (player.method_7337()) {
            return true;
        }
        if (!(entity instanceof BaseCombatSupport)) {
            return false;
        }
        UUID playerUUID = player.method_5667();
        BaseCombatSupport equipmentEntity = (BaseCombatSupport)entity;
        UUID entityOwnerUUID = equipmentEntity.method_6139();
        if (entityOwnerUUID != null && entityOwnerUUID.equals(playerUUID)) {
            return true;
        }
        if (entityOwnerUUID == null) {
            return false;
        }
        RelationSystem.RelationType ownerToPlayer = RelationSystem.getRelation(entityOwnerUUID, playerUUID);
        return ownerToPlayer == RelationSystem.RelationType.CONTROL;
    }

    public static boolean isNeutralRelation(class_1297 entity1, class_1297 entity2) {
        if (!(entity1 instanceof class_1309) || !(entity2 instanceof class_1309)) {
            return true;
        }
        UUID uuid1 = null;
        if (entity1 instanceof class_1657) {
            uuid1 = entity1.method_5667();
        } else if (entity1 instanceof BaseCombatSupport) {
            uuid1 = ((BaseCombatSupport)entity1).method_6139();
        }
        UUID uuid2 = null;
        if (entity2 instanceof class_1657) {
            uuid2 = entity2.method_5667();
        } else if (entity2 instanceof BaseCombatSupport) {
            uuid2 = ((BaseCombatSupport)entity2).method_6139();
        }
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return false;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        return relation1 == RelationSystem.RelationType.NEUTRAL;
    }

    public static boolean isFriendlyRelation(class_1297 entity1, class_1297 entity2) {
        if (!(entity1 instanceof class_1309) || !(entity2 instanceof class_1309)) {
            return false;
        }
        UUID uuid1 = null;
        if (entity1 instanceof class_1657) {
            uuid1 = entity1.method_5667();
        } else if (entity1 instanceof BaseCombatSupport) {
            uuid1 = ((BaseCombatSupport)entity1).method_6139();
        }
        UUID uuid2 = null;
        if (entity2 instanceof class_1657) {
            uuid2 = entity2.method_5667();
        } else if (entity2 instanceof BaseCombatSupport) {
            uuid2 = ((BaseCombatSupport)entity2).method_6139();
        }
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return false;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        return relation1 == RelationSystem.RelationType.FRIENDLY;
    }

    public static boolean isEnemyRelationByUUID(UUID uuid1, UUID uuid2) {
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return true;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        RelationSystem.RelationType relation2 = RelationSystem.getRelation(uuid2, uuid1);
        return relation1 == RelationSystem.RelationType.HOSTILE || relation2 == RelationSystem.RelationType.HOSTILE;
    }

    public static boolean isNeutralRelationByUUID(UUID uuid1, UUID uuid2) {
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return false;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        return relation1 == RelationSystem.RelationType.NEUTRAL;
    }
}

