/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.registry;

import com.chefmooon.frightsdelight.block.DrinkableFeastBlock;
import com.chefmooon.frightsdelight.block.SlimeApplePunch;
import com.chefmooon.frightsdelight.block.SoulBerryBushBlock;
import com.chefmooon.frightsdelight.block.WitherBerryBushBlock;
import com.chefmooon.frightsdelight.registry.ItemsRegistry;
import com.chefmooon.frightsdelight.registry.ParticleEffectsRegistry;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;

public enum BlocksRegistry {
    SOUL_BERRY_BUSH("soul_berry_bush", SoulBerryBushBlock::new, true, BlocksRegistry.flammable(100, 60)),
    WITHER_BERRY_BUSH("wither_berry_bush", WitherBerryBushBlock::new, true, BlocksRegistry.flammable(100, 60)),
    FLESH_CRATE("flesh_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    BONE_CRATE("bone_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    PHANTOM_CRATE("phantom_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    WEB_CRATE("web_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    SPIDER_EYE_CRATE("spider_eye_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    FERMENTED_SPIDER_EYE_CRATE("fermented_spider_eye_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    POISONOUS_POTATO_CRATE("poisonous_potato_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    ROTTEN_TOMATO_CRATE("rotten_tomato_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    PUNCHBOWL_SLIMEAPPLE("punchbowl_slimeapple", () -> new SlimeApplePunch(ItemsRegistry.PUNCH_SLIMEAPPLE.get(), ParticleEffectsRegistry.SLIME_BUBBLE.get()), true),
    PUNCHBOWL_SPIDEREYE("punchbowl_spidereye", () -> new DrinkableFeastBlock(ItemsRegistry.PUNCH_SPIDEREYE.get()), true),
    PUNCHBOWL_GHASTTEAR("punchbowl_ghasttear", () -> new DrinkableFeastBlock(ItemsRegistry.PUNCH_GHASTTEAR.get()), true),
    PUNCHBOWL_SOUL_BERRY("punchbowl_soul_berry", () -> new DrinkableFeastBlock(ItemsRegistry.PUNCH_SOUL_BERRY.get()), true),
    PUNCHBOWL_WITHER_BERRY("punchbowl_wither_berry", () -> new DrinkableFeastBlock(ItemsRegistry.PUNCH_WITHER_BERRY.get()), true);

    private final String pathName;
    private final Supplier<class_2248> blockSupplier;
    private final FlammableBlockRegistry.Entry flammableRate;
    private final boolean isCutout;
    private class_2248 block;

    private static FlammableBlockRegistry.Entry flammable(int burnChance, int spreadChance) {
        return new FlammableBlockRegistry.Entry(burnChance, spreadChance);
    }

    private static boolean isValidFlammableEntry(FlammableBlockRegistry.Entry flammableRate) {
        return flammableRate != null && flammableRate.getBurnChance() > 0 && flammableRate.getSpreadChance() > 0;
    }

    private BlocksRegistry(String pathName, Supplier<class_2248> blockSupplier) {
        this(pathName, blockSupplier, false, new FlammableBlockRegistry.Entry(0, 0));
    }

    private BlocksRegistry(String pathName, Supplier<class_2248> blockSupplier, boolean isCutout) {
        this(pathName, blockSupplier, isCutout, new FlammableBlockRegistry.Entry(0, 0));
    }

    private BlocksRegistry(String pathName, Supplier<class_2248> blockSupplier, boolean isCutout, FlammableBlockRegistry.Entry flammableRate) {
        this.pathName = pathName;
        this.blockSupplier = blockSupplier;
        this.flammableRate = flammableRate;
        this.isCutout = isCutout;
    }

    public static void registerAll() {
        for (BlocksRegistry value : BlocksRegistry.values()) {
            class_2248 block = value.get();
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("frightsdelight", value.pathName), (Object)block);
            if (!BlocksRegistry.isValidFlammableEntry(value.flammableRate)) continue;
            FlammableBlockRegistry.getDefaultInstance().add(block, (Object)value.flammableRate);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerRenderLayer() {
        for (BlocksRegistry value : BlocksRegistry.values()) {
            if (!value.isCutout) continue;
            BlockRenderLayerMap.INSTANCE.putBlock(value.get(), class_1921.method_23581());
        }
    }

    public class_2248 get() {
        if (this.block == null) {
            this.block = this.blockSupplier.get();
        }
        return this.block;
    }

    public String getId() {
        return class_7923.field_41175.method_10221((Object)this.get()).toString();
    }

    public String getPathName() {
        return this.pathName;
    }
}

