/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lairsmixedmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelPillagerWarden<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"lairsmixedmobs", (String)"model_pillager_warden"), "main");
    public final ModelPart Head2;
    public final ModelPart left_tendril;
    public final ModelPart right_tendril;
    public final ModelPart Body;
    public final ModelPart left_ribcage;
    public final ModelPart right_ribcage;
    public final ModelPart torso;
    public final ModelPart left_arm;
    public final ModelPart Arrow;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public ModelPillagerWarden(ModelPart root) {
        this.Head2 = root.getChild("Head2");
        this.left_tendril = this.Head2.getChild("left_tendril");
        this.right_tendril = this.Head2.getChild("right_tendril");
        this.Body = root.getChild("Body");
        this.left_ribcage = this.Body.getChild("left_ribcage");
        this.right_ribcage = this.Body.getChild("right_ribcage");
        this.torso = this.Body.getChild("torso");
        this.left_arm = root.getChild("left_arm");
        this.Arrow = this.left_arm.getChild("Arrow");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head2 = partdefinition.addOrReplaceChild("Head2", CubeListBuilder.create().texOffs(50, 0).addBox(-4.0f, -8.0f, -3.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(50, 18).addBox(-1.0f, -1.0f, -5.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)-1.0f));
        PartDefinition left_tendril = Head2.addOrReplaceChild("left_tendril", CubeListBuilder.create().texOffs(0, 60).addBox(-5.0f, -4.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)-13.0f, (float)1.0f));
        PartDefinition right_tendril = Head2.addOrReplaceChild("right_tendril", CubeListBuilder.create().texOffs(60, 18).addBox(-11.0f, -4.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-13.0f, (float)1.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create(), PartPose.offset((float)7.0f, (float)1.0f, (float)-5.0f));
        PartDefinition left_ribcage = Body.addOrReplaceChild("left_ribcage", CubeListBuilder.create().texOffs(56, 73).addBox(-6.0f, -10.0f, -0.1f, 5.0f, 19.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_ribcage = Body.addOrReplaceChild("right_ribcage", CubeListBuilder.create().texOffs(60, 52).addBox(-1.0f, -10.0f, -0.1f, 9.0f, 21.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-14.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = Body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -10.0f, -4.0f, 14.0f, 19.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 96).addBox(-7.5f, -11.0f, -4.5f, 15.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)2.0f, (float)4.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 30).addBox(-2.0f, -3.0f, -4.0f, 7.0f, 22.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.0f, (float)-5.0f, (float)0.0f));
        PartDefinition Arrow = left_arm.addOrReplaceChild("Arrow", CubeListBuilder.create().texOffs(122, 118).addBox(-3.5f, -5.0f, 0.0f, 6.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.25f, (float)-5.5f, (float)3.0f, (float)-0.4363f, (float)0.0f, (float)0.5672f));
        PartDefinition left_tendril_r1 = Arrow.addOrReplaceChild("left_tendril_r1", CubeListBuilder.create().texOffs(122, 118).addBox(-1.5f, -5.0f, 0.0f, 6.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(30, 30).addBox(-6.0f, -2.0f, -4.0f, 7.0f, 22.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-6.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(32, 60).addBox(-4.15f, 1.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.25f, (float)11.0f, (float)-1.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(60, 34).addBox(-2.1f, 1.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)11.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.Head2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.Head2.yRot = netHeadYaw / 57.295776f;
        this.Head2.xRot = headPitch / 57.295776f;
    }
}

