/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.backpacks.world.item;

import com.devnemo.nemos.backpacks.world.inventory.BackpackMenu;
import com.devnemo.nemos.backpacks.world.item.BackpackMaterial;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_3908;
import net.minecraft.class_5328;
import net.minecraft.class_747;
import net.minecraft.class_7923;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackItem
extends class_1792 {
    private static final class_2561 TITLE = class_2561.method_43471((String)"nemos_backpacks.container.backpack");
    private final BackpackMaterial backpackMaterial;

    public BackpackItem(class_1792.class_1793 properties, BackpackMaterial backpackMaterial) {
        super(properties);
        this.backpackMaterial = backpackMaterial;
    }

    @NotNull
    public class_1269 method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 interactionHand) {
        player.method_17355(this.createScreenHandlerFactory(player, interactionHand));
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        return class_1269.field_5812;
    }

    @Nullable
    public class_3908 createScreenHandlerFactory(class_1657 player, @NotNull class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        class_9323 components = itemStack.method_57353();
        class_9288 itemContainerContents = (class_9288)components.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        int slotCountPerRow = 9;
        class_1277 container = new class_1277(slotCountPerRow * this.getRowCount());
        List items = itemContainerContents.method_57489().toList();
        for (int i = 0; i < items.size(); ++i) {
            container.method_5447(i, (class_1799)items.get(i));
        }
        return new class_747((syncId, playerInventory, player1) -> switch (this.backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> BackpackMenu.defaultBackpack(syncId, playerInventory, itemStack, (class_1263)container);
            case BackpackMaterial.COPPER -> BackpackMenu.copperBackpack(syncId, playerInventory, itemStack, (class_1263)container);
            case BackpackMaterial.IRON -> BackpackMenu.ironBackpack(syncId, playerInventory, itemStack, (class_1263)container);
            case BackpackMaterial.GOLD -> BackpackMenu.goldenBackpack(syncId, playerInventory, itemStack, (class_1263)container);
            case BackpackMaterial.DIAMOND -> BackpackMenu.diamondBackpack(syncId, playerInventory, itemStack, (class_1263)container);
            case BackpackMaterial.NETHERITE -> BackpackMenu.netheriteBackpack(syncId, playerInventory, itemStack, (class_1263)container);
        }, TITLE);
    }

    public void method_33261(class_1542 itemEntity) {
        class_9288 itemContainerContents = (class_9288)this.method_57347().method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        itemEntity.method_6983().method_57379(class_9334.field_49622, (Object)class_9288.field_49334);
        class_5328.method_33263((class_1542)itemEntity, (Iterable)itemContainerContents.method_59715());
    }

    private int getRowCount() {
        return switch (this.backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> 1;
            case BackpackMaterial.COPPER -> 2;
            case BackpackMaterial.IRON -> 3;
            case BackpackMaterial.GOLD -> 4;
            case BackpackMaterial.DIAMOND -> 5;
            case BackpackMaterial.NETHERITE -> 6;
        };
    }

    public static class_1792 getByColorAndBackpackMaterial(class_1767 color, BackpackMaterial backpackMaterial) {
        class_2960 resourceLocation = class_2960.method_60655((String)"nemos_backpacks", (String)BackpackItem.getItemName(color, backpackMaterial));
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(resourceLocation);
        if (item == class_1802.field_8162) {
            throw new IllegalArgumentException("Missing item: " + String.valueOf(resourceLocation));
        }
        return item;
    }

    public static class_1792 getByBackpackMaterial(BackpackMaterial backpackMaterial) {
        class_2960 resourceLocation = class_2960.method_60655((String)"nemos_backpacks", (String)BackpackItem.getItemName(backpackMaterial));
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(resourceLocation);
        if (item == class_1802.field_8162) {
            throw new IllegalArgumentException("Missing item: " + String.valueOf(resourceLocation));
        }
        return item;
    }

    private static String getItemName(class_1767 color, BackpackMaterial backpackMaterial) {
        String materialPrefix = switch (backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> "";
            case BackpackMaterial.COPPER -> "copper";
            case BackpackMaterial.IRON -> "iron";
            case BackpackMaterial.GOLD -> "golden";
            case BackpackMaterial.DIAMOND -> "diamond";
            case BackpackMaterial.NETHERITE -> "netherite";
        };
        return color.method_7792() + (String)(!materialPrefix.isEmpty() ? "_" + materialPrefix : "") + "_backpack";
    }

    private static String getItemName(BackpackMaterial backpackMaterial) {
        String materialPrefix = switch (backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> "";
            case BackpackMaterial.COPPER -> "copper";
            case BackpackMaterial.IRON -> "iron";
            case BackpackMaterial.GOLD -> "golden";
            case BackpackMaterial.DIAMOND -> "diamond";
            case BackpackMaterial.NETHERITE -> "netherite";
        };
        return (String)(!materialPrefix.isEmpty() ? materialPrefix + "_" : "") + "backpack";
    }
}

