/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.dawnoftime.armoroftheages.client.ArmorModelSupplier;
import org.jetbrains.annotations.NotNull;

public abstract class ArmorModel<T extends LivingEntity>
extends HumanoidModel<T>
implements ArmorModelSupplier {
    public final boolean isSlim;

    public ArmorModel(ModelPart root, boolean isSlim) {
        super(root);
        this.isSlim = isSlim;
    }

    protected abstract void setupArmorPartAnim(float var1, float var2, float var3, float var4, float var5);

    public static MeshDefinition templateLayerDefinition(float scale) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)(0.0f + scale), (float)0.0f));
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)(0.0f + scale), (float)0.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)(0.0f + scale), (float)0.0f));
        root.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)(2.0f + scale), (float)0.0f));
        root.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.0f, (float)(2.0f + scale), (float)0.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.9f, (float)(12.0f + scale), (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.9f, (float)(12.0f + scale), (float)0.0f));
        return mesh;
    }

    public void m_6973_(@NotNull LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof ArmorStand) {
            ArmorStand entityAS = (ArmorStand)entity;
            float f = (float)Math.PI / 180;
            this.f_102808_.f_104203_ = f * entityAS.m_31680_().m_123156_();
            this.f_102808_.f_104204_ = f * entityAS.m_31680_().m_123157_();
            this.f_102808_.f_104205_ = f * entityAS.m_31680_().m_123158_();
            this.f_102810_.f_104203_ = f * entityAS.m_31685_().m_123156_();
            this.f_102810_.f_104204_ = f * entityAS.m_31685_().m_123157_();
            this.f_102810_.f_104205_ = f * entityAS.m_31685_().m_123158_();
            this.f_102812_.f_104203_ = f * entityAS.m_31688_().m_123156_();
            this.f_102812_.f_104204_ = f * entityAS.m_31688_().m_123157_();
            this.f_102812_.f_104205_ = f * entityAS.m_31688_().m_123158_();
            this.f_102811_.f_104203_ = f * entityAS.m_31689_().m_123156_();
            this.f_102811_.f_104204_ = f * entityAS.m_31689_().m_123157_();
            this.f_102811_.f_104205_ = f * entityAS.m_31689_().m_123158_();
            this.f_102814_.f_104203_ = f * entityAS.m_31691_().m_123156_();
            this.f_102814_.f_104204_ = f * entityAS.m_31691_().m_123157_();
            this.f_102814_.f_104205_ = f * entityAS.m_31691_().m_123158_();
            this.f_102813_.f_104203_ = f * entityAS.m_31694_().m_123156_();
            this.f_102813_.f_104204_ = f * entityAS.m_31694_().m_123157_();
            this.f_102813_.f_104205_ = f * entityAS.m_31694_().m_123158_();
        } else {
            this.setupArmorPartAnim(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public static float sinPI(float f) {
        return Mth.m_14031_((float)(f * (float)Math.PI));
    }

    public static float cosPI(float f) {
        return Mth.m_14089_((float)(f * (float)Math.PI));
    }

    public <M extends HumanoidModel<? extends LivingEntity>> void copyEntityModelPosition(M parentModel) {
        this.f_102815_ = parentModel.f_102815_;
        this.f_102816_ = parentModel.f_102816_;
        this.f_102817_ = parentModel.f_102817_;
        this.f_102808_.m_104315_(parentModel.f_102808_);
        this.f_102809_.m_104315_(parentModel.f_102809_);
        this.f_102810_.m_104315_(parentModel.f_102810_);
        this.f_102811_.m_104315_(parentModel.f_102811_);
        this.f_102812_.m_104315_(parentModel.f_102812_);
        this.f_102813_.m_104315_(parentModel.f_102813_);
        this.f_102814_.m_104315_(parentModel.f_102814_);
    }
}

