/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.dawnoftime.armoroftheages.ArmorOfTheAgesForge;
import org.dawnoftime.armoroftheages.config.AOTAConfig;
import org.dawnoftime.armoroftheages.loot.LootTablesToModify;
import org.jetbrains.annotations.NotNull;

public class AmorOfTheAgesLootModifiersForge
extends LootModifier {
    public static final Supplier<Codec<AmorOfTheAgesLootModifiersForge>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> AmorOfTheAgesLootModifiersForge.codecStart((RecordCodecBuilder.Instance)instance).and((App)Codec.STRING.fieldOf("armor_name").forGetter(m -> m.armorSetName)).and((App)Codec.FLOAT.fieldOf("armor_state").forGetter(m -> Float.valueOf(m.state))).apply((Applicative)instance, AmorOfTheAgesLootModifiersForge::new)));
    private final String armorSetName;
    private final float state;
    private final Random RANDOM = new Random();

    public AmorOfTheAgesLootModifiersForge(LootItemCondition[] conditionsIn, String armorSetName, float state) {
        super(conditionsIn);
        this.armorSetName = armorSetName;
        this.state = state;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext lootContext) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)lootContext)) continue;
            return generatedLoot;
        }
        boolean shouldGenerate = LootTablesToModify.ARMOR_GENERATION_MAP.getOrDefault(this.armorSetName, false);
        if (AOTAConfig.get().generateArmorLoot && shouldGenerate) {
            List<ResourceLocation> armorPieceLocations = ArmorOfTheAgesForge.ItemRegistryImpl.ARMORS_LOCATION_FROM_NAME.get(this.armorSetName);
            Item armorPieceItem = (Item)BuiltInRegistries.f_257033_.m_7745_(armorPieceLocations.get(this.RANDOM.nextInt(armorPieceLocations.size())));
            ItemStack armorPieceItemStack = new ItemStack((ItemLike)armorPieceItem);
            generatedLoot.add((Object)this.addDamage(armorPieceItemStack, lootContext));
        }
        return generatedLoot;
    }

    public ItemStack addDamage(ItemStack itemStack, LootContext lootContext) {
        if (itemStack.m_41763_()) {
            ConstantValue damage = ConstantValue.m_165692_((float)this.state);
            int i = itemStack.m_41776_();
            float f = 0.0f;
            float g = 1.0f - Mth.m_14036_((float)(damage.m_142688_(lootContext) + f), (float)0.0f, (float)1.0f);
            itemStack.m_41721_(Mth.m_14143_((float)(g * (float)i)));
        }
        return itemStack;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

